/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.datatypes.values;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CollectionValue
extends BasePersistedValue {
    private DataTypeInterface partialDataType;

    public DataTypeInterface getPartialDataType() {
        return this.partialDataType;
    }

    public void setPartialDataType(DataTypeInterface partialDataType) {
        this.partialDataType = partialDataType;
    }

    protected String getValueAsString(Object value) {
        return this.getPartialDataType().getPersistanceString(value);
    }

    protected Object coerseValueFromString(String text) {
        return this.getPartialDataType().coerceValueFromPersistedString(text);
    }

    protected DataTypeInterface coerseDataTypeFromString(String dataTypeAsText) {
        return StringType.DEFAULT_INSTANCE;
    }

    @Override
    public String getDefinitionElementName() {
        return "Collection";
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Values");
        if (list != null && !list.isEmpty()) {
            ArrayList<Object> outputCollection = new ArrayList<Object>(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                BasePersistedValue value = (BasePersistedValue)list.get(i);
                outputCollection.add(value.getValue());
            }
            this.setValue(outputCollection);
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValue()) {
            super.writeDefinition(element, writingContext);
            List items = (List)this.getValue();
            ArrayList<PersistenceInterface> valueObjects = new ArrayList<PersistenceInterface>(items.size());
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                PersistenceInterface itemValue = ValueUtil.getPersistableValue(items.get(i));
                valueObjects.add(itemValue);
            }
            CollectionValue.writeRelatedObjects(valueObjects, element, writingContext, "Values");
        } else {
            this.getLogger2().debug("No value to write");
        }
    }
}

