/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.Wqefcb;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@SASScope
public class Wqeminfo {
    short msegcnt = 0;
    short mhdrl = 0;
    short mrsvd = 0;
    short mfuture = 0;
    byte mflg1 = 0;
    byte mflg2 = 0;
    byte mflg3 = 0;
    byte utype = 0;
    int macc = 0;
    int[] mlen = new int[20];
    int nseg = 0;
    int length = 16;
    Wqefcb fcb;
    static byte WQHTB = 0;
    static byte WQHTL = 1;
    static byte WQHTS = (byte)2;
    static byte WQHTC = (byte)3;
    static byte OTHER = (byte)4;
    byte[] bv;
    short[] sv;
    private String messageIndex;

    public Wqeminfo(Wqefcb fcb) {
        this.fcb = fcb;
        for (int i = 0; i < 20; ++i) {
            this.mlen[i] = 0;
        }
        if (fcb.utype == WQHTB) {
            this.bv = new byte[32];
            this.mhdrl = (short)32;
        } else if (fcb.utype == WQHTS) {
            this.sv = new short[16];
            this.mhdrl = (short)32;
        }
    }

    public synchronized void write(DataOutputStream stream) throws ShareNetException {
        try {
            int i;
            stream.writeShort(this.msegcnt);
            stream.writeShort(this.mfuture);
            stream.writeShort(this.mhdrl);
            stream.writeShort(this.mrsvd);
            stream.write(this.mflg1);
            stream.write(this.mflg2);
            stream.write(this.mflg3);
            stream.write(this.fcb.utype);
            stream.writeInt(this.macc);
            for (i = 0; i < this.nseg; ++i) {
                stream.writeInt(this.fcb.wmseg[i].len);
                stream.writeInt(this.fcb.waseg[i].len);
            }
            if (this.mhdrl != 0) {
                if (this.fcb.utype == WQHTS) {
                    for (i = 0; i < 16; ++i) {
                        stream.writeShort(this.sv[i]);
                    }
                } else if (this.fcb.utype == WQHTB) {
                    stream.write(this.bv, 0, 32);
                }
            }
            stream.flush();
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S292.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public synchronized void readMinfo(DataInputStream stream, int count) throws ShareNetException {
        try {
            int i;
            this.msegcnt = stream.readShort();
            this.mfuture = stream.readShort();
            this.mhdrl = stream.readShort();
            this.mrsvd = stream.readShort();
            this.mflg1 = stream.readByte();
            this.mflg2 = stream.readByte();
            this.mflg3 = stream.readByte();
            this.utype = stream.readByte();
            this.fcb.acc = this.macc = stream.readInt();
            for (i = 0; i < count; ++i) {
                this.mlen[i] = stream.readInt();
            }
            if (this.mhdrl != 0) {
                if (this.utype == WQHTS) {
                    for (i = 0; i < 16; ++i) {
                        this.sv[i] = stream.readShort();
                    }
                } else {
                    this.bv = new byte[this.mhdrl];
                    stream.readFully(this.bv, 0, this.mhdrl);
                }
            }
            if (count == 0) {
                for (i = 0; i < this.fcb.curnseg; ++i) {
                    this.fcb.waseg[i].len = 0;
                }
            } else {
                int j = 1;
                int n = this.fcb.curnseg;
                for (i = 0; i < n; ++i) {
                    this.fcb.waseg[i].len = this.mlen[j];
                    j += 2;
                }
            }
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S293.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }
}

