/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.io.EncoderInterface;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;

@SASScope
public class Sqpformat {
    static Integer intDate = 1;
    static Integer intDateTime = 3;
    static Integer intTime = 2;
    static Integer intInteger = 4;
    static Integer intMayBeInteger = 5;
    static Hashtable<String, Integer> formats = new Hashtable();
    static String[] prefixes;
    static Hashtable<String, Integer> suffixes;
    short name_len;
    String name;
    short wid;
    short ndec;
    boolean v6 = true;
    private EncoderInterface encoder = null;
    private String messageIndex;
    private static String separatorCharacters;

    public Sqpformat() {
    }

    public Sqpformat(boolean v6, EncoderInterface encoder) {
        this.v6 = v6;
        this.encoder = encoder;
    }

    public synchronized void read(DataInputStream stream) throws ShareNetException {
        if (!this.v6) {
            try {
                this.name_len = stream.readShort();
                byte[] buf = new byte[40];
                stream.readFully(buf, 0, 32);
                this.name = this.encoder.toString(buf, 0, 32);
                this.wid = stream.readShort();
                this.ndec = stream.readShort();
            }
            catch (IOException e) {
                this.messageIndex = "Sharenet.S267.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
                throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
        }
        try {
            byte[] buf = new byte[8];
            stream.readFully(buf, 0, 8);
            this.name = this.encoder.toString(buf, 0, 8);
            this.wid = stream.readShort();
            this.ndec = stream.readShort();
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S268.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public int findFormat(String inname) {
        String tstring = inname.trim();
        if (tstring.length() == 0) {
            if (this.ndec == 0 && this.wid != 0) {
                return 4;
            }
            return 0;
        }
        Integer temp = formats.get(tstring);
        int subtype = temp != null ? temp : 0;
        if (subtype == 5) {
            if (inname.indexOf("HEX") != -1) {
                if (this.wid != 16) {
                    return 4;
                }
                return 0;
            }
            if (this.ndec == 0) {
                return 4;
            }
        }
        if (subtype != 0) {
            return subtype;
        }
        subtype = Sqpformat.getIntl(inname);
        if (subtype != 0) {
            return subtype;
        }
        subtype = this.parseForSeparator(inname);
        return subtype;
    }

    public static int intepretFormat(String inname) {
        int length = (inname = inname.trim()).length();
        if (length == 0) {
            return 0;
        }
        char[] tchar = inname.toCharArray();
        if (Character.isDigit(tchar[0])) {
            if (tchar[length - 1] == '.') {
                return 4;
            }
            return 0;
        }
        if (inname.indexOf("HEX") != -1) {
            if (inname.indexOf("16") == -1) {
                return 4;
            }
            return 0;
        }
        for (int i = length - 1; i >= 0 && (tchar[i] == '.' || Character.isDigit(tchar[i])); --i) {
            tchar[i] = 32;
        }
        String tstring = new String(tchar);
        Integer temp = formats.get(tstring = tstring.trim());
        if (temp != null) {
            int subtype = temp;
            if (subtype == 5 && inname.charAt(length - 1) == '.') {
                subtype = 4;
            }
            return subtype;
        }
        return Sqpformat.getIntl(tstring);
    }

    public static int getIntl(String format) {
        if (format.length() < 8) {
            return 0;
        }
        String temp = format.substring(0, 3);
        for (int i = 0; i < 13; ++i) {
            if (!prefixes[i].equals(temp)) continue;
            String suffix = format.substring(3, 5);
            Integer subtype = suffixes.get(suffix);
            if (subtype != null) {
                return subtype;
            }
            return 0;
        }
        return 0;
    }

    public String getFormatName() {
        String formatName = this.name.trim();
        if (this.wid != 0) {
            formatName = formatName + this.wid;
        }
        if (!formatName.equals("")) {
            formatName = formatName + ".";
        }
        if (this.ndec != 0) {
            formatName = formatName + this.ndec;
        }
        return formatName;
    }

    public int parseForSeparator(String inname) {
        int subtype = 0;
        char sep = (inname = inname.trim()).charAt(inname.length() - 1);
        if (separatorCharacters.indexOf(sep) > -1) {
            String sz = inname.substring(0, inname.length() - 1);
            if (sep == 'B' && !sz.equalsIgnoreCase("MMDDYY") && !sz.equalsIgnoreCase("YYMMDD")) {
                return 0;
            }
            Integer temp = formats.get(sz);
            subtype = temp != null ? temp : 0;
        }
        return subtype;
    }

    static {
        formats.put("DATE", intDate);
        formats.put("DATETIME", intDateTime);
        formats.put("DAY", intDate);
        formats.put("DDMMYY", intDate);
        formats.put("DOWNAME", intDate);
        formats.put("HHMM", intTime);
        formats.put("HOUR", intTime);
        formats.put("JULDAY", intDate);
        formats.put("JULIAN", intDate);
        formats.put("MINGUO", intDate);
        formats.put("MMDDYY", intDate);
        formats.put("MMSS", intTime);
        formats.put("MMYY", intDate);
        formats.put("MONNAME", intDate);
        formats.put("MONTH", intDate);
        formats.put("MONYY", intDate);
        formats.put("NENGO", intDate);
        formats.put("QTR", intDate);
        formats.put("QTRR", intDate);
        formats.put("TIME", intTime);
        formats.put("TOD", intDateTime);
        formats.put("WEEKDATE", intDate);
        formats.put("WEEKDATX", intDate);
        formats.put("WEEKDAY", intDate);
        formats.put("WORDDATE", intDate);
        formats.put("WORDDATX", intDate);
        formats.put("YEAR", intDate);
        formats.put("YYMM", intDate);
        formats.put("YYMMDD", intDate);
        formats.put("YYMON", intDate);
        formats.put("YYQ", intDate);
        formats.put("YYQR", intDate);
        formats.put("WEEKU", intDate);
        formats.put("WEEKV", intDate);
        formats.put("WEEKW", intDate);
        formats.put("BINARY", intInteger);
        formats.put("COMMA", intMayBeInteger);
        formats.put("COMMAX", intMayBeInteger);
        formats.put("DOLLAR", intMayBeInteger);
        formats.put("DOLLARX", intMayBeInteger);
        formats.put("HEX", intMayBeInteger);
        formats.put("IB", intMayBeInteger);
        formats.put("OCTAL", intInteger);
        formats.put("PIB", intMayBeInteger);
        formats.put("ROMAN", intInteger);
        formats.put("SSN", intInteger);
        formats.put("Z", intMayBeInteger);
        formats.put("F", intMayBeInteger);
        formats.put("DTYEAR", intDateTime);
        formats.put("DTWKDATX", intDateTime);
        formats.put("DTYYQC", intDateTime);
        formats.put("DATEAMPM", intDateTime);
        formats.put("TIMEAMPM", intTime);
        formats.put("DTDATE", intDateTime);
        formats.put("DTMONYY", intDateTime);
        formats.put("JDATEMD", intDate);
        formats.put("JDATEMDW", intDate);
        formats.put("JDATEMNW", intDate);
        formats.put("JDATEMON", intDate);
        formats.put("JDATEQRW", intDate);
        formats.put("JDATEQTR", intDate);
        formats.put("JDATESEM", intDate);
        formats.put("JDATESMW", intDate);
        formats.put("JDATEWK", intDate);
        formats.put("JDATEYDW", intDate);
        formats.put("JDATEYM", intDate);
        formats.put("JDATEYMD", intDate);
        formats.put("JDATEYMW", intDate);
        formats.put("JDATEYT", intDateTime);
        formats.put("JDATEYTW", intDateTime);
        formats.put("JNENGO", intDate);
        formats.put("JNENGOT", intDateTime);
        formats.put("JNENGOTW", intDateTime);
        formats.put("JNENGOW", intDate);
        formats.put("IS8601DA", intDate);
        formats.put("IS8601DN", intDateTime);
        formats.put("IS8601DT", intDateTime);
        formats.put("IS8601DZ", intDateTime);
        formats.put("JULDATE", intDate);
        formats.put("MDYAMPM", intDateTime);
        formats.put("NLDATE", intDate);
        formats.put("NLDATEMN", intDate);
        formats.put("NLDATEW", intDate);
        formats.put("NLDATEWN", intDate);
        formats.put("NLDATM", intDateTime);
        formats.put("NLDATMAP", intDateTime);
        formats.put("NLDATMTM", intDateTime);
        formats.put("NLDATMW", intDateTime);
        formats.put("TWMDY", intDateTime);
        formats.put("XYYMMDD", intDate);
        formats.put("IS8601LZ", intTime);
        formats.put("IS8601TM", intTime);
        formats.put("IS8601TZ", intTime);
        formats.put("JTIMEH", intTime);
        formats.put("JTIMEHM", intTime);
        formats.put("JTIMEHMS", intTime);
        formats.put("JTIMEHW", intTime);
        formats.put("JTIMEMW", intTime);
        formats.put("JTIMESW", intTime);
        formats.put("NLTIME", intTime);
        formats.put("NLTIMAP", intTime);
        formats.put("EURDFDD", intDate);
        prefixes = new String[13];
        Sqpformat.prefixes[0] = "DAN";
        Sqpformat.prefixes[1] = "DES";
        Sqpformat.prefixes[2] = "DEU";
        Sqpformat.prefixes[3] = "ESP";
        Sqpformat.prefixes[4] = "EUR";
        Sqpformat.prefixes[5] = "FIN";
        Sqpformat.prefixes[6] = "FRA";
        Sqpformat.prefixes[7] = "FRS";
        Sqpformat.prefixes[8] = "ITA";
        Sqpformat.prefixes[9] = "NLD";
        Sqpformat.prefixes[10] = "NOR";
        Sqpformat.prefixes[11] = "PTG";
        Sqpformat.prefixes[12] = "SVE";
        suffixes = new Hashtable();
        suffixes.put("DFDD", intDate);
        suffixes.put("DFDE", intDate);
        suffixes.put("DFDN", intDate);
        suffixes.put("DFDT", intDateTime);
        suffixes.put("DFDWN", intDate);
        suffixes.put("DFMN", intDate);
        suffixes.put("DFMY", intDate);
        suffixes.put("DFWDX", intDate);
        suffixes.put("DFWKX", intDate);
        separatorCharacters = "BCDNPS";
    }
}

