/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.SqlField;
import com.sas.net.sharenet.SqlValue;
import java.io.DataInputStream;
import java.io.IOException;

class SqpNumericValue
extends SqlValue {
    protected double value = 0.0;
    private String messageIndex;

    public SqpNumericValue(SqlField v) {
        super(v);
    }

    public SqpNumericValue(SqlField v, int invalue) {
        super(v);
        this.value = invalue;
    }

    public SqpNumericValue(SqlField v, short invalue) {
        super(v);
        this.value = invalue;
    }

    public SqpNumericValue(SqlField v, boolean invalue) {
        super(v);
        this.value = invalue ? 1.0 : 0.0;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public boolean isTruncated() {
        return false;
    }

    public String toString() {
        if (this.missing) {
            return ".";
        }
        return String.valueOf(this.value);
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public synchronized void read(DataInputStream stream) throws ShareNetException {
        try {
            this.value = stream.readDouble();
        }
        catch (IOException e) {
            this.messageIndex = "Sharenet.S269.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        if (Double.isNaN(this.value)) {
            this.missing = true;
        }
    }
}

