/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.net.sharenet.ShareNetSQLTypeConversionException;
import com.sas.net.sharenet.SqlField;
import com.sas.net.sharenet.SqpNumericValue;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

class SqpDateTimeValue
extends SqpNumericValue {
    static final double JAVA_DATE_EPOCH = 3653.0;
    static long MAX_SASTIME = 86400L;
    static final double JAVA_DATETIME_EPOCH = 3653.0 * (double)MAX_SASTIME * 1000.0;
    static final long JAVA_DAY = MAX_SASTIME * 1000L;
    static final long Y4K_LEAPDAY = Date.valueOf("4000-02-29").getTime();
    static final long Y8K_LEAPDAY = Date.valueOf("8000-02-29").getTime();
    long javadate = 0L;
    private final int sqlType;

    public SqpDateTimeValue(SqlField v) {
        super(v);
        this.sqlType = 91;
    }

    public SqpDateTimeValue(SqlField v, boolean setdate, boolean settime) {
        super(v);
        if (setdate && settime) {
            this.sqlType = 93;
        } else if (setdate) {
            this.sqlType = 91;
        } else if (settime) {
            this.sqlType = 92;
        } else {
            throw new RuntimeException("invalid flags in SqpDateTimeValue");
        }
    }

    public boolean isDate() {
        return this.sqlType == 91;
    }

    public boolean isTime() {
        return this.sqlType == 92;
    }

    public boolean isDateTime() {
        return this.sqlType == 93;
    }

    private long calcJavaDate(double value, boolean date, boolean time, Calendar cal) {
        double sasdate = value;
        long javaMilliseconds = 0L;
        if (date && time) {
            sasdate = sasdate * 1000.0 - JAVA_DATETIME_EPOCH;
        } else if (date) {
            sasdate = sasdate * (double)MAX_SASTIME * 1000.0 - JAVA_DATETIME_EPOCH;
        } else if (time) {
            sasdate *= 1000.0;
        }
        TimeZone tz = null;
        tz = cal == null ? TimeZone.getDefault() : cal.getTimeZone();
        javaMilliseconds = (long)Math.floor(sasdate);
        int off = tz.getOffset(javaMilliseconds);
        javaMilliseconds -= (long)off;
        if (date) {
            javaMilliseconds = this.alignCalendarToJavaDates(javaMilliseconds);
        }
        return javaMilliseconds;
    }

    private double dateToDouble(Date x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        value += JAVA_DATETIME_EPOCH;
        value = this.alignCalendarToSASDates(value);
        return value / (double)(1000L * MAX_SASTIME);
    }

    private double timestampToDouble(Timestamp x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        value += JAVA_DATETIME_EPOCH;
        value = this.alignCalendarToSASDates(value);
        return value / 1000.0;
    }

    private double timeToDouble(Time x) {
        double value = x.getTime();
        value = this.adjustForTimeZone(value);
        return value / 1000.0;
    }

    private double adjustForTimeZone(double value) {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        value = (long)Math.floor(value);
        int off = tz.getOffset((long)value);
        return value += (double)off;
    }

    private double alignCalendarToSASDates(double value) {
        if (value >= (double)Y4K_LEAPDAY && (value -= (double)JAVA_DAY) >= (double)Y8K_LEAPDAY) {
            value -= (double)JAVA_DAY;
        }
        return value;
    }

    private long alignCalendarToJavaDates(long value) {
        if (value >= Y4K_LEAPDAY && (value += JAVA_DAY) >= Y8K_LEAPDAY) {
            value += JAVA_DAY;
        }
        return value;
    }

    @Override
    public Date getDate() throws SQLException {
        return this.getDate(null);
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isMissing()) {
            return null;
        }
        if (this.sqlType == 92) {
            throw new ShareNetSQLTypeConversionException("DATE");
        }
        if (this.sqlType == 91) {
            long javaMilliseconds = this.calcJavaDate(this.value, true, false, cal);
            return new Date(javaMilliseconds);
        }
        long javaMilliseconds = this.calcJavaDate(this.value, true, true, cal);
        return new Date(javaMilliseconds);
    }

    @Override
    public Time getTime() throws SQLException {
        return this.getTime(null);
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isMissing()) {
            return null;
        }
        if (this.sqlType == 91) {
            throw new ShareNetSQLTypeConversionException("TIME");
        }
        if (this.sqlType == 92) {
            long javaMilliseconds = this.calcJavaDate(this.value, false, true, cal);
            return new Time(javaMilliseconds);
        }
        long javaMilliseconds = this.calcJavaDate(this.value, true, true, cal);
        return new Time(javaMilliseconds);
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(null);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isMissing()) {
            return null;
        }
        if (this.sqlType == 91) {
            long javaMilliseconds = this.calcJavaDate(this.value, true, false, cal);
            return new Timestamp(javaMilliseconds);
        }
        if (this.sqlType == 92) {
            throw new ShareNetSQLTypeConversionException("TIMESTAMP");
        }
        assert (this.sqlType == 93);
        long javaMilliseconds = this.calcJavaDate(this.value, true, true, cal);
        return new Timestamp(javaMilliseconds);
    }
}

