/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.SqlField;
import com.sas.net.sharenet.SqlValue;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class SqpCharacterValue
extends SqlValue {
    private boolean truncated = false;
    protected String value;
    private String shareEncoding = null;

    public SqpCharacterValue(SqlField v, boolean truncated, String shareEncoding) {
        super(v);
        this.truncated = truncated;
        this.shareEncoding = shareEncoding;
    }

    public SqpCharacterValue(SqlField v, String invalue) {
        super(v);
        this.value = invalue;
    }

    @Override
    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public boolean isMissing() {
        return this.value == null;
    }

    public String toString() {
        return this.value;
    }

    public String toSQLString(int len) {
        String temp = this.value;
        if (temp == null) {
            return null;
        }
        if (temp.length() > len) {
            temp = temp.substring(0, len);
        }
        return temp;
    }

    public Object toSQLType() {
        String temp = this.value;
        return temp;
    }

    @Override
    public synchronized void read(DataInputStream stream) throws ShareNetException {
        byte[] buf = new byte[this.field.len];
        try {
            stream.readFully(buf, 0, this.field.len);
        }
        catch (IOException e) {
            String messageIndex = "Sharenet.S266.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new ShareNetException(-1, ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        EncoderInterface encoder = null;
        try {
            encoder = Encoder.getInstance((String)this.shareEncoding);
        }
        catch (UnsupportedEncodingException e) {
            String messageIndex = "Sharenet.S461.ex.txt";
            Object[] messageArg = new Object[]{messageIndex, this.shareEncoding};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        this.value = encoder.toString(buf, 0, this.field.len);
        Encoder.returnInstance((EncoderInterface)encoder);
    }

    @Override
    public Date getDate() throws SQLException {
        try {
            Date d = Date.valueOf(this.value);
            return d;
        }
        catch (IllegalArgumentException iae) {
            int vendorCode = 167;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "DATE"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Not a valid {1} value.", messageArg), null, vendorCode);
        }
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        Date d1 = this.getDate();
        Date d2 = new Date(d1.getTime() + (long)cal.getTimeZone().getOffset(d1.getTime()));
        return d2;
    }

    @Override
    public Time getTime() throws SQLException {
        try {
            Time t = Time.valueOf(this.value);
            return t;
        }
        catch (IllegalArgumentException iae) {
            int vendorCode = 171;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "TIME"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Not a valid {1} value.", messageArg), null, vendorCode);
        }
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        Time t1 = this.getTime();
        Time t2 = new Time(t1.getTime() + (long)cal.getTimeZone().getOffset(t1.getTime()));
        return t2;
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        try {
            Timestamp t = Timestamp.valueOf(this.value);
            return t;
        }
        catch (IllegalArgumentException iae) {
            int vendorCode = 175;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, "TIMESTAMP"};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Not a valid {1} value.", messageArg), null, vendorCode);
        }
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        Timestamp t1 = this.getTimestamp();
        Timestamp t2 = new Timestamp(t1.getTime() + (long)cal.getTimeZone().getOffset(t1.getTime()));
        return t2;
    }
}

