/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetStatement;
import com.sas.net.sharenet.SqlField;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

@SASScope(value="ALL")
public class ShareNetResultSetMetaData
implements ResultSetMetaData {
    private final SqlField[] fields;
    private final int maxFieldSize;

    @SASScope
    public ShareNetResultSetMetaData(SqlField[] infields, ShareNetStatement stmt) throws SQLException {
        if (infields == null) {
            int vendorCode = 183;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: No results from query.", messageArg), null, vendorCode);
        }
        this.fields = infields;
        this.maxFieldSize = stmt == null ? 200 : stmt.maxFieldSize;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 185;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 186;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        return type == 12;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 187;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 188;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 189;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        if (type == 12) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 190;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        return type != 12 && type != -7;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 191;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        switch (type) {
            case 1: 
            case 12: {
                int temp = this.fields[column - 1].getLength();
                if (temp > this.maxFieldSize) {
                    return this.maxFieldSize;
                }
                return temp;
            }
            case -7: {
                return 1;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 209;
            }
            case 7: {
                return 13;
            }
            case 6: 
            case 8: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 21;
            }
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 192;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return this.fields[column - 1].getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 193;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return this.fields[column - 1].getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 194;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 195;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        switch (type) {
            case 1: 
            case 12: {
                return this.fields[column - 1].getLength();
            }
            case -7: {
                return 1;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 7: {
                return 7;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 21;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 196;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 197;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 198;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 199;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        int type = this.fields[column - 1].getSQLType();
        return type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 200;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return this.fields[column - 1].format.getFormatName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 201;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 202;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 203;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        Object colObj;
        if (column < 1 || column > this.fields.length) {
            int vendorCode = 199;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Column value is not valid.", messageArg), null, vendorCode);
        }
        block0 : switch (this.fields[column - 1].getSQLType()) {
            case 93: {
                colObj = new Timestamp(0L);
                break;
            }
            case 91: {
                colObj = new Date(0L);
                break;
            }
            case 92: {
                colObj = new Time(0L);
                break;
            }
            case 12: {
                colObj = "";
                break;
            }
            default: {
                switch (this.fields[column - 1].getSQLType()) {
                    case -7: {
                        colObj = Boolean.TRUE;
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        colObj = Integer.MAX_VALUE;
                        break block0;
                    }
                }
                colObj = Double.MAX_VALUE;
            }
        }
        return colObj.getClass().getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: unwrap operation failed; input parameter is null.", new Object[]{"Sharenet.S586.ex.txt"}), null, 586);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException(ShareLocalizedError.getLocalizedError("unwrap operation failed; class {1} does not implement {2}", new Object[]{"Sharenet.S587.ex.txt", iface.getName(), this.getClass().getName()}), null, 587);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

