/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetConnection;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import com.sas.net.sharenet.ShareNetStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

@SASScope(value="ALL")
public class ShareNetPreparedStatement
extends ShareNetStatement
implements PreparedStatement {
    private final SimpleDateFormat sdfSasDate = new SimpleDateFormat("dd-MMM-yyyy");
    private final SimpleDateFormat sdfSasTime = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat sdfSasDateTime = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private final SimpleDateFormat sdfSasDateUserTZ = new SimpleDateFormat("dd-MMM-yyyy");
    private final SimpleDateFormat sdfSasTimeUserTZ = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat sdfSasDateTimeUserTZ = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private String sqlquery;
    private String subsquery;
    private String[] parameters;
    private boolean[] nullValue;
    private int parmCount = 0;

    @SASScope
    public ShareNetPreparedStatement(ShareNetConnection inconnection, String sql) {
        super(inconnection);
        int inquotes = -1;
        this.sqlquery = sql == null || sql.length() == 0 ? "" : sql;
        int length = sql.length();
        for (int b = 0; b < length; ++b) {
            if (sql.charAt(b) == '\'' || sql.charAt(b) == '\"') {
                if (inquotes == -1) {
                    inquotes = sql.charAt(b);
                } else if (inquotes == sql.charAt(b)) {
                    inquotes = -1;
                }
            }
            if (sql.charAt(b) != '?' || inquotes != -1) continue;
            ++this.parmCount;
        }
        this.parameters = new String[this.parmCount];
        this.nullValue = new boolean[this.parmCount];
        for (int i = 0; i < this.parmCount; ++i) {
            this.nullValue[i] = false;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.subsquery = this.substituteParameters();
        super.executeQuery(this.subsquery);
        return this.snresultset;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.subsquery = this.substituteParameters();
        return super.executeUpdate(this.subsquery);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkAccess(parameterIndex);
        if (sqlType == 6 || sqlType == 8 || sqlType == 4 || sqlType == 92 || sqlType == 91 || sqlType == 93) {
            String tempString;
            this.parameters[parameterIndex - 1] = tempString = ".";
        } else if (sqlType == 12 || sqlType == -1 || sqlType == 1) {
            this.parameters[parameterIndex - 1] = " '' ";
        } else {
            int vendorCode = 99;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot set to NULL.", messageArg), null, vendorCode);
        }
        this.nullValue[parameterIndex - 1] = true;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        int vendorCode = 100;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "BIT"}), null, vendorCode);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        int vendorCode = 101;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "TINYINT"}), null, vendorCode);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        int vendorCode = 102;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "SMALLINT"}), null, vendorCode);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkAccess(parameterIndex);
        this.parameters[parameterIndex - 1] = String.valueOf(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        int vendorCode = 104;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "BigInt"}), null, vendorCode);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        String tempString;
        this.checkAccess(parameterIndex);
        if (Float.isNaN(x)) {
            this.setNull(parameterIndex, 6);
            return;
        }
        this.parameters[parameterIndex - 1] = tempString = String.valueOf(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        String tempString;
        this.checkAccess(parameterIndex);
        if (Double.isNaN(x)) {
            this.setNull(parameterIndex, 8);
            return;
        }
        this.parameters[parameterIndex - 1] = tempString = String.valueOf(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        int vendorCode = 107;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "Numeric"}), null, vendorCode);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        if (x.indexOf("'") > -1) {
            boolean done = false;
            String esc = x;
            int index = 0;
            while (!done) {
                String y = esc.substring(0, esc.indexOf("'", index));
                String z = esc.substring(esc.indexOf("'", index), esc.length());
                index = esc.indexOf("'", index);
                esc = y + "'" + z;
                if (esc.indexOf("'", index += 2) >= 0) continue;
                done = true;
            }
            this.parameters[parameterIndex - 1] = "'" + esc + "'";
        } else {
            this.parameters[parameterIndex - 1] = "'" + x + "'";
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        int vendorCode = 109;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "BINARY"}), null, vendorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasDate;
        synchronized (simpleDateFormat) {
            String tempString;
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasDate.format(x) + "'d ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 92);
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasTime;
        synchronized (simpleDateFormat) {
            String tempString;
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasTime.format(x) + "'t ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasDateTime;
        synchronized (simpleDateFormat) {
            String tempString;
            int nanos = x.getNanos();
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasDateTime.format(x) + "." + String.format("%09d", nanos) + "'dt ";
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int vendorCode = 113;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "LONGVARCHAR"}), null, vendorCode);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int vendorCode = 114;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "LONGVARCHAR"}), null, vendorCode);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        int vendorCode = 115;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: SQL type {1} not supported.", new Object[]{messageIndex, "LONGVARBINARY"}), null, vendorCode);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.parmCount; ++i) {
            this.parameters[i] = null;
            this.nullValue[i] = false;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int sqlType, int scale) throws SQLException {
        this.checkAccess(parameterIndex);
        this.setObject(parameterIndex, x, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setObject(parameterIndex, x, -1);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof String || x instanceof Character) {
            this.setString(parameterIndex, x.toString());
            return;
        }
        if (x instanceof Integer || x instanceof Float || x instanceof Double) {
            String tempString;
            this.parameters[parameterIndex - 1] = tempString = x.toString();
            return;
        }
        int vendorCode = 117;
        String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int sqlType) throws SQLException {
        this.checkAccess(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, sqlType);
            return;
        }
        switch (sqlType) {
            case 4: 
            case 6: 
            case 8: {
                if (x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof String || x instanceof Character) {
                    String tempString;
                    this.parameters[parameterIndex - 1] = tempString = x.toString();
                    break;
                }
                int vendorCode = 119;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
            }
            case -1: 
            case 1: 
            case 12: {
                if (x instanceof Integer || x instanceof Float || x instanceof Double || x instanceof String || x instanceof Character || x instanceof Date || x instanceof Time || x instanceof Timestamp) {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                int vendorCode = 120;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
            }
            case 91: {
                Date tDate = null;
                if (x instanceof Timestamp) {
                    String s = x.toString();
                    tDate = Date.valueOf(s.substring(0, 10));
                } else if (x instanceof String) {
                    tDate = Date.valueOf(x.toString());
                } else if (x instanceof Date) {
                    tDate = (Date)x;
                } else {
                    int vendorCode = 121;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
                }
                this.setDate(parameterIndex, tDate);
                break;
            }
            case 92: {
                Time tTime = null;
                if (x instanceof Timestamp) {
                    String s = x.toString();
                    tTime = Time.valueOf(s.substring(11, 19));
                } else if (x instanceof String) {
                    tTime = Time.valueOf(x.toString());
                } else if (x instanceof Time) {
                    tTime = (Time)x;
                } else {
                    int vendorCode = 122;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
                }
                this.setTime(parameterIndex, tTime);
                break;
            }
            case 93: {
                Timestamp tStamp = null;
                if (x instanceof Timestamp) {
                    tStamp = (Timestamp)x;
                } else if (x instanceof String) {
                    tStamp = Timestamp.valueOf(x.toString());
                } else if (x instanceof Date) {
                    long lTime = ((Date)x).getTime();
                    tStamp = new Timestamp(lTime);
                } else {
                    int vendorCode = 123;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
                }
                this.setTimestamp(parameterIndex, tStamp);
                break;
            }
            default: {
                int vendorCode = 124;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Unknown object type.", new Object[]{messageIndex}), null, vendorCode);
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.subsquery = this.substituteParameters();
        return super.execute(this.subsquery);
    }

    @Deprecated
    public ResultSetMetaData getResultSetMetaData() throws SQLException {
        this.checkClosed();
        return this.getMetaData();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        this.subsquery = this.substituteParameters();
        if (!this.isDescribe()) {
            boolean bl = super.execute(this.subsquery);
        }
        ResultSet rs = this.getResultSet();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            return rsmd;
        }
        catch (SQLException e) {
            int vendorCode = 125;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", new Object[]{messageIndex, e.getMessage()}), null, vendorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkAccess(parameterIndex);
        if (cal == null) {
            this.setDate(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasDateUserTZ;
        synchronized (simpleDateFormat) {
            String tempString;
            this.sdfSasDateUserTZ.setTimeZone(cal.getTimeZone());
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasDateUserTZ.format(x) + "'d ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkAccess(parameterIndex);
        if (cal == null) {
            this.setTime(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 92);
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasTimeUserTZ;
        synchronized (simpleDateFormat) {
            String tempString;
            this.sdfSasTimeUserTZ.setTimeZone(cal.getTimeZone());
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasTimeUserTZ.format(x) + "'t ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkAccess(parameterIndex);
        if (cal == null) {
            this.setTimestamp(parameterIndex, x);
            return;
        }
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        SimpleDateFormat simpleDateFormat = this.sdfSasDateTimeUserTZ;
        synchronized (simpleDateFormat) {
            String tempString;
            this.sdfSasDateTimeUserTZ.setTimeZone(cal.getTimeZone());
            int nanos = x.getNanos();
            this.parameters[parameterIndex - 1] = tempString = "'" + this.sdfSasDateTime.format(x) + "." + String.format("%09d", nanos) + "'dt ";
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    private synchronized String substituteParameters() throws SQLException {
        String query = "";
        int b = 0;
        int e = 0;
        int inquotes = -1;
        int length = this.sqlquery.length();
        block0: for (int i = 0; i < this.parmCount; ++i) {
            String parm = this.parameters[i];
            if (parm == null) {
                int vendorCode = 126;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(++i)};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: During substitution parameter {1} had no value.", messageArg), null, vendorCode);
            }
            while (e < length) {
                if (this.sqlquery.charAt(e) == '\'' || this.sqlquery.charAt(e) == '\"') {
                    if (inquotes == -1) {
                        inquotes = this.sqlquery.charAt(e);
                    } else if (inquotes == this.sqlquery.charAt(e)) {
                        inquotes = -1;
                    }
                }
                if (this.sqlquery.charAt(e) == '?' && inquotes == -1) {
                    query = query + this.sqlquery.substring(b, e) + parm;
                    b = e + 1;
                    ++e;
                    continue block0;
                }
                ++e;
            }
        }
        if (b < length) {
            query = query + this.sqlquery.substring(b);
        }
        return query;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    void checkClosed() throws SQLException {
        if (this.closed) {
            int vendorCode = 592;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: The ResultSet is closed.", messageArg), null, vendorCode);
        }
    }

    private void checkAccess(int parameterIndex) throws SQLException {
        this.checkClosed();
        if (parameterIndex < 1 || parameterIndex > this.parmCount) {
            int vendorCode = 98;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Invalid parameter index.", messageArg), null, vendorCode);
        }
    }
}

