/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.sharenet;

import com.sas.codepolicy.SASScope;
import com.sas.net.sharenet.Ans1;
import com.sas.net.sharenet.Defdestroy;
import com.sas.net.sharenet.Ebcdic;
import com.sas.net.sharenet.Msegexe;
import com.sas.net.sharenet.Rcmsg;
import com.sas.net.sharenet.Sconinfo;
import com.sas.net.sharenet.ShareLocalizedError;
import com.sas.net.sharenet.ShareNetDatabaseMetaData;
import com.sas.net.sharenet.ShareNetException;
import com.sas.net.sharenet.ShareNetPreparedStatement;
import com.sas.net.sharenet.ShareNetSQLFeatureNotSupportedException;
import com.sas.net.sharenet.ShareNetStatement;
import com.sas.net.sharenet.ShareNetWarning;
import com.sas.net.sharenet.Tcpmsg;
import com.sas.net.sharenet.WqeUserPass;
import com.sas.net.sharenet.Wqecon;
import com.sas.net.sharenet.Wqefcb;
import com.sas.net.sharenet.Xherscon;
import com.sas.net.sharenet.Xhrcim1;
import com.sas.net.sharenet.Xhrscm1;
import com.sas.net.sharenet.Xhrscm1V6;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

@SASScope(value="ALL")
public class ShareNetConnection
implements Connection {
    static final short XHR_UMTCASE_S_CON = 285;
    static final short XHR_UMTCASE_S_DISC = 286;
    static final short XHR_UMTCASE_S_PREP = 287;
    static final short XHR_UMTCASE_S_DESC = 288;
    static final short XHR_UMTCASE_S_FTCH = 289;
    static final short XHR_UMTCASE_S_DSTR = 290;
    static final short XHR_UMTCASE_S_EXEC = 291;
    static final short XHR_UMTCASE_MTDES = 3;
    static final int XHRSQPRECS = 10;
    @SASScope
    public ShareNetWarning shareWarning = null;
    public SQLWarning warnings = null;
    private final Properties info;
    private boolean closed = false;
    private Vector<ShareNetStatement> statementList = null;
    private String url = null;
    private String user = null;
    private String librefs = null;
    private Boolean remarks = Boolean.FALSE;
    private Boolean undoPolicyNone = Boolean.TRUE;
    private WqeUserPass userpass = new WqeUserPass();
    private String appname = "JAVAAPP";
    private String sapw = "";
    private String pt2dbpw = "";
    private String dbms = "SQLVIEW ";
    private String dbms_options = null;
    private Wqefcb clientFcb = null;
    private Xhrcim1 cim1 = null;
    private Xhrscm1 scm1 = null;
    private Xhrscm1V6 scm1V6 = null;
    protected Wqecon con = null;
    protected Xherscon xher1 = null;
    protected Defdestroy defdes = null;
    protected Tcpmsg msg = null;
    protected int sharenetType = 1;
    protected String version_msg;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;

    public ShareNetConnection(String url, Properties info) throws SQLException {
        int port;
        Integer tempInt;
        this.url = url;
        this.info = info;
        int length = url.length();
        boolean foreignDbms = false;
        String temp = "";
        String password = null;
        this.statementList = new Vector();
        int hostend = url.indexOf(58, 16);
        if (hostend == -1) {
            int vendorCode = 56;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: URL must specify server.", messageArg), null, vendorCode);
        }
        String host = url.substring(16, hostend);
        if (length < hostend + 3) {
            int vendorCode = 57;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: URL must specify server.", messageArg), null, vendorCode);
        }
        int portend = url.indexOf(47, hostend);
        if (portend == -1) {
            tempInt = Integer.valueOf(url.substring(hostend + 1));
            port = tempInt;
        } else {
            tempInt = Integer.valueOf(url.substring(hostend + 1, portend));
            port = tempInt;
        }
        if (info != null) {
            this.librefs = info.getProperty("librefs");
            temp = info.getProperty("remarks");
            if (temp != null) {
                this.remarks = Boolean.valueOf(temp);
            }
            if ((temp = info.getProperty("undoPolicyNone")) != null) {
                this.undoPolicyNone = Boolean.valueOf(temp);
            }
            if ((temp = info.getProperty("appname")) != null) {
                this.appname = temp;
            }
            if (info.getProperty("shareUser") == null && info.getProperty("userName") != null) {
                info.put("shareUser", info.getProperty("userName"));
            }
            if (info.getProperty("sharePassword") == null && info.getProperty("password") != null) {
                info.put("sharePassword", info.getProperty("password"));
            }
            this.user = info.getProperty("shareUser");
            password = info.getProperty("sharePassword");
            if (this.user != null) {
                this.userpass.setUserName(this.user);
            }
            if (password != null) {
                this.userpass.setPassword(password);
            }
            if ((temp = info.getProperty("sapw")) != null) {
                try {
                    this.sapw = SasPasswordString.decode((String)temp);
                }
                catch (SasPasswordEncodingException e) {
                    throw new SQLException(e.getMessage(), "80000", e);
                }
            }
            if ((temp = info.getProperty("pt2dbpw")) != null) {
                this.pt2dbpw = temp;
            }
            if ((temp = info.getProperty("dbms")) != null) {
                if (temp.indexOf("SQLVIEW") == -1) {
                    foreignDbms = true;
                }
                this.dbms = temp;
            }
            temp = null;
            temp = info.getProperty("dbmsOptions");
            if (temp == null) {
                temp = info.getProperty("dbms_options");
            }
            if (temp != null) {
                this.dbms_options = temp;
            }
        }
        try {
            this.connect(host, port);
            if (this.shareWarning.warning.length() != 0) {
                SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                if (this.warnings == null) {
                    this.warnings = warning;
                } else {
                    this.warnings.setNextWarning(warning);
                }
            }
        }
        catch (ShareNetException e) {
            int vendorCode = 58;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
        }
        String undo = null;
        if (this.undoPolicyNone.booleanValue() && !foreignDbms) {
            try {
                undo = "RESET UNDO_POLICY = NONE";
                this.execute(undo);
                if (this.shareWarning.warning.length() != 0) {
                    SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                    if (this.warnings == null) {
                        this.warnings = warning;
                    } else {
                        this.warnings.setNextWarning(warning);
                    }
                }
            }
            catch (ShareNetException e) {
                int vendorCode = 59;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
            }
        }
        if (this.librefs != null) {
            String semi = ";";
            int start = 0;
            int end = 0;
            String alibref = "";
            while (end != -1) {
                end = this.librefs.indexOf(semi, start);
                if (end != -1) {
                    alibref = this.librefs.substring(start, end);
                    start = end + 1;
                    if (start >= this.librefs.length()) {
                        end = -1;
                    }
                } else {
                    alibref = this.librefs.substring(start);
                }
                String Stmt = "LIBNAME " + alibref;
                try {
                    this.execute(Stmt);
                    if (this.shareWarning.warning.length() == 0) continue;
                    SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                    if (this.warnings == null) {
                        this.warnings = warning;
                        continue;
                    }
                    this.warnings.setNextWarning(warning);
                }
                catch (ShareNetException e) {
                    int vendorCode = 60;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
                }
            }
        }
    }

    public ShareNetConnection(String host, int port, Properties info, Wqecon con) throws SQLException {
        this.info = info;
        this.con = con;
        this.sharenetType = 3;
        String temp = "";
        this.statementList = new Vector();
        boolean foreignDbms = false;
        String password = null;
        if (info != null) {
            this.librefs = info.getProperty("librefs");
            temp = info.getProperty("remarks");
            if (temp != null) {
                this.remarks = Boolean.valueOf(temp);
            }
            if ((temp = info.getProperty("undoPolicyNone")) != null) {
                this.undoPolicyNone = Boolean.valueOf(temp);
            }
            if ((temp = info.getProperty("appname")) != null) {
                this.appname = temp;
            }
            if (info.getProperty("shareUser") == null && info.getProperty("userName") != null) {
                info.put("shareUser", info.getProperty("userName"));
            }
            if (info.getProperty("sharePassword") == null && info.getProperty("password") != null) {
                info.put("sharePassword", info.getProperty("password"));
            }
            this.user = info.getProperty("shareUser");
            password = info.getProperty("sharePassword");
            if (this.user != null) {
                this.userpass.setUserName(this.user);
            }
            if (password != null) {
                this.userpass.setPassword(password);
            }
            if ((temp = info.getProperty("sapw")) != null) {
                try {
                    this.sapw = SasPasswordString.decode((String)temp);
                }
                catch (SasPasswordEncodingException e) {
                    throw new SQLException(e.getMessage(), "80000", e);
                }
            }
            if ((temp = info.getProperty("pt2dbpw")) != null) {
                this.pt2dbpw = temp;
            }
            if ((temp = info.getProperty("dbms")) != null) {
                if (temp.indexOf("SQLVIEW") == -1) {
                    foreignDbms = true;
                }
                this.dbms = temp;
            }
            temp = null;
            temp = info.getProperty("dbmsOptions");
            if (temp == null) {
                temp = info.getProperty("dbms_options");
            }
            if (temp != null) {
                this.dbms_options = temp;
            }
        }
        try {
            this.connect(host, port);
            if (this.shareWarning.warning.length() != 0) {
                SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                if (this.warnings == null) {
                    this.warnings = warning;
                } else {
                    this.warnings.setNextWarning(warning);
                }
            }
        }
        catch (ShareNetException e) {
            int vendorCode = 61;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
        }
        String undo = null;
        if (this.undoPolicyNone.booleanValue() && !foreignDbms) {
            try {
                undo = "RESET UNDO_POLICY = NONE";
                this.execute(undo);
                if (this.shareWarning.warning.length() != 0) {
                    SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                    if (this.warnings == null) {
                        this.warnings = warning;
                    } else {
                        this.warnings.setNextWarning(warning);
                    }
                }
            }
            catch (ShareNetException e) {
                int vendorCode = 62;
                String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
            }
        }
        if (this.librefs != null) {
            String semi = ";";
            int start = 0;
            int end = 0;
            String alibref = "";
            while (end != -1) {
                end = this.librefs.indexOf(semi, start);
                if (end != -1) {
                    alibref = this.librefs.substring(start, end);
                    start = end + 1;
                    if (start >= this.librefs.length()) {
                        end = -1;
                    }
                } else {
                    alibref = this.librefs.substring(start);
                }
                String Stmt = "LIBNAME " + alibref;
                try {
                    this.execute(Stmt);
                    if (this.shareWarning.warning.length() == 0) continue;
                    SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                    if (this.warnings == null) {
                        this.warnings = warning;
                        continue;
                    }
                    this.warnings.setNextWarning(warning);
                }
                catch (ShareNetException e) {
                    int vendorCode = 63;
                    String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
                    Object[] messageArg = new Object[]{messageIndex, e.getMessage()};
                    throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: {1}", messageArg), null, vendorCode);
                }
            }
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        ShareNetStatement statement = new ShareNetStatement(this);
        this.statementList.addElement(statement);
        return statement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        ShareNetPreparedStatement prepstatement = new ShareNetPreparedStatement(this, sql);
        this.statementList.addElement(prepstatement);
        return prepstatement;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!autoCommit) {
            throw new ShareNetSQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        for (ShareNetStatement statement : this.statementList) {
            statement.close();
            this.deleteStatement(statement);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Commit/Rollback not supported.", new Object[]{"Sharenet.S67.ex.txt"}), null, 67);
    }

    @Override
    public synchronized void close() throws SQLException {
        int count = this.statementList.size();
        for (int i = 0; i < count; ++i) {
            ShareNetStatement statement = this.statementList.elementAt(0);
            statement.close();
        }
        this.statementList = new Vector();
        if (!this.closed && this.sharenetType != 3) {
            try {
                this.disconnect();
                if (this.shareWarning.warning.length() != 0) {
                    SQLWarning warning = new SQLWarning(this.shareWarning.warning);
                    if (this.warnings == null) {
                        this.warnings = warning;
                    } else {
                        this.warnings.setNextWarning(warning);
                    }
                }
            }
            catch (ShareNetException shareNetException) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (!"SQLVIEW ".equals(this.dbms)) {
            int vendorCode = 69;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex, this.dbms};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: Cannot create a DatabaseMetaData object. Connection is using passthru facility to another DBMS: {1}", messageArg), null, vendorCode);
        }
        ShareNetDatabaseMetaData data = new ShareNetDatabaseMetaData(this);
        return data;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public final String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (level != 0) {
            throw new ShareNetSQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            // empty if block
        }
        if (resultSetConcurrency != 1007) {
            // empty if block
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            // empty if block
        }
        if (resultSetConcurrency != 1007) {
            // empty if block
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            this.resultSetType = 1003;
        }
        if (resultSetConcurrency != 1007) {
            this.resultSetConcurrency = 1007;
        }
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    protected synchronized void deleteStatement(Object statement) {
        int i = this.statementList.indexOf(statement);
        if (i < 0) {
            return;
        }
        this.statementList.removeElementAt(i);
    }

    protected String getUser() {
        if (this.user == null) {
            return "";
        }
        return this.user;
    }

    protected String getUrl() {
        return this.url;
    }

    protected boolean getRemarks() {
        return this.remarks;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected synchronized void connect(String myhost, int port) throws ShareNetException {
        int i;
        int pwLen;
        Object temp;
        this.version_msg = null;
        this.shareWarning = new ShareNetWarning("");
        this.clientFcb = new Wqefcb(this.sharenetType);
        this.defdes = new Defdestroy();
        this.xher1 = new Xherscon();
        if (this.sharenetType == 1) {
            this.con = new Wqecon(this.info);
        }
        this.con.setUserPass(this.userpass);
        this.cim1 = new Xhrcim1(this.con);
        this.scm1 = new Xhrscm1(this.con);
        this.scm1V6 = new Xhrscm1V6(this.con);
        this.clientFcb.wmseg[0] = this.cim1;
        this.clientFcb.waseg[0] = new Ans1();
        this.clientFcb.minfo.sv[0] = 1;
        this.clientFcb.minfo.sv[2] = 71;
        this.clientFcb.minfo.sv[4] = 3082;
        this.clientFcb.minfo.sv[10] = 34;
        this.clientFcb.acc = 0;
        this.clientFcb.nseg = 3;
        this.cim1.name = this.appname;
        this.cim1.sapw = this.sapw;
        int len = this.cim1.sapw.length();
        if (len != 0) {
            this.cim1.sapw = this.cim1.sapw.toUpperCase();
            temp = new byte[8];
            pwLen = Math.min(this.cim1.sapw.length(), 8);
            for (i = 0; i < pwLen; ++i) {
                temp[i] = (byte)this.cim1.sapw.charAt(i);
            }
            while (i < 8) {
                temp[i] = 32;
                ++i;
            }
            this.cim1.esapw = this.encrypt((byte[])temp);
        }
        this.msg = this.sharenetType == 1 ? this.con.open(myhost, port, this.clientFcb) : this.con.sendFirst(myhost, port, this.clientFcb);
        Ans1 ans1 = (Ans1)this.clientFcb.waseg[0];
        if (ans1.buf != null && ans1.buf.length > 0) {
            this.version_msg = new String(ans1.buf, 0, ans1.len);
        }
        if (this.clientFcb.acc != 0) {
            if (this.clientFcb.acc < 0) {
                String messageIndex = "Sharenet.S248.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(this.clientFcb.acc), new String(ans1.buf, 0, ans1.len)};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            temp = new String(ans1.buf, 0, ans1.len);
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, (String)temp);
        }
        this.clientFcb.wmseg[0] = new Xhrscm1(this.con);
        this.scm1 = (Xhrscm1)this.clientFcb.wmseg[0];
        if (this.dbms != null) {
            this.scm1.setdbms(this.dbms);
        }
        this.scm1.dbms = this.dbms;
        if (this.dbms_options != null) {
            this.scm1.setoptions(this.dbms_options);
        }
        this.scm1.pt2dbpw = this.pt2dbpw;
        len = this.scm1.pt2dbpw.length();
        if (len != 0) {
            this.scm1.pt2dbpw = this.scm1.pt2dbpw.toUpperCase();
            temp = new byte[8];
            pwLen = Math.min(this.scm1.pt2dbpw.length(), 8);
            for (i = 0; i < pwLen; ++i) {
                temp[i] = (byte)this.scm1.pt2dbpw.charAt(i);
            }
            while (i < 8) {
                temp[i] = 32;
                ++i;
            }
            this.scm1.ept2dbpw = this.encrypt((byte[])temp);
        }
        if (this.clientFcb.minfo.sv[2] < 12) {
            this.clientFcb.minfo.sv[4] = 0;
        }
        this.clientFcb.minfo.sv[0] = 285;
        this.clientFcb.nseg = 3;
        if (this.clientFcb.minfo.sv[2] < 41) {
            this.clientFcb.wmseg[0] = new Xhrscm1V6(this.con);
            this.scm1V6 = (Xhrscm1V6)this.clientFcb.wmseg[0];
            this.scm1V6.dbms = this.dbms;
            if (this.dbms_options != null) {
                this.scm1V6.setoptions(this.dbms_options);
            }
            this.scm1V6.pt2dbpw = this.pt2dbpw;
            len = this.scm1V6.pt2dbpw.length();
            if (len != 0) {
                this.scm1V6.pt2dbpw = this.scm1V6.pt2dbpw.toUpperCase();
                temp = new byte[8];
                pwLen = Math.min(this.scm1V6.pt2dbpw.length(), 8);
                for (i = 0; i < pwLen; ++i) {
                    temp[i] = (byte)this.scm1V6.pt2dbpw.charAt(i);
                }
                while (i < 8) {
                    temp[i] = 32;
                    ++i;
                }
                this.scm1V6.ept2dbpw = this.encrypt((byte[])temp);
            }
        }
        this.clientFcb.waseg[1] = new Rcmsg();
        this.clientFcb.waseg[2] = new Sconinfo();
        this.xher1.share_rel = this.clientFcb.minfo.sv[2];
        this.clientFcb.minfo.sv[2] = 0;
        this.send(this.clientFcb);
        Rcmsg rcmsg = (Rcmsg)this.clientFcb.waseg[1];
        ans1 = (Ans1)this.clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(this.clientFcb.acc, ans1, rcmsg);
        if (this.clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else {
            if (this.clientFcb.acc < 0) {
                int save_acc = this.clientFcb.acc;
                this.clientFcb.minfo.sv[0] = 3;
                this.clientFcb.nseg = 1;
                this.clientFcb.waseg[1].len = 0;
                this.clientFcb.wmseg[0].len = 0;
                this.send(this.clientFcb);
                rcmsg = (Rcmsg)this.clientFcb.waseg[1];
                ans1 = (Ans1)this.clientFcb.waseg[0];
                if (this.clientFcb.acc == 0) {
                    this.shareWarning.warning = tempMsg + this.shareWarning.warning;
                } else if (this.clientFcb.acc < 0) {
                    tempMsg = tempMsg + this.shareWarning.warning;
                    this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
                } else {
                    tempMsg = tempMsg + this.shareWarning.warning;
                    this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
                }
                this.con.wqeclos(this.msg);
                String messageIndex = "Sharenet.S249.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(save_acc), tempMsg};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        }
        this.xher1.cap_flgs = this.clientFcb.minfo.sv[4];
        this.xher1.cap_flgs2 = this.clientFcb.minfo.sv[5];
        if (this.xher1.share_rel >= 41) {
            this.xher1.mr_indx = this.clientFcb.minfo.sv[6];
            this.xher1.en_indx = this.clientFcb.minfo.sv[7];
        }
    }

    private synchronized void disconnect() throws ShareNetException {
        if (this.closed) {
            return;
        }
        this.shareWarning = new ShareNetWarning("");
        this.clientFcb = new Wqefcb(this.sharenetType);
        this.clientFcb.minfo.sv[0] = 286;
        if (this.xher1.share_rel >= 41) {
            this.clientFcb.minfo.sv[6] = this.xher1.mr_indx;
            this.clientFcb.minfo.sv[7] = this.xher1.en_indx;
        }
        this.clientFcb.nseg = 2;
        this.clientFcb.wmseg[0] = this.defdes;
        this.clientFcb.waseg[1] = new Rcmsg();
        this.send(this.clientFcb);
        Rcmsg rcmsg = (Rcmsg)this.clientFcb.waseg[1];
        Ans1 ans1 = (Ans1)this.clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(this.clientFcb.acc, ans1, rcmsg);
        if (this.clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else if (this.clientFcb.acc < 0) {
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        } else {
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        }
        this.clientFcb.minfo.sv[0] = 3;
        if (this.xher1.share_rel >= 41) {
            this.clientFcb.minfo.sv[7] = 0;
        }
        this.clientFcb.nseg = 1;
        this.clientFcb.waseg[1].len = 0;
        this.clientFcb.wmseg[0].len = 0;
        this.send(this.clientFcb);
        rcmsg = (Rcmsg)this.clientFcb.waseg[1];
        ans1 = (Ans1)this.clientFcb.waseg[0];
        tempMsg = ShareNetConnection.formatMsg(this.clientFcb.acc, ans1, rcmsg);
        if (this.clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else if (this.clientFcb.acc < 0) {
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        } else {
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        }
        this.con.wqeclos(this.msg);
    }

    protected synchronized int execute(String command) throws ShareNetException {
        if (this.closed) {
            String messageIndex = "Sharenet.S253.ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: No connection to server.", messageArg));
        }
        this.shareWarning = new ShareNetWarning("");
        this.clientFcb = new Wqefcb(this.sharenetType);
        this.clientFcb.minfo.sv[0] = 291;
        if (this.xher1.share_rel >= 41) {
            this.clientFcb.minfo.sv[6] = this.xher1.mr_indx;
            this.clientFcb.minfo.sv[7] = this.xher1.en_indx;
        }
        this.clientFcb.nseg = 2;
        this.clientFcb.wmseg[0] = new Msegexe(command, this.con.getShareEncoding());
        this.clientFcb.waseg[1] = new Rcmsg();
        this.send(this.clientFcb);
        Rcmsg rcmsg = (Rcmsg)this.clientFcb.waseg[1];
        Ans1 ans1 = (Ans1)this.clientFcb.waseg[0];
        String tempMsg = ShareNetConnection.formatMsg(this.clientFcb.acc, ans1, rcmsg);
        if (this.clientFcb.acc == 0) {
            this.shareWarning.warning = tempMsg + this.shareWarning.warning;
        } else {
            if (this.clientFcb.acc < 0) {
                String messageIndex = "Sharenet.S254.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, String.valueOf(this.clientFcb.acc), tempMsg};
                throw new ShareNetException(ShareLocalizedError.getLocalizedError("{0}: {1} {2}", messageArg));
            }
            tempMsg = tempMsg + this.shareWarning.warning;
            this.shareWarning = new ShareNetWarning(this.clientFcb.acc, tempMsg);
        }
        if (rcmsg.free_space[0] < 0L) {
            return 0;
        }
        return (int)rcmsg.free_space[0];
    }

    synchronized void send(Wqefcb fcb) throws ShareNetException {
        fcb.waseg[0] = new Ans1();
        fcb.acc = 0;
        int i = 0;
        int j = 10;
        while (i < 3) {
            fcb.minfo.sv[j] = 34;
            ++i;
            ++j;
        }
        this.con.wqesndm(fcb, this.msg);
    }

    synchronized byte[] encrypt(byte[] in) {
        Ebcdic eb = new Ebcdic();
        long ENC1 = 66343L;
        long ENC2 = 58333L;
        long X100 = 256L;
        byte[] out = new byte[4];
        int[] plain = eb.translate(in, 8);
        long i7 = (long)plain[3] * ENC1;
        long i6 = (long)plain[2] * ENC1 + i7 / X100;
        long i5 = (long)plain[1] * ENC1 + i6 / X100;
        long i4 = plain[0];
        if ((plain[0] & 0x80) != 0) {
            i4 |= 0xFFFFFF00L;
            i4 &= 0xFFFFFFFFL;
        }
        i4 = i4 * ENC1 & 0xFFFFFFFFL;
        i4 += i5 / X100;
        long i4temp = i4 &= 0xFFFFFFFFL;
        i7 %= X100;
        i6 %= X100;
        i5 %= X100;
        i4 %= X100;
        long i3 = (i4temp /= X100) % X100;
        long i2 = (i4temp /= X100) % X100;
        long i1 = (i4temp /= X100) % X100;
        long i0 = (plain[0] & 0x80) != 0 ? 255L : 0L;
        long r7 = i7 ^ i3;
        long r6 = i6 ^ i2;
        long r5 = i5 ^ i1;
        long r4 = i4 ^ i0;
        i7 = (long)plain[7] * ENC2;
        i6 = (long)plain[6] * ENC2 + i7 / X100;
        i5 = (long)plain[5] * ENC2 + i6 / X100;
        if ((plain[4] & 0x80) != 0) {
            i4 = (long)plain[4] | 0xFFFFFF00L;
            i4 &= 0xFFFFFFFFL;
        } else {
            i4 = plain[4];
        }
        i4 = i4 * ENC2 & 0xFFFFFFFFL;
        i4 += i5 / X100;
        i4temp = i4 &= 0xFFFFFFFFL;
        i7 %= X100;
        i6 %= X100;
        i5 %= X100;
        i4 %= X100;
        i3 = (i4temp /= X100) % X100;
        i2 = (i4temp /= X100) % X100;
        i1 = (i4temp /= X100) % X100;
        i0 = plain[4];
        i0 = (i0 & 0x80L) != 0L ? 255L : 0L;
        long r3 = i7 ^ i3;
        long r2 = i6 ^ i2;
        long r1 = i5 ^ i1;
        long r0 = i4 ^ i0;
        out[0] = (byte)(r0 ^= r4);
        out[1] = (byte)(r1 ^= r5);
        out[2] = (byte)(r2 ^= r6);
        out[3] = (byte)(r3 ^= r7);
        return out;
    }

    protected static String formatMsg(int acc, Ans1 ans1, Rcmsg rcmsg) throws ShareNetException {
        String returnMsg;
        String crc = null;
        String ans1msg = ans1.buf != null && ans1.len != 0 ? new String(ans1.buf, 0, ans1.len) : "";
        crc = rcmsg.lrc != 0 ? new String(rcmsg.crc, 0, rcmsg.lrc) : "";
        String cmsg = rcmsg.lmsg != 0 ? new String(rcmsg.cmsg, 0, rcmsg.lmsg) : "";
        if (crc.equals("0")) {
            crc = "";
        }
        if (cmsg.equals("0")) {
            cmsg = "";
        }
        if (ans1msg.equals("0")) {
            ans1msg = "";
        }
        if (ans1msg.length() != 0 && cmsg.indexOf(ans1msg) != -1) {
            ans1msg = "";
        }
        if (cmsg.length() != 0 && ans1msg.indexOf(cmsg) != -1) {
            cmsg = "";
        }
        if (crc.length() != 0 && cmsg.indexOf(crc) != -1) {
            crc = "";
        }
        if (acc == 0) {
            returnMsg = crc + " " + cmsg;
            returnMsg = returnMsg.trim();
        } else {
            returnMsg = ans1msg + " " + crc + " " + cmsg;
            returnMsg = returnMsg.trim();
        }
        return returnMsg;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
        m.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        throw new SQLClientInfoException(m);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> m = new HashMap<String, ClientInfoStatus>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            m.put(key, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        throw new SQLClientInfoException(m);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        Properties p = new Properties();
        return p;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: unwrap operation failed; input parameter is null.", new Object[]{"Sharenet.S586.ex.txt"}), null, 586);
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException(ShareLocalizedError.getLocalizedError("unwrap operation failed; class {1} does not implement {2}", new Object[]{"Sharenet.S587.ex.txt", iface.getName(), this.getClass().getName()}), null, 587);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    void checkClosed() throws SQLException {
        if (this.closed) {
            int vendorCode = 590;
            String messageIndex = "Sharenet.S" + vendorCode + ".ex.txt";
            Object[] messageArg = new Object[]{messageIndex};
            throw new SQLException(ShareLocalizedError.getLocalizedError("{0}: The Connection is closed.", messageArg), "08003", vendorCode);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new ShareNetSQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }
}

