/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.ConnectRecord;
import com.sas.net.connect.ShutDownRecord;
import com.sas.net.connect.VersionResponseRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

@SASScope
public class VersionRecord
extends ConnectRecord {
    private String messageIndex;

    public VersionRecord(ConnectClient client) throws ConnectException {
        super(client, true);
        this.maxlen = 13;
    }

    @Override
    public synchronized void action() throws ConnectException {
        super.action();
        byte mver = 0;
        int options = 0;
        int xlVersion = 0;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(this.buf);
            DataInputStream stream = new DataInputStream(input);
            mver = stream.readByte();
            options = stream.readInt();
            if (mver >= 13) {
                xlVersion = stream.readInt();
            }
            if (mver >= 19) {
                this.client.buffersize = (short)stream.readInt();
            }
        }
        catch (IOException e) {
            this.messageIndex = "Connect.C110.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        this.client.setMver(mver);
        this.client.mergeOptions(options);
        this.client.cbuf.setTbufsize(this.client.buffersize * 1024);
        this.client.sbuf.setTbufsize(this.client.buffersize * 1024);
        VersionResponseRecord rver = new VersionResponseRecord(this.client);
        this.client.addRecords(rver, true);
        if ((options & 0x40000000) == 0) {
            this.client.drain();
            ShutDownRecord shutDownRecord = new ShutDownRecord(this.client);
            this.client.addRecords(shutDownRecord, true);
            this.client.drain();
            this.messageIndex = "Connect.C111.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Server not properly licensed.", messageArg));
        }
    }
}

