/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.ConnectLoginException;
import com.sas.net.connect.TelnetClientException;
import com.sas.net.connect.TelnetClientInterface;
import com.sas.net.crypto.CipherInterface;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.Date;
import java.util.Properties;

@SASScope
public class ScriptingTool {
    private static final int TIO_SEND = 1;
    private static final int TIO_RECEIVE = 2;
    private static final int TIO_GET_PORT = 3;
    private static final String basePromptName = "prompt";
    private static final String baseResponseName = "response";
    private static final String timeOutName = "Timeout";
    private static final String blotName = "Blot";
    private static final String passwordResponseName = "passwordResponse";
    private static final String invalidLoginTagName = "invalidLoginTag";
    private static final String sasPortTagDefault = "PORT=";
    private static final String sasSessionTagDefault = "SESSION ESTABLISHED";
    private static final String promptTimeoutDefault = "0";
    private static final String responseTimeoutDefault = "0";
    private static final String sasPortTagTimeoutDefault = "0";
    private static final String telnetClientDefault = "com.sas.net.connect.SASTelnetClient";
    private TelnetClientInterface tio = null;
    private int tioThreadCommand = 0;
    private String[] tioResponse = null;
    private int tioIndex = 0;
    private String tioResponsePrint = null;
    private String[] tioPromptTarget = null;
    private int tioCount = 0;
    private String connectPortString = null;
    private ConnectException tioException = null;
    private StringBuffer tioLog = null;
    private boolean tioPromptFound = false;
    private boolean tioResponseSent = false;
    private boolean d = false;
    private String eoln = null;
    private String messageIndex;
    private Properties info = null;
    private String passwordResponse = null;
    private int tioPasswordIndex = -1;
    private boolean tioPasswordSent = false;
    private String invalidLoginTag = null;

    protected ScriptingTool(Properties info) {
        this.info = info;
        this.tioPromptTarget = new String[10];
        this.tioResponse = new String[10];
        this.eoln = System.getProperty("line.separator");
        this.passwordResponse = info.getProperty(passwordResponseName);
        this.invalidLoginTag = info.getProperty(invalidLoginTagName);
        String debugVal = info.getProperty("debugTelnetConnectClient");
        if (debugVal != null && debugVal.length() > 0) {
            this.d = true;
        }
    }

    private void debugMsg(String msg) {
        this.tioLog.append(msg);
        if (this.d) {
            System.out.print(msg);
        }
    }

    protected synchronized boolean connect(String host, int telnetPort) throws ConnectException {
        Date date;
        int tioPromptTimeout = 0;
        String t = null;
        boolean socketInherited = false;
        t = this.info.getProperty("telnetClient", telnetClientDefault);
        this.tio = this.getTelnetClient(t);
        this.tioLog = new StringBuffer();
        this.getTargets("prologPrompt", "prologResponse", false, 1);
        if (this.tioCount > 0) {
            try {
                this.tio.connect(host, telnetPort);
                date = new Date();
                this.tioLog = new StringBuffer();
                this.debugMsg("PROLOG Telnet session established on " + date.toString() + this.eoln);
                this.debugMsg("Telnet client: " + t + this.eoln);
                this.debugMsg("Host: " + host + this.eoln);
                this.debugMsg("Port: " + telnetPort + this.eoln);
            }
            catch (TelnetClientException e) {
                this.messageIndex = "Connect.C122.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, e.toString()};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Cannot connect to telnet session. {1}", messageArg));
            }
            try {
                this.script("prologPrompt", "prologResponse", false);
            }
            catch (Exception e) {
                if (e instanceof ConnectException) {
                    throw (ConnectException)((Object)e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                this.messageIndex = "Connect.C123.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, e.toString()};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Cannot connect to telnet session. {1}", messageArg));
            }
            finally {
                try {
                    if (this.tio != null) {
                        this.tio.disconnect();
                    }
                }
                catch (TelnetClientException telnetClientException) {}
            }
        }
        try {
            this.tio.connect(host, telnetPort);
            date = new Date();
            this.tioLog = new StringBuffer();
            this.debugMsg("Telnet session established on " + date.toString() + this.eoln);
            this.debugMsg("Telnet client: " + t + this.eoln);
            this.debugMsg("Host: " + host + this.eoln);
            this.debugMsg("Port: " + telnetPort + this.eoln);
        }
        catch (TelnetClientException e) {
            this.messageIndex = "Connect.C75.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.toString()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Cannot connect to telnet session {1}", messageArg));
        }
        try {
            Object[] messageArg;
            this.script(basePromptName, baseResponseName, true);
            socketInherited = this.tio.isSocketInherited();
            this.tioCount = 1;
            this.tioPromptTarget[0] = socketInherited ? this.info.getProperty("sasSessionTag", sasSessionTagDefault) : this.info.getProperty("sasPortTag", sasPortTagDefault);
            t = this.info.getProperty("sasPortTagTimeout", "0");
            tioPromptTimeout = Integer.parseInt(t) * 1000;
            this.tioThreadCommand = 2;
            this.tioPromptFound = false;
            this.run(tioPromptTimeout);
            if (this.tioException != null) {
                throw this.tioException;
            }
            if (!this.tioPromptFound) {
                this.messageIndex = "Connect.C78.ex.txt";
                messageArg = new Object[]{this.messageIndex, this.tioPromptTarget[0], this.eoln, this.tioLog.toString()};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Timeout occurred waiting for \"{1}\" in the following telnet session {2} {3}", messageArg));
            }
            if (!socketInherited) {
                this.tioThreadCommand = 3;
                this.connectPortString = null;
                this.run(tioPromptTimeout);
                if (this.tioException != null) {
                    throw this.tioException;
                }
                if (this.connectPortString == null) {
                    this.messageIndex = "Connect.C79.ex.txt";
                    messageArg = new Object[]{this.messageIndex, this.eoln, this.tioLog.toString()};
                    throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Timeout occurred fetching SAS port number in the following telnet session {1} {2}", messageArg));
                }
                this.connectPortString = this.connectPortString.trim();
            } else {
                Socket socket = this.getSocket();
                socket.setSoTimeout(0);
            }
        }
        catch (Exception e) {
            try {
                if (this.tio != null) {
                    this.tio.disconnect();
                    this.tio = null;
                }
            }
            catch (TelnetClientException _e) {
                this.tio = null;
            }
            if (e instanceof ConnectException) {
                throw (ConnectException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            this.messageIndex = "Connect.C82.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.toString()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Cannot connect to telnet session. {1}", messageArg));
        }
        return socketInherited;
    }

    protected synchronized boolean connect(String host) throws ConnectException {
        return this.connect(host, 23);
    }

    protected synchronized void disconnect() {
        if (this.tio == null) {
            return;
        }
        try {
            this.script("epilogPrompt", "epilogResponse", false);
        }
        catch (Exception e) {
            this.debugMsg("Attempt to script epilog for telnet session failed");
        }
        try {
            if (this.tio != null) {
                this.tio.disconnect();
            }
        }
        catch (TelnetClientException telnetClientException) {
        }
        finally {
            this.tio = null;
        }
    }

    protected int getPort() {
        return Integer.parseInt(this.connectPortString);
    }

    protected Socket getSocket() {
        return this.tio.getSocket();
    }

    protected CipherInterface getCipher() {
        return this.tio.getCipher();
    }

    private void run(int tioTimeout) {
        switch (this.tioThreadCommand) {
            case 1: {
                try {
                    this.debugMsg("Sent: " + this.tioResponsePrint + this.eoln);
                    this.tio.sendString(this.tioResponse[this.tioIndex]);
                    this.tioResponseSent = true;
                    if (this.tioIndex != this.tioPasswordIndex) break;
                    this.tioPasswordSent = true;
                    this.tioPasswordIndex = -1;
                }
                catch (TelnetClientException e) {
                    Throwable nestedException = e.getNestedException();
                    if (nestedException != null && nestedException instanceof InterruptedIOException) break;
                    this.messageIndex = "Connect.C84.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, this.tioResponsePrint, this.eoln, e.toString()};
                    this.tioException = new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Exception while sending \"{1}\" in the following telnet session {2} {3}", messageArg));
                    this.debugMsg("Exception while sending " + this.tioResponsePrint + this.eoln);
                }
                break;
            }
            case 2: {
                boolean loginRejected = false;
                try {
                    int invalidLoginTagL;
                    this.debugMsg("Looking for message from host containing one of the following" + this.eoln);
                    int maxLen = 0;
                    for (int i = 0; i < this.tioCount; ++i) {
                        this.debugMsg("\t" + this.tioPromptTarget[i] + this.eoln);
                        int l = this.tioPromptTarget[i].length();
                        if (l <= maxLen) continue;
                        maxLen = l;
                    }
                    if (this.tioPasswordSent && this.invalidLoginTag != null && (invalidLoginTagL = this.invalidLoginTag.length()) > maxLen) {
                        maxLen = invalidLoginTagL;
                    }
                    char[] gather = new char[maxLen];
                    int gatherLen = 0;
                    this.tioIndex = -1;
                    this.debugMsg("Received: ");
                    while (this.tioIndex < 0) {
                        String g;
                        gather[gatherLen] = this.tio.receiveChar(tioTimeout);
                        this.debugMsg("" + gather[gatherLen]);
                        this.tioIndex = ScriptingTool.compare(this.tioPromptTarget, this.tioCount, gather, ++gatherLen);
                        if (this.tioIndex < 0 && this.tioPasswordSent && this.invalidLoginTag != null && gatherLen >= this.invalidLoginTag.length() && (g = new String(gather)).indexOf(this.invalidLoginTag) >= 0) {
                            loginRejected = true;
                            throw new TelnetClientException();
                        }
                        if (this.tioIndex >= 0 || gatherLen != maxLen) continue;
                        for (int i = 1; i < maxLen; ++i) {
                            gather[i - 1] = gather[i];
                        }
                        --gatherLen;
                    }
                    this.tioPromptFound = true;
                    this.tioPasswordSent = false;
                    this.debugMsg(this.eoln);
                }
                catch (TelnetClientException e) {
                    Object[] messageArg;
                    Throwable nestedException = e.getNestedException();
                    if (nestedException == null || !(nestedException instanceof InterruptedIOException)) {
                        this.messageIndex = "Connect.C85.ex.txt";
                        messageArg = new Object[]{this.messageIndex, this.tioPromptTarget[0], this.eoln, this.tioLog.toString()};
                        this.tioException = new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Exception while waiting for \"{1}\" in the following telnet session {2} {3}", messageArg));
                        this.tioException.initCause((Throwable)((Object)e));
                        this.debugMsg("Exception while waiting for " + this.tioPromptTarget[0] + this.eoln);
                    }
                    if (this.tioPasswordSent && (this.invalidLoginTag == null || loginRejected)) {
                        this.messageIndex = "Connect.C125.ex.txt";
                        messageArg = new Object[]{this.messageIndex};
                        String message = ConnectLocalizedError.getLocalizedError("Login failed.", messageArg);
                        ConnectException cause = this.tioException;
                        this.tioException = new ConnectLoginException(message);
                        this.tioException.initCause((Throwable)((Object)cause));
                        break;
                    }
                    if (this.tioException == null) break;
                    this.messageIndex = "Connect.C125.ex.txt";
                    messageArg = new Object[]{this.messageIndex};
                    String message = ConnectLocalizedError.getLocalizedError("Login failed.", messageArg);
                    ConnectException cause = this.tioException;
                    this.tioException = new ConnectException(message);
                    this.tioException.initCause((Throwable)((Object)cause));
                }
                break;
            }
            case 3: {
                try {
                    this.debugMsg("Fetching SAS port number" + this.eoln);
                    char[] portChars = new char[5];
                    for (int i = 0; i < 5; ++i) {
                        portChars[i] = this.tio.receiveChar(tioTimeout);
                    }
                    this.connectPortString = new String(portChars);
                }
                catch (TelnetClientException e) {
                    Throwable nestedException = e.getNestedException();
                    if (nestedException != null && nestedException instanceof InterruptedIOException) break;
                    this.messageIndex = "Connect.C86.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, e.toString()};
                    this.tioException = new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Exception while getting SAS port number. {1}", messageArg));
                    this.debugMsg("Exception while getting SAS port" + this.eoln);
                }
                break;
            }
            default: {
                this.debugMsg("Internal error - Invalid tioThreadCommand" + this.eoln);
                this.messageIndex = "Connect.C87.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex};
                this.tioException = new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Internal Error. Invalid tioThreadCommand.", messageArg));
                break;
            }
        }
    }

    private TelnetClientInterface getTelnetClient(String tioName) throws ConnectException {
        Class<?> tioClass = null;
        try {
            tioClass = Class.forName(tioName);
        }
        catch (ClassNotFoundException e1) {
            this.messageIndex = "Connect.C88.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, tioName};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} was not found.", messageArg));
        }
        Constructor<?> tioConstructor = null;
        try {
            tioConstructor = tioClass.getConstructor(Properties.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException(e.getMessage());
        }
        Object tioObject = null;
        try {
            Object[] argv = new Object[]{this.info};
            tioObject = tioConstructor.newInstance(argv);
        }
        catch (InstantiationException e2) {
            this.messageIndex = "Connect.C89.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, tioName};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} could not be instantiated.", messageArg));
        }
        catch (IllegalAccessException e3) {
            this.messageIndex = "Connect.C90.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, tioName};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} could not be accessed.", messageArg));
        }
        catch (InvocationTargetException e4) {
            throw new ConnectException(e4.getMessage());
        }
        if (tioObject instanceof TelnetClientInterface) {
            return tioObject;
        }
        this.messageIndex = "Connect.C91.ex.txt";
        Object[] messageArg = new Object[]{this.messageIndex, tioName, "com.sas.net.TelnetClientInterface"};
        throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Class {1} must implement {2}.", messageArg));
    }

    private void script(String promptBase, String responseBase, boolean strict) throws Exception {
        String t = null;
        int tioPromptTimeout = 0;
        int tioResponseTimeout = 0;
        int cycle = 1;
        this.getTargets(promptBase, responseBase, strict, cycle);
        while (this.tioCount > 0) {
            t = this.info.getProperty(promptBase + timeOutName + cycle, "0");
            tioPromptTimeout = Integer.parseInt(t) * 1000;
            t = this.info.getProperty(responseBase + timeOutName + cycle, "0");
            tioResponseTimeout = Integer.parseInt(t) * 1000;
            this.tioThreadCommand = 2;
            this.tioPromptFound = false;
            this.run(tioPromptTimeout);
            if (this.tioException != null) {
                throw this.tioException;
            }
            if (!this.tioPromptFound) {
                this.messageIndex = "Connect.C76.ex.txt";
                Object[] messageArg = new Object[]{this.messageIndex, this.tioPromptTarget[0], this.eoln, this.tioLog.toString()};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Timeout occurred waiting for \"{1}\" in the following telnet session {2} {3}", messageArg));
            }
            if (this.tioResponse[this.tioIndex] != null) {
                String blot = this.info.getProperty(responseBase + blotName + cycle + "." + this.tioIndex);
                if (this.tioIndex == 0 && (blot == null || blot.length() == 0)) {
                    blot = this.info.getProperty(responseBase + blotName + cycle);
                }
                if (blot != null && blot.length() > 0 || this.passwordResponse != null && (this.passwordResponse.equals(responseBase + cycle + "." + this.tioIndex) || this.tioIndex == 0 && this.passwordResponse.equals(responseBase + cycle)) && (blot == null || blot.length() > 0)) {
                    char[] xxx = new char[this.tioResponse[this.tioIndex].length()];
                    for (int i = 0; i < xxx.length; ++i) {
                        xxx[i] = 120;
                    }
                    this.tioResponsePrint = new String(xxx);
                } else {
                    this.tioResponsePrint = this.tioResponse[this.tioIndex];
                }
                this.tioThreadCommand = 1;
                this.tioResponseSent = false;
                this.run(tioResponseTimeout);
                if (this.tioException != null) {
                    throw this.tioException;
                }
                if (!this.tioResponseSent) {
                    this.messageIndex = "Connect.C77.ex.txt";
                    Object[] messageArg = new Object[]{this.messageIndex, this.tioResponsePrint, this.eoln, this.tioLog.toString()};
                    throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Timeout occurred sending \"{1}\" in the following telnet session {2} {3}", messageArg));
                }
            }
            this.getTargets(promptBase, responseBase, strict, ++cycle);
        }
    }

    private static int compare(String[] targets, int targetCount, char[] input, int inputLen) {
        for (int i = 0; i < targetCount; ++i) {
            int k;
            String t = targets[i];
            int tl = t.length();
            if (tl > inputLen) continue;
            int j = inputLen - tl;
            for (k = 0; k < tl && input[j] == t.charAt(k); ++k) {
                ++j;
            }
            if (k != tl) continue;
            return i;
        }
        return -1;
    }

    private void getTargets(String promptBase, String responseBase, boolean strict, int cycle) {
        this.tioCount = 0;
        for (int i = 0; i < 10; ++i) {
            this.tioPromptTarget[i] = null;
            this.tioResponse[i] = null;
        }
        for (int subCycle = 0; subCycle < 10; ++subCycle) {
            String pN = this.info.getProperty(promptBase + cycle + "." + subCycle);
            String rN = this.info.getProperty(responseBase + cycle + "." + subCycle);
            String p = null;
            String r = null;
            if (subCycle == 0) {
                p = this.info.getProperty(promptBase + cycle);
                r = this.info.getProperty(responseBase + cycle);
            }
            if (!(pN == null || pN.length() <= 0 || strict && rN == null)) {
                ++this.tioCount;
                this.tioPromptTarget[subCycle] = pN;
                this.tioResponse[subCycle] = rN;
                if (this.passwordResponse == null || !this.passwordResponse.equals(responseBase + cycle + "." + subCycle)) continue;
                this.tioPasswordIndex = subCycle;
                continue;
            }
            if (!(p == null || p.length() <= 0 || strict && r == null)) {
                ++this.tioCount;
                this.tioPromptTarget[subCycle] = p;
                this.tioResponse[subCycle] = r;
                if (this.passwordResponse == null || !this.passwordResponse.equals(responseBase + cycle)) continue;
                this.tioPasswordIndex = subCycle;
                continue;
            }
            return;
        }
    }
}

