/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.TelnetClientException;
import com.sas.net.connect.TelnetClientInterface;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.net.sharenet.Crypt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;

public class SASTelnetClient
implements TelnetClientInterface {
    private static final byte TCP_IAC = -1;
    private static final byte TCP_DONT = -2;
    private static final byte TCP_DO = -3;
    private static final byte TCP_WONT = -4;
    private static final byte TCP_WILL = -5;
    private static final byte TCP_SB = -6;
    private static final byte TCP_SE = -16;
    private static final byte TCP_ECHO = 1;
    private static final byte TCP_SUPPRESS_GOAHEAD = 3;
    private static final byte TCP_TERMINAL_TYPE = 24;
    private static final byte TCP_SAS_DAEMON = -2;
    private static final byte TCP_SAS_NOSCRIPT = -3;
    private static final byte TCP_SAS_ENCRYPT = -4;
    private static final byte TCP_SAS_INHERIT = -5;
    private static final byte TCP_SAS_LOGSVR = -10;
    private static final byte TCP_IS = 0;
    private static final byte TCP_SEND = 1;
    private static final String defaultLineTerminator = "\n";
    private static final String defaultInputLineTerminator = "\r\n";
    private static final String defaultCryptoPolicy = "none";
    private Properties info = null;
    private Socket socket = null;
    private DataInputStream sockInput = null;
    private DataOutputStream sockOutput = null;
    private String textString = null;
    private int textStringIndex = 0;
    private ByteArrayOutputStream textBytes = new ByteArrayOutputStream();
    private byte[] lineTerminator = null;
    private byte[] inputLineTerminator = null;
    private byte[] textByteArray = null;
    private int textByteLen = 0;
    private int textByteIndex = 0;
    private ByteArrayOutputStream filteredBytes = new ByteArrayOutputStream();
    private byte[] tempBuffer = null;
    private boolean secure = false;
    private byte[] challenge = null;
    private byte[] response = null;
    private Crypt crypt = null;
    private boolean encrypt = false;
    private String cryptoTarget = null;
    private String cryptoPolicy = null;
    private String cryptoAlgorithms = null;
    private Crypto crypto = null;
    private CipherInterface cipher = null;
    private boolean socketInherited = false;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private String telnetTextFormat = null;
    private boolean disableInherit = false;
    private boolean d = false;
    private String serverName;
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SASTelnetClient(Properties properties) {
        this.info = properties == null ? new Properties() : (Properties)properties.clone();
        if (this.d) {
            SASTelnetClient.pl(this.info.toString());
        }
        this.telnetTextFormat = this.info.getProperty("telnetTextFormat");
        String temp = this.info.getProperty("lineTerminator", defaultLineTerminator);
        try {
            this.lineTerminator = SASTelnetClient.textToBytes(this.telnetTextFormat, temp);
        }
        catch (TelnetClientException e) {
            try {
                this.lineTerminator = SASTelnetClient.textToBytes(null, temp);
            }
            catch (TelnetClientException telnetClientException) {
                // empty catch block
            }
        }
        if (this.d) {
            SASTelnetClient.pl("output line terminator: " + SASTelnetClient.printBytes(this.lineTerminator, this.lineTerminator.length, true));
        }
        temp = this.info.getProperty("inputLineTerminator", defaultInputLineTerminator);
        try {
            this.inputLineTerminator = SASTelnetClient.textToBytes(this.telnetTextFormat, temp);
        }
        catch (TelnetClientException e) {
            try {
                this.inputLineTerminator = SASTelnetClient.textToBytes(null, temp);
            }
            catch (TelnetClientException telnetClientException) {
                // empty catch block
            }
        }
        if (this.d) {
            SASTelnetClient.pl("input line terminator: " + SASTelnetClient.printBytes(this.inputLineTerminator, this.inputLineTerminator.length, true));
        }
        this.cryptoTarget = this.info.getProperty("encryptionTarget");
        this.cryptoPolicy = this.info.getProperty("encryptionPolicy", defaultCryptoPolicy);
        if (this.d) {
            SASTelnetClient.pl("crypto policy: " + this.cryptoPolicy);
        }
        this.cryptoAlgorithms = this.info.getProperty("encryptionAlgorithms");
        temp = this.info.getProperty("disableSocketInheritance");
        if (temp != null && temp.length() > 0) {
            this.disableInherit = true;
        }
        this.serverName = this.info.getProperty("serverName");
        if (this.d) {
            SASTelnetClient.pl("server name: " + this.serverName);
        }
    }

    public SASTelnetClient() {
        this(null);
    }

    @Override
    public void connect(String host, int port) throws TelnetClientException {
        try {
            this.socket = new Socket(host, port);
            this.socket.setTcpNoDelay(true);
            this.sockOutput = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 256));
            this.sockInput = new DataInputStream(this.socket.getInputStream());
            if (this.d) {
                SASTelnetClient.pl("Connected to host " + host + " on port " + port);
            }
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
    }

    @Override
    public void disconnect() throws TelnetClientException {
        if (this.d) {
            SASTelnetClient.pl("Disconnecting");
        }
        if (this.cipher != null) {
            try {
                this.cipher.close();
                this.cipher = null;
            }
            catch (CryptoException e) {
                throw new TelnetClientException(e);
            }
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
            this.sockOutput = null;
            this.sockInput = null;
            this.socketInherited = false;
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char receiveChar(int tioTimeout) throws TelnetClientException {
        Object object = this.receiveLock;
        synchronized (object) {
            try {
                this.socket.setSoTimeout(tioTimeout);
            }
            catch (IOException e) {
                throw new TelnetClientException(e);
            }
            if (this.textString == null) {
                if (this.d) {
                    System.out.println("refreshing textString");
                }
                this.refreshTextString();
            }
            char c = '\u0000';
            if (this.textStringIndex >= this.textString.length()) {
                c = '\n';
                this.textString = null;
                this.textStringIndex = 0;
            } else {
                c = this.textString.charAt(this.textStringIndex++);
            }
            if (this.d) {
                byte b = (byte)c;
                if (b >= 32 && b <= 126) {
                    SASTelnetClient.pl("Returning character: " + c + " (" + SASTelnetClient.toHex(b, true) + ")");
                } else {
                    SASTelnetClient.pl("Returning character: (" + SASTelnetClient.toHex(b, true) + ")");
                }
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendString(String inString) throws TelnetClientException {
        Object object = this.sendLock;
        synchronized (object) {
            byte[] tempInBytes = SASTelnetClient.textToBytes(this.telnetTextFormat, inString);
            byte[] inBytes = new byte[tempInBytes.length + this.lineTerminator.length];
            System.arraycopy(tempInBytes, 0, inBytes, 0, tempInBytes.length);
            System.arraycopy(this.lineTerminator, 0, inBytes, tempInBytes.length, this.lineTerminator.length);
            int inBytesLen = inBytes.length;
            try {
                if (this.secure) {
                    int responseLen = this.crypt.zscode(this.challenge, this.challenge.length, this.response, this.response.length);
                    if (this.d) {
                        SASTelnetClient.pl("Sending length of crypto response: " + responseLen);
                    }
                    this.sockOutput.writeInt(responseLen);
                    if (this.d) {
                        SASTelnetClient.pl("Sending crypto response:\n" + SASTelnetClient.printBytes(this.response, responseLen, true));
                    }
                    this.sockOutput.write(this.response, 0, responseLen);
                    int cryptBytesLen = (inBytesLen + 5) / 3 << 2;
                    if (this.tempBuffer == null || this.tempBuffer.length < cryptBytesLen) {
                        this.tempBuffer = new byte[cryptBytesLen];
                    }
                    if (this.d) {
                        SASTelnetClient.pl("Securing text: " + inString);
                    }
                    this.crypt.zscode(inBytes, inBytesLen, this.tempBuffer, cryptBytesLen);
                    if (this.d) {
                        SASTelnetClient.pl("Sending length of secure text:\n" + cryptBytesLen);
                    }
                    this.sockOutput.writeInt(cryptBytesLen);
                    if (this.d) {
                        SASTelnetClient.pl("Sending secure text:\n" + SASTelnetClient.printBytes(this.tempBuffer, cryptBytesLen, true));
                    }
                    this.sockOutput.write(this.tempBuffer, 0, cryptBytesLen);
                } else if (this.encrypt) {
                    try {
                        int responseLen = this.cipher.getCipherTextLength(this.challenge.length);
                        if (this.response == null || this.response.length < responseLen) {
                            this.response = new byte[responseLen];
                        }
                        if (this.d) {
                            SASTelnetClient.pl("Sending length of crypto response: " + responseLen);
                        }
                        this.sockOutput.writeInt(responseLen);
                        if (this.d) {
                            SASTelnetClient.pl("Sending crypto response");
                        }
                        this.cipher.encrypt(this.challenge, 0, this.challenge.length, (OutputStream)this.sockOutput);
                        int cryptBytesLen = this.cipher.getCipherTextLength(inBytesLen);
                        if (this.d) {
                            SASTelnetClient.pl("Sending length of encrypted text: " + cryptBytesLen);
                        }
                        this.sockOutput.writeInt(cryptBytesLen);
                        if (this.d) {
                            SASTelnetClient.pl("Sending encrypted text");
                        }
                        this.cipher.encrypt(inBytes, 0, inBytesLen, (OutputStream)this.sockOutput);
                    }
                    catch (CryptoException c) {
                        throw new TelnetClientException(c);
                    }
                } else {
                    if (this.d) {
                        SASTelnetClient.pl("Sending text:\n" + SASTelnetClient.printBytes(inBytes, inBytesLen, this.secure || this.encrypt));
                    }
                    this.sockOutput.write(inBytes, 0, inBytesLen);
                }
                this.sockOutput.flush();
            }
            catch (IOException e) {
                throw new TelnetClientException(e);
            }
        }
    }

    @Override
    public boolean isSocketInherited() {
        return this.socketInherited;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public CipherInterface getCipher() {
        return this.cipher;
    }

    public void connect(String host) throws TelnetClientException {
        this.connect(host, 23);
    }

    private void refreshTextString() throws TelnetClientException {
        int bytesFound = 0;
        do {
            byte b;
            int i;
            if ((i = this.getTextByte(false)) < 0) {
                if (this.textBytes.size() > 0) {
                    byte[] tempBytes = this.textBytes.toByteArray();
                    this.textString = SASTelnetClient.bytesToText(this.telnetTextFormat, tempBytes, 0, tempBytes.length);
                    this.textBytes.reset();
                    return;
                }
                i = this.getTextByte(true);
            }
            if ((b = (byte)i) == this.inputLineTerminator[bytesFound]) {
                ++bytesFound;
                continue;
            }
            for (int j = 0; j < bytesFound; ++j) {
                this.textBytes.write(this.inputLineTerminator[j] & 0xFF);
            }
            bytesFound = 0;
            if (b == this.inputLineTerminator[0]) {
                ++bytesFound;
                continue;
            }
            this.textBytes.write(b & 0xFF);
        } while (bytesFound != this.inputLineTerminator.length);
        byte[] tempBytes = this.textBytes.toByteArray();
        this.textString = SASTelnetClient.bytesToText(this.telnetTextFormat, tempBytes, 0, tempBytes.length);
        this.textBytes.reset();
    }

    private int getTextByte(boolean block) throws TelnetClientException {
        if (this.textByteArray == null || this.textByteIndex >= this.textByteLen) {
            do {
                try {
                    if (!block && this.sockInput.available() == 0) {
                        return -1;
                    }
                }
                catch (IOException e) {
                    throw new TelnetClientException(e);
                }
                this.textByteLen = 0;
                this.textByteIndex = 0;
                if (this.secure) {
                    this.getSecureText();
                    continue;
                }
                if (this.encrypt) {
                    this.getEncryptedText();
                    continue;
                }
                this.parseRawBytes();
            } while (this.textByteArray == null || this.textByteLen == 0);
        }
        return this.textByteArray[this.textByteIndex++] & 0xFF;
    }

    private void parseRawBytes() throws TelnetClientException {
        byte[] iac_reply = new byte[9];
        int prev_byte = 0;
        byte input = 0;
        byte command = 0;
        try {
            block17: do {
                input = this.sockInput.readByte();
                if (prev_byte == -1) {
                    prev_byte = 0;
                    command = input;
                    switch (command) {
                        case -1: {
                            this.filteredBytes.write(-1);
                            break;
                        }
                        case -5: {
                            input = this.sockInput.readByte();
                            iac_reply[0] = -1;
                            iac_reply[2] = input;
                            iac_reply[1] = input == 1 || input == 3 ? -3 : -2;
                            this.sockOutput.write(iac_reply, 0, 3);
                            this.sockOutput.flush();
                            if (this.d) {
                                SASTelnetClient.pl("Received WILL: " + SASTelnetClient.toHex(input, true));
                            }
                            if (!this.d) continue block17;
                            SASTelnetClient.pl("Sending " + (iac_reply[1] == -3 ? "DO" : "DONT") + ": " + SASTelnetClient.toHex(input, true));
                            break;
                        }
                        case -3: {
                            input = this.sockInput.readByte();
                            iac_reply[0] = -1;
                            iac_reply[2] = input;
                            switch (input) {
                                case 3: 
                                case 24: {
                                    iac_reply[1] = -5;
                                    break;
                                }
                                case -2: {
                                    iac_reply[1] = -5;
                                    this.secure = true;
                                    this.challenge = new byte[8];
                                    this.response = new byte[16];
                                    this.crypt = new Crypt();
                                    break;
                                }
                                case -5: {
                                    if (this.disableInherit) {
                                        iac_reply[1] = -4;
                                        break;
                                    }
                                    iac_reply[1] = -5;
                                    this.socketInherited = true;
                                    break;
                                }
                                case -3: {
                                    iac_reply[0] = 0;
                                    iac_reply[1] = -4;
                                    break;
                                }
                                case -4: {
                                    if ((this.cryptoPolicy.equals("required") || this.cryptoPolicy.equals("optional")) && (this.socketInherited || this.cryptoTarget != null && (this.cryptoTarget.equals("telnet") || this.cryptoTarget.equals("both")))) {
                                        iac_reply[1] = -5;
                                        this.encrypt = true;
                                        this.challenge = new byte[8];
                                        break;
                                    }
                                    iac_reply[1] = -4;
                                    break;
                                }
                                case -10: {
                                    iac_reply[1] = this.serverName != null && this.serverName.trim().length() > 0 ? -5 : -4;
                                    break;
                                }
                                default: {
                                    iac_reply[1] = -4;
                                }
                            }
                            this.sockOutput.write(iac_reply, 0, 3);
                            this.sockOutput.flush();
                            if (this.d) {
                                SASTelnetClient.pl("Received DO: " + SASTelnetClient.toHex(input, true));
                            }
                            if (!this.d) continue block17;
                            SASTelnetClient.pl("Sending " + (iac_reply[1] == -5 ? "WILL" : "WONT") + ": " + SASTelnetClient.toHex(input, true));
                            break;
                        }
                        case -4: 
                        case -2: {
                            input = this.sockInput.readByte();
                            if (!this.d) continue block17;
                            SASTelnetClient.pl("Received " + (command == -2 ? "DONT" : "WONT") + ": " + SASTelnetClient.toHex(input, true));
                            break;
                        }
                        case -6: {
                            input = this.sockInput.readByte();
                            iac_reply[0] = -1;
                            iac_reply[1] = -6;
                            boolean done = false;
                            if (input == 24) {
                                input = this.sockInput.readByte();
                                if (input == 1) {
                                    iac_reply[2] = 24;
                                    iac_reply[3] = 0;
                                    iac_reply[4] = 116;
                                    iac_reply[5] = 116;
                                    iac_reply[6] = 121;
                                    iac_reply[7] = -1;
                                    iac_reply[8] = -16;
                                    this.sockOutput.write(iac_reply, 0, 9);
                                    this.sockOutput.flush();
                                }
                            } else if (input == -10) {
                                if (this.serverName == null || this.serverName.trim().length() == 0) {
                                    throw new IllegalStateException("unexpected request for server name");
                                }
                                byte[] serverNameBytes = this.serverName.trim().getBytes("UTF8");
                                int replyL = serverNameBytes.length + 6;
                                byte[] replyBuf = new byte[replyL];
                                replyBuf[0] = -1;
                                replyBuf[1] = -6;
                                replyBuf[2] = -10;
                                replyBuf[3] = 0;
                                System.arraycopy(serverNameBytes, 0, replyBuf, 4, serverNameBytes.length);
                                replyBuf[replyL - 2] = -1;
                                replyBuf[replyL - 1] = -16;
                                this.sockOutput.write(replyBuf, 0, replyL);
                                this.sockOutput.flush();
                                done = true;
                            }
                            while (!done) {
                                if (input == -1) {
                                    input = this.sockInput.readByte();
                                    if (input == -16) {
                                        done = true;
                                        continue;
                                    }
                                    input = this.sockInput.readByte();
                                    continue;
                                }
                                input = this.sockInput.readByte();
                            }
                            if (!this.d) continue block17;
                            SASTelnetClient.pl("Received sub-protocol");
                            break;
                        }
                        default: {
                            input = this.sockInput.readByte();
                            if (!this.d) continue block17;
                            SASTelnetClient.pl("Received unknown command: " + SASTelnetClient.toHex(command, false) + " " + SASTelnetClient.toHex(input, false));
                            break;
                        }
                    }
                    continue;
                }
                prev_byte = input;
                if (input == -1) continue;
                if (this.cryptoPolicy.equals("required") && !this.encrypt && this.cryptoTarget != null && (this.cryptoTarget.equals("telnet") || this.cryptoTarget.equals("both"))) {
                    String messageIndex = "Connect.C113.ex.txt";
                    Object[] messageArg = new Object[]{messageIndex};
                    throw new TelnetClientException(ConnectLocalizedError.getLocalizedError("{0}: A SAS telnet daemon or spawner is required for encryption.", messageArg));
                }
                this.filteredBytes.write(input & 0xFF);
            } while (!this.secure && !this.encrypt && this.sockInput.available() > 0);
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
        if (this.filteredBytes.size() > 0) {
            this.textByteArray = this.filteredBytes.toByteArray();
            this.textByteLen = this.textByteArray.length;
            this.filteredBytes.reset();
        }
        if (this.encrypt) {
            this.getCrypto();
        }
    }

    private void getSecureText() throws TelnetClientException {
        try {
            if (this.d) {
                SASTelnetClient.pl("Getting a secure prompt");
            }
            int promptLen = this.sockInput.readInt();
            if (this.d) {
                SASTelnetClient.pl("Received prompt length: " + promptLen);
            }
            if (this.tempBuffer == null || this.tempBuffer.length < promptLen) {
                this.tempBuffer = new byte[promptLen];
            }
            this.sockInput.readFully(this.tempBuffer, 0, promptLen);
            System.arraycopy(this.tempBuffer, 0, this.challenge, 0, this.challenge.length);
            if (this.d) {
                SASTelnetClient.pl("Received challenge:\n" + SASTelnetClient.printBytes(this.challenge, this.challenge.length, true));
            }
            this.textByteLen = promptLen - this.challenge.length;
            if (this.textByteArray == null || this.textByteArray.length < this.textByteLen) {
                this.textByteArray = new byte[this.textByteLen];
            }
            System.arraycopy(this.tempBuffer, 8, this.textByteArray, 0, this.textByteLen);
            if (this.d) {
                SASTelnetClient.pl("Received secure text:\n" + SASTelnetClient.printBytes(this.textByteArray, this.textByteLen, false));
            }
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
    }

    private void getEncryptedText() throws TelnetClientException {
        try {
            if (this.d) {
                SASTelnetClient.pl("Getting an encrypted prompt");
            }
            int promptLen = this.sockInput.readInt();
            if (this.d) {
                SASTelnetClient.pl("Received prompt length: " + promptLen);
            }
            if (this.tempBuffer == null || this.tempBuffer.length < promptLen) {
                this.tempBuffer = new byte[promptLen];
            }
            this.sockInput.readFully(this.tempBuffer, 0, promptLen);
            System.arraycopy(this.tempBuffer, 0, this.challenge, 0, this.challenge.length);
            if (this.d) {
                SASTelnetClient.pl("Received challenge:\n" + SASTelnetClient.printBytes(this.challenge, this.challenge.length, true));
            }
            int cipherTextLen = promptLen - this.challenge.length;
            ByteArrayInputStream tempInput = new ByteArrayInputStream(this.tempBuffer, this.challenge.length, cipherTextLen);
            int maxPlainTextLen = this.cipher.getMaxPlainTextLength(cipherTextLen);
            if (this.textByteArray == null || this.textByteArray.length < maxPlainTextLen) {
                this.textByteArray = new byte[maxPlainTextLen];
            }
            this.textByteLen = this.cipher.decrypt((InputStream)tempInput, cipherTextLen, this.textByteArray, 0);
            if (this.d) {
                SASTelnetClient.pl("Length of plaintext: " + this.textByteLen);
            }
            if (this.d) {
                SASTelnetClient.pl("Received encrypted text: " + SASTelnetClient.printBytes(this.textByteArray, this.textByteLen, false));
            }
        }
        catch (CryptoException e) {
            throw new TelnetClientException(e);
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
    }

    private void getCrypto() throws TelnetClientException {
        block26: {
            try {
                int i;
                if (this.d) {
                    SASTelnetClient.pl("Getting Crypto");
                }
                int algListLen = this.sockInput.readInt();
                if (this.d) {
                    SASTelnetClient.pl("Read algorithm list length " + algListLen);
                }
                byte[] asciiAlgList = new byte[algListLen];
                this.sockInput.readFully(asciiAlgList);
                char[] charAlgList = new char[algListLen];
                for (int i2 = 0; i2 < algListLen; ++i2) {
                    int c = asciiAlgList[i2] & 0xFF;
                    charAlgList[i2] = c != 0 ? (int)c : 44;
                }
                String algList = new String(charAlgList);
                algList = algList.trim();
                if (this.d) {
                    SASTelnetClient.pl("Read algorithm list: " + algList);
                }
                String[] serverAlgList = null;
                if (algList != null && algList.length() > 0) {
                    StringTokenizer serverTokens = new StringTokenizer(algList, ",");
                    int serverTokenCount = serverTokens.countTokens();
                    serverAlgList = new String[serverTokenCount];
                    for (i = 0; i < serverTokenCount; ++i) {
                        serverAlgList[i] = serverTokens.nextToken().trim();
                    }
                }
                if (serverAlgList != null && serverAlgList.length > 0) {
                    StringTokenizer clientTokens = null;
                    clientTokens = this.cryptoAlgorithms != null && this.cryptoAlgorithms.length() > 0 ? new StringTokenizer(this.cryptoAlgorithms.trim(), ",") : new StringTokenizer(algList, "\u0000");
                    String algName = null;
                    while (true) {
                        if (clientTokens.hasMoreTokens()) {
                            algName = clientTokens.nextToken().trim();
                            for (i = 0; i < serverAlgList.length && !algName.equalsIgnoreCase(serverAlgList[i]); ++i) {
                            }
                            if (i >= serverAlgList.length) {
                                algName = null;
                                continue;
                            }
                        }
                        if (algName != null && algName.length() > 0) {
                            this.crypto = Crypto.getCrypto((String)algName, (Properties)this.info);
                        }
                        if (this.crypto != null || !clientTokens.hasMoreTokens()) break;
                    }
                }
                byte[] codeBuffer = new byte[32];
                if (this.crypto != null) {
                    String algName = this.crypto.getName();
                    if (this.d) {
                        SASTelnetClient.pl("Chose algorithm: " + algName);
                    }
                    int l = algName.length();
                    for (int i3 = 0; i3 < l && i3 < 32; ++i3) {
                        codeBuffer[i3] = (byte)algName.charAt(i3);
                    }
                    if (l < 32) {
                        codeBuffer[l] = 0;
                    }
                } else {
                    codeBuffer[0] = 0;
                    if (this.d) {
                        SASTelnetClient.pl("Could not agree on algorithm");
                    }
                }
                this.sockOutput.write(codeBuffer);
                this.sockOutput.flush();
                if (this.crypto == null) {
                    if (this.cryptoPolicy.equals("required")) {
                        String messageIndex = "Connect.C114.ex.txt";
                        Object[] messageArg = new Object[]{messageIndex};
                        throw new TelnetClientException(ConnectLocalizedError.getLocalizedError("{0}: Telnet client and spawner could not agree on an encryption algorithm", messageArg));
                    }
                    this.encrypt = false;
                    break block26;
                }
                try {
                    this.cipher = this.crypto.openCipher();
                    if (this.d) {
                        SASTelnetClient.pl("Starting key exchange");
                    }
                    this.cipher.keyExchange((InputStream)this.sockInput, (OutputStream)this.sockOutput);
                    if (this.d) {
                        SASTelnetClient.pl("Finished key exchange");
                    }
                }
                catch (CryptoException c) {
                    throw new TelnetClientException(c);
                }
            }
            catch (IOException e) {
                throw new TelnetClientException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] textToBytes(String encoding, String text) throws TelnetClientException {
        if (text == null) {
            return null;
        }
        int length = text.length();
        byte[] bytes = null;
        if (encoding == null) {
            bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)text.charAt(i);
            }
        } else {
            EncoderInterface encoder = null;
            try {
                encoder = Encoder.getInstance((String)encoding);
            }
            catch (UnsupportedEncodingException e) {
                String messageIndex = "Connect.C119.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, encoding};
                throw new TelnetClientException(ConnectLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
            }
            try {
                bytes = encoder.toByteArray(text, 0, length);
            }
            finally {
                Encoder.returnInstance((EncoderInterface)encoder);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String bytesToText(String encoding, byte[] bytes, int offset, int length) throws TelnetClientException {
        String text = null;
        if (encoding == null) {
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                byte c = bytes[i + offset];
                chars[i] = c >= 0 ? (char)c : (char)(c + 256);
            }
            text = new String(chars);
        } else {
            EncoderInterface encoder = null;
            try {
                encoder = Encoder.getInstance((String)encoding);
            }
            catch (UnsupportedEncodingException e) {
                String messageIndex = "Connect.C120.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, encoding};
                throw new TelnetClientException(ConnectLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
            }
            try {
                text = encoder.toString(bytes, offset, length);
            }
            finally {
                Encoder.returnInstance((EncoderInterface)encoder);
            }
        }
        return text;
    }

    private static void pl(String s) {
        System.out.println(s);
    }

    private static byte[] intToBytes(int n) throws TelnetClientException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(4);
            DataOutputStream filter = new DataOutputStream(stream);
            filter.writeInt(n);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new TelnetClientException(e);
        }
    }

    private static String toHex(byte b, boolean hexOnly) {
        char[] c = new char[5];
        c[1] = a[b & 0xF];
        c[0] = a[(b & 0xF0) >>> 4];
        if (hexOnly) {
            return new String(c, 0, 2);
        }
        c[2] = 40;
        c[4] = 41;
        c[3] = b >= 32 && b < 255 ? (int)b : 46;
        return new String(c);
    }

    private static String printBytes(byte[] b, int bLen, boolean hexOnly) {
        int i = 0;
        char[] c = new char[65];
        StringBuffer sb = new StringBuffer();
        while (i < bLen) {
            for (int ii = 0; ii < 65; ++ii) {
                c[ii] = 32;
            }
            if (!hexOnly) {
                c[32] = 58;
            }
            for (int j = 0; j < 16 && i < bLen; ++i, ++j) {
                c[j * 2] = a[(b[i] & 0xF0) >>> 4];
                c[j * 2 + 1] = a[b[i] & 0xF];
                if (hexOnly) continue;
                c[j * 2 + 34] = b[i] >= 32 && b[i] < 255 ? (int)b[i] : 46;
            }
            sb.append(c, 0, hexOnly ? 32 : 65);
            if (i >= bLen) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

