/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.io.Encoder;
import com.sas.io.EncoderInterface;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import com.sas.net.connect.ConnectRecord;
import com.sas.net.connect.FopenResponseRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

@SASScope
public class FopenRecord
extends ConnectRecord {
    short FOOPTIONS = 0;
    int FOFILELEN = 0;
    int FOLRECL = 0;
    int FO7AFTER = 0;
    byte[] FOFILENAME = null;
    private String messageIndex;

    public FopenRecord(ConnectClient client) throws ConnectException {
        super(client, true);
        this.maxlen = 70;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void action() throws ConnectException {
        super.action();
        int mver = this.client.getMver();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(this.buf);
            DataInputStream stream = new DataInputStream(input);
            this.FOOPTIONS = stream.readShort();
            this.FOFILELEN = stream.readInt();
            this.FOLRECL = stream.readInt();
            int nameOffset = 10;
            if (mver >= 30) {
                this.FO7AFTER = stream.readInt();
                nameOffset += 4;
            }
            this.FOFILENAME = new byte[this.buf.length - nameOffset];
            stream.read(this.FOFILENAME);
        }
        catch (IOException e) {
            this.messageIndex = "Connect.C40.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
        if ((this.FOOPTIONS & 1) == 0 || (this.FOOPTIONS & 8) != 0) {
            FopenResponseRecord record = new FopenResponseRecord(this.client, this.FOLRECL, 110);
            this.client.addRecords(record, true);
            return;
        }
        boolean text = (this.FOOPTIONS & 4) != 0;
        EncoderInterface encoder = null;
        try {
            encoder = Encoder.getInstance((String)this.client.getTextTransportFormat());
        }
        catch (UnsupportedEncodingException e) {
            this.messageIndex = "Connect.C121.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, this.client.getTextTransportFormat()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Unsupported character encoding: {1}", messageArg));
        }
        String fileName = null;
        try {
            fileName = encoder.toString(this.FOFILENAME, 0, this.FOFILENAME.length);
            fileName = fileName.trim();
        }
        finally {
            Encoder.returnInstance((EncoderInterface)encoder);
        }
        int dataLength = this.FOLRECL;
        if (mver < 30) {
            ++dataLength;
        }
        this.client.createDownload(fileName, dataLength, text);
        FopenResponseRecord record = new FopenResponseRecord(this.client, this.FOLRECL);
        this.client.addRecords(record, true);
    }
}

