/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.codepolicy.SASScope;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLocalizedError;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

@SASScope
public class ConnectRecord {
    static final int WHOLE = 0;
    static final int FIRST = 1;
    static final int MIDDLE = 2;
    static final int LAST = 3;
    static final int RQED = 0;
    static final int EDLN = 1;
    static final int LOGLN = 2;
    static final int PRTLN = 3;
    static final int RENULL = 4;
    static final int DDEF = 5;
    static final int REDDEF = 6;
    static final int RQDDEF = 11;
    static final int RQSHUT = 16;
    static final int VER = 17;
    static final int REVER = 18;
    static final int INV = 19;
    static final int SINV = 20;
    static final int XNULL = 21;
    static final int SHUT = 22;
    static final int RESHUT = 23;
    static final int RERQDDEF = 28;
    static final int FOPEN = 32;
    static final int FREOPEN = 33;
    static final int FDATA = 38;
    static final int FEOF = 39;
    static final int FSACK = 41;
    static final int ENDRSUB = 45;
    static final int SRPUT = 46;
    static final int REQSERV = 67;
    static final int REPSERV = 68;
    static final int ENABLEREMOTEINTERFACE = 83;
    static final int REMOTEINTERFACEOK = 84;
    static final int ROBJ = 85;
    static final int ROBJRESPONSE = 86;
    protected static final int SJRNUM = 117;
    protected static final int REJRNUM = 118;
    static final int RINST = 1;
    static final int RINSTD = 2;
    static final int RMTH = 3;
    static final int RMTHD = 4;
    static final int DRINST = 5;
    static final int DRINSTD = 6;
    static final int LVER604 = 3;
    static final int LVER606 = 4;
    static final int LVER6073 = 7;
    static final int LVER608 = 10;
    static final int LVER89Z = 11;
    static final int LVER69EM = 12;
    static final int LVER610 = 13;
    static final int LVER61002 = 14;
    static final int LVER611 = 16;
    static final int LVER612 = 19;
    static final int LVER701 = 30;
    static final int LVER800 = 35;
    static final int LVER801 = 40;
    static final int LVER802 = 45;
    static final int RVER = 45;
    static final int ESC = 188;
    static final int ESCESC = 0;
    static final int ESCLEN = 2;
    static final int COMPLEN = 2;
    static final int CHAR0 = 0;
    static final int CHAR1 = 32;
    static final int CHARSHIFT = 7;
    static final int CHARMASK = 1;
    static final int COUNTMASK = 127;
    static final int COUNTOFF = -2;
    static final int MINCOUNT = 3;
    static final int MAXCOUNT = 129;
    static final int HDRLEN = 4;
    byte[] readbuf = new byte[4096];
    protected byte[] buf = null;
    protected int rec_code = 0;
    int sub_code = 0;
    int rec_type = 0;
    int rec_comp = 0;
    protected int maxlen = 0;
    int in_len = 0;
    int final_len = 0;
    protected ConnectClient client = null;
    boolean variable = false;
    private String messageIndex;
    static int[] compstr = new int[2];

    public static byte[] compress(byte[] inbuffer) throws ConnectException {
        int maxlen = inbuffer.length;
        byte[] outbuf = new byte[maxlen];
        int count = 0;
        int dpos = 0;
        int spos = 0;
        int slen = inbuffer.length;
        int c = 0;
        int code = 0;
        int limit = 0;
        boolean compressed = false;
        if (inbuffer.length < 2) {
            return null;
        }
        block5: while (spos < slen) {
            code = 2;
            c = inbuffer[spos++] & 0xFF;
            switch (c) {
                case 0: {
                    --code;
                }
                case 32: {
                    int i;
                    --code;
                    limit = Math.min(slen - spos, 128);
                    if (limit == 0) {
                        count = 1;
                    } else {
                        int temp;
                        count = 1;
                        for (i = 0; i < limit && (temp = inbuffer[i + spos] & 0xFF) == c; ++i) {
                            ++count;
                        }
                    }
                    spos += count - 1;
                    if (count >= 3) {
                        compressed = true;
                        if (dpos + 2 > maxlen) {
                            return null;
                        }
                        outbuf[dpos++] = -68;
                        outbuf[dpos++] = (byte)(code << 7 | count + -2);
                        continue block5;
                    }
                    if (dpos + count > maxlen) {
                        return null;
                    }
                    for (i = 0; i < count; ++i) {
                        outbuf[dpos++] = (byte)c;
                    }
                    continue block5;
                }
                case 188: {
                    if (dpos + 2 > maxlen) {
                        return null;
                    }
                    compressed = true;
                    outbuf[dpos++] = -68;
                    outbuf[dpos++] = 0;
                    continue block5;
                }
            }
            if (dpos + 1 > maxlen) {
                return null;
            }
            outbuf[dpos++] = (byte)c;
        }
        if (!compressed) {
            return null;
        }
        byte[] btemp = new byte[dpos];
        System.arraycopy(outbuf, 0, btemp, 0, dpos);
        return btemp;
    }

    public static byte[] decompress(byte[] buf, int length, int maxlen) throws ConnectException {
        int count = 0;
        int spos = 0;
        int slen = length;
        int c = 0;
        ByteArrayOutputStream bytesout = new ByteArrayOutputStream(maxlen);
        DataOutputStream outbuf = new DataOutputStream(bytesout);
        while (spos < slen) {
            c = buf[spos++] & 0xFF;
            try {
                if (c == 188) {
                    if ((c = buf[spos++] & 0xFF) == 0) {
                        outbuf.writeByte(188);
                        continue;
                    }
                    count = (c & 0x7F) - -2;
                    c = compstr[c >>> 7 & 1];
                    for (int i = 0; i < count; ++i) {
                        outbuf.writeByte(c);
                    }
                    continue;
                }
                outbuf.writeByte(c);
            }
            catch (IOException ioe) {
                String messageIndex = "Connect.C29.ex.txt";
                Object[] messageArg = new Object[]{messageIndex, ioe.getMessage()};
                throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
            }
        }
        return bytesout.toByteArray();
    }

    public ConnectRecord(ConnectClient client) throws ConnectException {
        this.client = client;
    }

    public ConnectRecord(ConnectClient client, boolean var) throws ConnectException {
        this.client = client;
        this.variable = var;
    }

    public synchronized int getReccode() throws ConnectException {
        return this.rec_code;
    }

    public synchronized byte[] getBuffer() throws ConnectException {
        return this.buf;
    }

    public synchronized void empty(int rec_code) throws ConnectException {
        this.rec_code = rec_code & 0xFF;
        this.rec_type = rec_code >> 14 & 3;
        this.rec_comp = rec_code >> 13 & 1;
        this.in_len = 0;
        this.final_len = 0;
        this.buf = null;
    }

    public synchronized void add(DataInputStream stream, int i) throws ConnectException {
        try {
            if (this.in_len + i > this.readbuf.length) {
                byte[] nbuf = new byte[this.in_len + i];
                System.arraycopy(this.readbuf, 0, nbuf, 0, this.in_len);
                this.readbuf = nbuf;
            }
            stream.readFully(this.readbuf, this.in_len, i);
            this.in_len += i;
        }
        catch (IOException e) {
            this.messageIndex = "Connect.C30.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex, e.getMessage()};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: {1}", messageArg));
        }
    }

    public synchronized void action() throws ConnectException {
        if (this.rec_comp != 0) {
            byte[] tbuf = ConnectRecord.decompress(this.readbuf, this.in_len, this.maxlen);
            this.buf = tbuf;
            this.final_len = this.buf.length;
        } else {
            this.buf = this.readbuf;
            this.final_len = this.in_len;
        }
        if (this.final_len != 0 && !this.variable && this.final_len > this.maxlen) {
            this.messageIndex = "Connect.C31.ex.txt";
            Object[] messageArg = new Object[]{this.messageIndex};
            throw new ConnectException(ConnectLocalizedError.getLocalizedError("{0}: Record length exceeds maximum.", messageArg));
        }
    }

    protected void putRecord(String name, ConnectRecord record) {
        this.client.recordTable.put(name, record);
    }

    static {
        ConnectRecord.compstr[0] = 0;
        ConnectRecord.compstr[1] = 32;
    }
}

