/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.editors;

import com.sas.common.util.InputScreener;
import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.OMRGuiDefValidValueItem;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.editors.CustomEditor;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;

public class HTMLDropDownEditor
implements CustomEditor {
    static final long serialVersionUID = -8021366437841961669L;
    private String _loggingContext = this.getClass().getName();
    private UserContextInterface m_userContext = null;

    @Override
    public void setProfile(SASProfileInterface profile) throws RemoteException {
        this.setProfileLocale(profile);
    }

    @Override
    public void setProfileLocale(SASProfileInterface profile) throws RemoteException {
        if (profile != null) {
            this.m_userContext = profile.getUserContext();
        }
    }

    public SASProfileInterface getProfile() throws RemoteException {
        SASProfileInterface retval = null;
        if (this.m_userContext != null) {
            try {
                retval = (SASProfileInterface)this.m_userContext.getProfile().getRootProfile().getProfile("SAS");
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }
        return retval;
    }

    private Locale getLocaleToUse() {
        Locale userLocale = Locale.getDefault();
        try {
            SASProfileInterface sasProfile = (SASProfileInterface)this.m_userContext.getProfile().getProfile("SAS");
            if (sasProfile != null) {
                userLocale = sasProfile.getLocale();
            }
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
        catch (ConfigurationPropertiesException se) {
            se.printStackTrace();
        }
        catch (RemoteException se) {
            se.printStackTrace();
        }
        return userLocale;
    }

    @Override
    public String getDisplayPromptOutputString(GuiDefDataInterface data) throws RemoteException {
        String promptToUse = data.getPrompt();
        Locale userLocale = this.getLocaleToUse();
        LogManager.getLogger((Class)this.m_userContext.getClass()).info("Locale to use is " + userLocale, (Object)this._loggingContext);
        if (promptToUse == null && data.getPrefKey() != null) {
            promptToUse = data.getPrefKey() + ".Prompt";
        }
        try {
            promptToUse = RB.getStringResource(promptToUse, userLocale);
        }
        catch (MissingResourceException e) {
            try {
                promptToUse = RB.getStringResource(promptToUse + ".txt", userLocale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (promptToUse == null) {
            String infoMsg = MessageFormat.format(RB.getStringResource("no_resource_translation_for_key.fmt.txt"), data.getPrompt());
            LogManager.getLogger((Class)this.m_userContext.getClass()).warn(infoMsg, (Object)this._loggingContext);
            promptToUse = data.getPrompt();
        }
        return promptToUse;
    }

    @Override
    public String getBodyOutputString(GuiDefDataInterface data) throws RemoteException {
        String internalVal;
        boolean isLocale = false;
        boolean selectMatchIfFound = true;
        StringBuffer sbuf = new StringBuffer();
        Locale userLocale = this.getLocaleToUse();
        String profileCurrentValue = data.getProfileCurrentValue();
        if (data.getPrefKey().equals("Locale.DefaultLocale")) {
            isLocale = true;
            if (!data.isSetAsOverride()) {
                selectMatchIfFound = false;
            }
            boolean foundIt = false;
            for (Object obj : data.getValidValues()) {
                String internalVal2;
                if (!(obj instanceof String) || !(internalVal2 = (String)obj).equals(profileCurrentValue)) continue;
                foundIt = true;
                break;
            }
            if (!foundIt && profileCurrentValue.indexOf("_") > 0) {
                String tmpProfileCurrentValue = profileCurrentValue.substring(0, profileCurrentValue.indexOf("_"));
                for (Object obj : data.getValidValues()) {
                    if (!(obj instanceof String) || !(internalVal = (String)obj).equals(tmpProfileCurrentValue)) continue;
                    foundIt = true;
                    break;
                }
                if (foundIt) {
                    profileCurrentValue = tmpProfileCurrentValue;
                }
            }
        }
        sbuf.append("<select name=\"" + data.getPrefKey() + "\" width=\"300\" style=\"width:300px\">\n");
        String defaultVal = data.getDefaultValue();
        String userDefaultVal = null;
        Iterator it = data.getValidValues().iterator();
        boolean firstTimeThrough = true;
        while (it.hasNext()) {
            Object obj;
            obj = it.next();
            internalVal = null;
            String internalToTranslate = null;
            if (obj.getClass() == String.class) {
                internalVal = (String)obj;
                internalToTranslate = (String)obj;
            } else if (obj instanceof OMRGuiDefValidValueItem) {
                internalVal = ((OMRGuiDefValidValueItem)obj).getValue();
                internalToTranslate = ((OMRGuiDefValidValueItem)obj).getDesc();
            }
            String userVal = internalVal;
            try {
                userVal = data.translateInternalVal(userLocale, internalToTranslate);
            }
            catch (Exception e) {
                LogManager.getLogger((Class)this.m_userContext.getClass()).warn(e.getMessage(), (Object)this._loggingContext);
            }
            if (userVal == null) {
                userVal = internalVal;
            }
            if (internalVal != null && internalVal.equals(defaultVal)) {
                userDefaultVal = userVal;
            }
            if (firstTimeThrough && isLocale) {
                internalVal = "";
            }
            sbuf.append("<option value=\"" + internalVal + "\"");
            if (profileCurrentValue != null && internalVal.equals(profileCurrentValue) && selectMatchIfFound) {
                sbuf.append(" selected ");
            } else if (profileCurrentValue == null && userDefaultVal != null && userVal.equals(userDefaultVal)) {
                sbuf.append(" selected ");
            }
            sbuf.append(" />" + userVal + "\n");
            firstTimeThrough = false;
        }
        if (defaultVal == null || defaultVal.trim().length() == 0) {
            defaultVal = data.getProfileCurrentValue();
        }
        if (userDefaultVal == null) {
            userDefaultVal = data.translateInternalVal(userLocale, defaultVal);
        }
        if (userDefaultVal != null && userDefaultVal.trim().length() > 0) {
            defaultVal = userDefaultVal;
        }
        sbuf.append("</select>   " + RB.getStringResource("Default.Label.txt", userLocale) + " " + defaultVal + "\n");
        return sbuf.toString();
    }

    @Override
    public String getDataClassName() {
        return "com.sas.preferences.data.OMRGuiDefData";
    }

    @Override
    public void pullInfoOutOfDisplayAndSetInData(Map displayAttributes, GuiDefDataInterface data) throws RemoteException {
        String valToSet = null;
        if (displayAttributes.containsKey(data.getPrefKey())) {
            Object obj = displayAttributes.get(data.getPrefKey());
            if (obj instanceof String) {
                valToSet = (String)obj;
            } else if (obj instanceof String[]) {
                String[] valueList = (String[])obj;
                valToSet = valueList[0];
            } else {
                String errorMsg = MessageFormat.format(RB.getStringResource("got_an_internal_map_with_contents_other_than_string_or_string_array.fmt.txt"), obj.getClass().getName());
                LogManager.getLogger((Class)this.m_userContext.getClass()).warn(errorMsg, (Object)this._loggingContext);
            }
            String screenedValToSet = InputScreener.screen(valToSet);
            data.setProfileCurrentValue(screenedValToSet);
            if (data.getPrefKey().equals("Locale.DefaultLocale")) {
                data.setDirty(true);
            }
        } else {
            String errorMsg = MessageFormat.format(RB.getStringResource("no_key_in_map_for_preference_key_provided.fmt.txt"), data.getPrefKey());
            LogManager.getLogger((Class)this.m_userContext.getClass()).warn(errorMsg, (Object)this._loggingContext);
        }
    }

    @Override
    public String toStringGivenData(GuiDefDataInterface data) {
        StringBuffer sbuf = new StringBuffer();
        Locale userLocale = this.getLocaleToUse();
        try {
            sbuf.append("Locale = " + (userLocale != null ? userLocale.toString() : "unknown") + "\n");
            sbuf.append("Profile current value = " + data.getProfileCurrentValue() + "\n");
            sbuf.append("getDisplayPromptOutputString: " + this.getDisplayPromptOutputString(data) + "\n");
            sbuf.append("getBodyOutputString: " + this.getBodyOutputString(data) + "\n");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sbuf.toString();
    }
}

