/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.editors;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.editors.CustomEditor;
import com.sas.preferences.editors.EditorInstanceInterface;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;

public class EditorInstanceImpl
implements EditorInstanceInterface {
    static final long serialVersionUID = 6330199875734177996L;
    private String _loggingContext = this.getClass().getName();
    private UserContextInterface m_userContext;
    private GuiDefDataInterface m_data;
    private CustomEditor m_editor;
    private SASProfileInterface m_sasProfile;

    public void setData(GuiDefDataInterface newData) {
        this.m_data = newData;
    }

    public void setEditor(CustomEditor newEditor) throws RemoteException {
        this.m_editor = newEditor;
        if (this.m_sasProfile != null) {
            this.m_editor.setProfileLocale(this.m_sasProfile);
        }
    }

    @Override
    public String getUserCurrentValue() throws RemoteException {
        String retval = null;
        if (this.m_sasProfile != null) {
            try {
                retval = this.m_sasProfile.getAttributeValue(this.m_data.getPrefKey());
            }
            catch (ServiceException se) {
                throw new RemoteException(se.getMessage(), se);
            }
        }
        return retval;
    }

    public void setProfile(SASProfileInterface newProfile) {
        this.m_sasProfile = newProfile;
        try {
            this.m_userContext = this.m_sasProfile.getUserContext();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        if (this.m_editor != null) {
            try {
                this.m_editor.setProfileLocale(this.m_sasProfile);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void setUserContext(UserContextInterface newUserContext) {
        this.m_userContext = newUserContext;
    }

    @Override
    public String getPrefKey() throws RemoteException {
        return this.m_data.getPrefKey();
    }

    @Override
    public List getValidValues() throws RemoteException {
        return this.m_data.getValidValues();
    }

    @Override
    public boolean isValid() throws RemoteException {
        boolean isValid = false;
        String bodyOutput = this.getBodyOutputString();
        if (bodyOutput != null && bodyOutput.length() > 0) {
            int endOfQuotes;
            while (bodyOutput.toLowerCase().indexOf("name=\"") >= 0 && (endOfQuotes = (bodyOutput = bodyOutput.substring(bodyOutput.toLowerCase().indexOf("name=\"") + 6)).indexOf("\"")) >= 0) {
                String nameOfCtrl = bodyOutput.substring(0, endOfQuotes);
                if (!nameOfCtrl.startsWith(this.m_data.getPrefKey())) {
                    isValid = false;
                    String errorMsg = MessageFormat.format(RB.getStringResource("invalid_preference_body_output.fmt.txt"), this.m_data.getPrefKey(), this.getBodyOutputString());
                    LogManager.getLogger((Class)this.m_userContext.getClass()).warn(errorMsg, (Object)this._loggingContext);
                    break;
                }
                isValid = true;
            }
        }
        return isValid;
    }

    @Override
    public String getDisplayPromptOutputString() throws RemoteException {
        return this.m_editor.getDisplayPromptOutputString(this.m_data);
    }

    @Override
    public String getBodyOutputString() throws RemoteException {
        return this.m_editor.getBodyOutputString(this.m_data);
    }

    @Override
    public String getCategory() throws RemoteException {
        String retVal = null;
        try {
            try {
                retVal = RB.getStringResource(this.m_data.getCategory(), this.m_sasProfile.getLocale());
            }
            catch (MissingResourceException e) {
                try {
                    retVal = RB.getStringResource(this.m_data.getCategory() + ".txt", this.m_sasProfile.getLocale());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (retVal == null) {
                retVal = this.m_data.getCategory();
                String infoMsg = MessageFormat.format(RB.getStringResource("no_localization_for_group.fmt.txt"), retVal);
                LogManager.getLogger((Class)this.m_userContext.getClass()).info(infoMsg, (Object)this._loggingContext);
            }
        }
        catch (ConfigurationPropertiesException configurationPropertiesException) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setAttributes(Map newAttributeMap) throws RemoteException {
        this.m_editor.pullInfoOutOfDisplayAndSetInData(newAttributeMap, this.m_data);
    }

    @Override
    public void persist() throws RemoteException {
        this.m_data.persist(this.m_sasProfile);
    }

    @Override
    public void resetToDefaults() throws RemoteException {
        this.m_data.resetToDefaults(this.m_sasProfile);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Editor info: \n");
        sbuf.append(this.m_editor.toStringGivenData(this.m_data) + "\n");
        sbuf.append("Data info: \n");
        sbuf.append(this.m_data.toString() + "\n");
        return sbuf.toString();
    }
}

