/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences.data;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.data.GuiDefDataInterface;
import com.sas.preferences.data.OMRGuiDefData;
import com.sas.preferences.res.RB;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class LocaleGuiDefData
extends OMRGuiDefData
implements GuiDefDataInterface {
    static final long serialVersionUID = 1678239409524844303L;
    private static final String BROWSER_DEFAULT_STR = "Browser.Default.txt";
    private List m_listOfValidValues = null;
    private Map _map = null;
    private static String[] localeToDisplay = null;
    private static String[] knownLocales = new String[]{"en_US", "en_GB", "da_DK", "de_DE", "de_AT", "de_LU", "de_CH", "es_ES", "es_AR", "es_BO", "es_CL", "es_CO", "es_CR", "es_DO", "es_EC", "es_SV", "es_GT", "es_HN", "es_MX", "es_NI", "es_PA", "es_PY", "es_PE", "es_PR", "es_UY", "es_VE", "fr_FR", "fr_CA", "fr_BE", "fr_LU", "fr_CH", "it_IT", "it_CH", "ja_JP", "ko_KR", "nl_NL", "pl_PL", "ru_RU", "sv_SE", "zh_CN", "zh_TW"};

    @Override
    public void persist(SASProfileInterface sasProfile) throws RemoteException {
        Locale userLocale = Locale.getDefault();
        try {
            userLocale = sasProfile.getLocale();
        }
        catch (ConfigurationPropertiesException configurationPropertiesException) {
            // empty catch block
        }
        boolean foundMatch = false;
        Locale[] listOfAvailLocales = Locale.getAvailableLocales();
        for (int i = 0; i < listOfAvailLocales.length; ++i) {
            Locale availLocale = listOfAvailLocales[i];
            if (!availLocale.equals(userLocale)) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            super.resetToDefaults(sasProfile);
        } else {
            super.persist(sasProfile);
        }
    }

    public static void setDiskSetOfLocales(Object[] info) {
        if (info[0] != null) {
            knownLocales = (String[])info[0];
        }
        if (info[1] != null) {
            localeToDisplay = (String[])info[1];
        }
    }

    @Override
    public List getValidValues() throws RemoteException {
        int i;
        this.m_listOfValidValues = new ArrayList();
        String browserDefault = RB.getStringResource(BROWSER_DEFAULT_STR);
        Locale locale = Locale.getDefault();
        try {
            Locale profileLocale = ((SASProfileInterface)this.m_userContext.getProfile().getProfile("SAS")).getLocale();
            if (profileLocale != null) {
                browserDefault = RB.getStringResource(BROWSER_DEFAULT_STR, profileLocale);
                locale = profileLocale;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this._map = new HashMap();
        ArrayList<String> listToSort = new ArrayList<String>();
        for (i = 0; i < knownLocales.length; ++i) {
            String resourceEntry = knownLocales[i] + ".txt";
            String displayKey = null;
            try {
                displayKey = RB.getStringResource(resourceEntry, locale);
            }
            catch (MissingResourceException me) {
                displayKey = localeToDisplay[i];
            }
            if (displayKey == null) continue;
            this._map.put(displayKey, knownLocales[i]);
            listToSort.add(displayKey);
        }
        Collections.sort(listToSort);
        this.m_listOfValidValues.add(browserDefault);
        for (i = 0; i < listToSort.size(); ++i) {
            String itemToAdd = (String)listToSort.get(i);
            String str = (String)this._map.get(itemToAdd);
            this.m_listOfValidValues.add(str);
        }
        return this.m_listOfValidValues;
    }

    @Override
    public String translateInternalVal(Locale aLocale, String internalVal) throws RemoteException {
        String retval = super.translateInternalVal(aLocale, internalVal);
        if (retval == null || retval.equals(internalVal)) {
            for (String key : this._map.keySet()) {
                String val = (String)this._map.get(key);
                if (!val.equals(internalVal)) continue;
                retval = key;
                break;
            }
        }
        return retval;
    }
}

