/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.ConfigurationPropertiesInterface;
import com.sas.preferences.SASProfileUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SoftwareComponentProperties
implements ConfigurationPropertiesInterface {
    private static final long serialVersionUID = 1L;
    private String m_strSoftwareComponent = null;
    private Properties m_properties = new Properties();
    private static Map m_SoftwareComponentToProperties = new HashMap();
    private static Properties m_conglomerationOfAllPropertiesForPerformance = new Properties();

    protected SoftwareComponentProperties(String strSoftwareComponent, HashMap infoFromOMR) throws ConfigurationPropertiesException {
        this.m_strSoftwareComponent = strSoftwareComponent;
        m_SoftwareComponentToProperties = new HashMap();
        m_conglomerationOfAllPropertiesForPerformance = new Properties();
        for (String aKey : infoFromOMR.keySet()) {
            if (aKey.equals("SAS Application Infrastructure")) continue;
            Properties props = (Properties)infoFromOMR.get(aKey);
            for (Object propKey : props.keySet()) {
                Object propVal = props.get(propKey);
                m_conglomerationOfAllPropertiesForPerformance.put(propKey, propVal);
            }
            m_SoftwareComponentToProperties.put(aKey, props);
        }
        this.m_properties = strSoftwareComponent != null ? (Properties)m_SoftwareComponentToProperties.get(strSoftwareComponent) : m_conglomerationOfAllPropertiesForPerformance;
    }

    @Override
    public Properties getAllAttributes() throws ConfigurationPropertiesException {
        return this.m_properties;
    }

    @Override
    public void setAttributeValue(UserContextInterface userContext, String strKey, String strValue) throws ConfigurationPropertiesException {
        SASProfileUtil.setAttributeValueOnSoftwareComponent(userContext, this.m_strSoftwareComponent, strKey, strValue, this.getAttributeValue(strKey));
        this.m_properties.setProperty(strKey, strValue);
    }

    @Override
    public String getAttributeValue(String strKey) throws ConfigurationPropertiesException {
        String retVal = null;
        if (this.m_properties != null) {
            retVal = (String)this.m_properties.get(strKey);
        }
        return retVal;
    }

    @Override
    public String removeAttributeValue(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        String prevValue = SASProfileUtil.removeAttributeValueOnSoftwareComponent(userContext, "SAS Application Infrastructure", strKey);
        this.m_properties.remove(strKey);
        return prevValue;
    }

    @Override
    public boolean canSetAttribute(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        if (strKey != null) {
            // empty if block
        }
        boolean canWriteToProperties = false;
        if (this.m_strSoftwareComponent != null) {
            try {
                PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(userContext, this.m_strSoftwareComponent);
                canWriteToProperties = SASProfileUtil.canWriteData((MetadataInterface)aPropertySet);
            }
            catch (RemoteException e) {
                throw new ConfigurationPropertiesException(e);
            }
        } else {
            throw new ConfigurationPropertiesException("no_software_component_specified.txt");
        }
        return canWriteToProperties;
    }

    @Override
    public boolean canRemoveAttribute(UserContextInterface userContext, String strKey) throws ConfigurationPropertiesException {
        if (strKey != null) {
            // empty if block
        }
        boolean canRemoveProperties = false;
        if (this.m_strSoftwareComponent != null) {
            try {
                PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(userContext, this.m_strSoftwareComponent);
                canRemoveProperties = SASProfileUtil.canDeleteData((MetadataInterface)aPropertySet);
            }
            catch (RemoteException e) {
                throw new ConfigurationPropertiesException(e);
            }
        } else {
            throw new ConfigurationPropertiesException("no_software_component_specified.txt");
        }
        return canRemoveProperties;
    }

    @Override
    public void clearCache() throws ConfigurationPropertiesException {
        m_SoftwareComponentToProperties = new HashMap();
        if (this.m_strSoftwareComponent == null) {
            m_conglomerationOfAllPropertiesForPerformance = new Properties();
        }
    }
}

