/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.common.util.FullSearchFilter;
import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.SASProfile;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRSoftwareComponent;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webapp.ServicesFacade;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;

public class SASProfileUtil {
    private static final String OMR_READMETADATA_STRING = "ReadMetadata";
    private static final String OMR_WRITEMETADATA_STRING = "WriteMetadata";
    private static final String OMR_DELETE_STRING = "Delete";
    private static String _LoggingContext = SASProfileUtil.class.getName();

    public static SASProfileInterface getProfile(SessionContextInterface aSession) throws ConfigurationPropertiesException {
        try {
            UserContextInterface userContext = aSession.getUserContext();
            return SASProfileUtil.getProfile(userContext);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
    }

    public static SASProfileInterface getProfile(SessionContextInterface aSession, String strApplicationName) throws ConfigurationPropertiesException {
        if (strApplicationName != null) {
            // empty if block
        }
        try {
            UserContextInterface userContext = aSession.getUserContext();
            return SASProfileUtil.getProfile(userContext);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
    }

    public static SASProfileInterface getProfile(UserContextInterface userContext, String strApplicationName) throws ConfigurationPropertiesException {
        if (strApplicationName != null) {
            // empty if block
        }
        return SASProfileUtil.getProfile(userContext);
    }

    public static SASProfileInterface getProfile(UserContextInterface userContext) throws ConfigurationPropertiesException {
        try {
            SASProfileInterface retVal = null;
            try {
                ProfileInterface profile = userContext.getProfile();
                retVal = (SASProfileInterface)profile.getProfile("SAS");
                LogManager.getLogger((Class)userContext.getClass()).info("Successfully loaded SAS profile", (Object)_LoggingContext);
            }
            catch (ServiceException e) {
                LogManager.getLogger((Class)userContext.getClass()).error(e.getMessage(), (Object)_LoggingContext);
                throw new RemoteException(RB.getStringResource("unable_to_load_SASProfile.txt") + " : " + e.getMessage());
            }
            return retVal;
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
    }

    public static SASProfileInterface getProfileWithSC(UserContextInterface userContext, String softwareComponentNameCanBeNull) throws RemoteException, ConfigurationPropertiesException {
        SASProfileInterface sasProfile = SASProfileUtil.getProfile(userContext);
        if (softwareComponentNameCanBeNull == null) {
            sasProfile.setSoftwareComponentNameAsUnspecified();
        } else {
            sasProfile.setSoftwareComponentName(softwareComponentNameCanBeNull);
        }
        return sasProfile;
    }

    public static SASProfileInterface getProfile(UserContextInterface userContext, String strApplicationName, String softwareComponentNameCanBeNull) throws RemoteException, ConfigurationPropertiesException {
        if (strApplicationName != null) {
            // empty if block
        }
        SASProfileInterface sasProfile = SASProfileUtil.getProfile(userContext);
        if (softwareComponentNameCanBeNull == null) {
            sasProfile.setSoftwareComponentNameAsUnspecified();
        } else {
            sasProfile.setSoftwareComponentName(softwareComponentNameCanBeNull);
        }
        return sasProfile;
    }

    public static PropertySetInterface getPropertySetForSoftwareComponent(UserContextInterface userContext, String strSoftwareComponent) throws ConfigurationPropertiesException {
        PropertySetInterface retVal;
        block7: {
            retVal = null;
            try {
                InformationServiceInterface informationService = ServicesFacade.getInformationService();
                Filter myFilter = new Filter();
                myFilter.setType("SoftwareComponent");
                myFilter.setName(strSoftwareComponent);
                myFilter.setOMRFlags(8704);
                ArrayList<String> protocolList = new ArrayList<String>();
                protocolList.add("omi");
                List listOfSoftwareComponents = informationService.searchProtocols(userContext, protocolList, (FilterInterface)myFilter);
                if (strSoftwareComponent != null && strSoftwareComponent.equals("SAS Application Infrastructure")) {
                    String warningMsg;
                    if (listOfSoftwareComponents.size() < 1 && !SASProfile.m_alreadyFlaggedMissingGlobalSW) {
                        warningMsg = MessageFormat.format(RB.getStringResource("no_SWC_looking_for.fmt.txt"), "SAS Application Infrastructure");
                        LogManager.getLogger((Class)userContext.getClass()).warn(warningMsg, (Object)_LoggingContext);
                        SASProfile.m_alreadyFlaggedMissingGlobalSW = true;
                    }
                    if (listOfSoftwareComponents.size() > 1) {
                        warningMsg = MessageFormat.format(RB.getStringResource("more_than_one_SWC.fmt.txt"), "SAS Application Infrastructure");
                        LogManager.getLogger((Class)userContext.getClass()).warn(warningMsg, (Object)_LoggingContext);
                    }
                }
                if (listOfSoftwareComponents.size() <= 0) break block7;
                SoftwareComponentInterface mySoftwareComponent = (SoftwareComponentInterface)listOfSoftwareComponents.get(0);
                List assocList = mySoftwareComponent.getPropertySets();
                ListIterator it = assocList.listIterator();
                while (it.hasNext()) {
                    PropertySetInterface aPropertySet = (PropertySetInterface)it.next();
                    if (!aPropertySet.getName().equals("Application Configuration")) continue;
                    retVal = aPropertySet;
                    break;
                }
            }
            catch (ServiceException e) {
                throw new ConfigurationPropertiesException(e);
            }
            catch (RemoteException e) {
                throw new ConfigurationPropertiesException(e);
            }
        }
        return retVal;
    }

    public static HashMap getPreferenceListFromOMR(UserContextInterface userContext) throws ConfigurationPropertiesException {
        HashMap<String, Properties> retVal = new HashMap<String, Properties>();
        try {
            String searchString = "[@PublicType='Application']";
            String templateString = "<SoftwareComponent>   <PropertySets/></SoftwareComponent><PropertySet>   <SetProperties/>   <Properties/></PropertySet>";
            List propertySetList = FullSearchFilter.doSearchWithFullTemplate(userContext, searchString, templateString, "SoftwareComponent", false, true);
            for (Object obj : propertySetList) {
                if (!(obj instanceof BrowseMetadata) || !((BrowseMetadata)obj).getSmartType().equals("Application")) continue;
                BrowseMetadata thisSW = (BrowseMetadata)obj;
                String nameOfSW = thisSW.getName();
                List propSets = (List)thisSW.get("PropertySets");
                Properties currentPropSet = new Properties();
                if (retVal.containsKey(nameOfSW)) {
                    currentPropSet = (Properties)retVal.get(nameOfSW);
                }
                if (propSets == null) continue;
                for (BrowseMetadata thisProperty : propSets) {
                    List topProps;
                    if (!thisProperty.getName().equals("Application Configuration")) continue;
                    List setProps = (List)thisProperty.get("SetProperties");
                    if (setProps != null) {
                        for (BrowseMetadata aProp : setProps) {
                            String name = aProp.getName();
                            String val = (String)aProp.get("DefaultValue");
                            if (name == null || val == null) continue;
                            currentPropSet.put(name, val);
                        }
                    }
                    if ((topProps = (List)thisProperty.get("Properties")) == null) continue;
                    for (BrowseMetadata aProp : topProps) {
                        String name = aProp.getName();
                        String val = (String)aProp.get("value");
                        currentPropSet.put(name, val);
                    }
                }
                if (nameOfSW == null || nameOfSW.trim().length() <= 0) continue;
                retVal.put(nameOfSW, currentPropSet);
            }
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return retVal;
    }

    public static List getAllSoftwareComponentsDefiningGUIDEF_entries(UserContextInterface userContext, OMRSoftwareComponent globalSWAlreadyRead) throws ConfigurationPropertiesException {
        ArrayList<FolderInterface> retVal = new ArrayList<FolderInterface>();
        try {
            InformationServiceInterface informationService = ServicesFacade.getInformationService();
            Filter myFilter = new Filter();
            myFilter.setType("SoftwareComponent");
            myFilter.setOMRFlags(0x200 | myFilter.getOMRFlags());
            ArrayList<String> protocolList = new ArrayList<String>();
            protocolList.add("omi");
            for (SoftwareComponentInterface mySoftwareComponent : informationService.searchProtocols(userContext, protocolList, (FilterInterface)myFilter)) {
                if (mySoftwareComponent.getReposId().equals(globalSWAlreadyRead.getReposId())) continue;
                for (FolderInterface aTree : mySoftwareComponent.getSoftwareTrees()) {
                    if (!aTree.getName().equals("Preference Categories")) continue;
                    retVal.add(aTree);
                }
            }
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return retVal;
    }

    public static void CreateNecessaryProfile(ProfileInterface profileStartingFrom, String profileName) throws RemoteException {
        SASProfileUtil.createNecessaryProfile(profileStartingFrom, profileName);
    }

    public static void createNecessaryProfile(ProfileInterface profileStartingFrom, String profileName) throws RemoteException {
        ProfileInterface profileCurrentlyOn = profileStartingFrom;
        ProfileInterface profileDownLevel = null;
        try {
            StringTokenizer sToken = new StringTokenizer(profileName, "/");
            while (sToken.hasMoreElements()) {
                String nextProfileName = (String)sToken.nextElement();
                try {
                    profileDownLevel = profileCurrentlyOn.getProfile(nextProfileName);
                }
                catch (ServiceException se) {
                    profileDownLevel = new Profile(nextProfileName);
                    profileCurrentlyOn.createSubprofile(profileDownLevel);
                    profileCurrentlyOn.addProfile(nextProfileName, profileDownLevel, true);
                }
                profileCurrentlyOn = profileDownLevel;
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private static void createNewProperty(PropertySetInterface aPropertySet, UserContextInterface userContext, String newPropertyName, String newPropertyValue) throws ConfigurationPropertiesException {
        if (userContext != null) {
            // empty if block
        }
        try {
            InformationServiceInterface informationService = ServicesFacade.getInformationService();
            PropertyInterface newPropertyInt = (PropertyInterface)informationService.newMetadata(null, newPropertyName, aPropertySet.getRepository(), "Property");
            newPropertyInt.setValue(newPropertyValue);
            newPropertyInt.setDescription(newPropertyName);
            newPropertyInt.setName(newPropertyName);
            newPropertyInt.setKey(newPropertyName);
            List aPropertyList = aPropertySet.getSetProperties();
            aPropertyList.add(newPropertyInt);
            aPropertySet.setObjectProperties(aPropertyList);
            aPropertySet.update();
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
    }

    protected static void setAttributeValueOnSoftwareComponent(UserContextInterface m_userContext, String m_strSoftwareComponent, String strKey, String strValue, String strCurrentValue) throws ConfigurationPropertiesException {
        block8: {
            if (strCurrentValue != null && strCurrentValue.equals(strValue)) {
                return;
            }
            try {
                PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(m_userContext, m_strSoftwareComponent);
                if (aPropertySet == null) {
                    if (m_strSoftwareComponent.equals("SAS Application Infrastructure")) {
                        String msg = "Configuration Error: There is no SoftwareComponent metadata named \"SAS Application Infrastructure\".  Run the \"LoadDefaultPreferences.sas\" SAS job to load this information into metadata.";
                        throw new ConfigurationPropertiesException(msg, 0);
                    }
                    throw new ConfigurationPropertiesException("no_such_software_component.txt");
                }
                List indivProperties = aPropertySet.getSetProperties();
                if (strCurrentValue != null) {
                    ListIterator itIndiv = indivProperties.listIterator();
                    while (itIndiv.hasNext()) {
                        PropertyInterface aProp = (PropertyInterface)itIndiv.next();
                        if (!aProp.getName().equals(strKey)) continue;
                        aProp.setValue(strValue);
                        aProp.update();
                        break block8;
                    }
                    break block8;
                }
                SASProfileUtil.createNewProperty(aPropertySet, m_userContext, strKey, strValue);
            }
            catch (ServiceException e) {
                throw new ConfigurationPropertiesException(e);
            }
            catch (RemoteException e) {
                throw new ConfigurationPropertiesException(e);
            }
        }
    }

    protected static String removeAttributeValueOnSoftwareComponent(UserContextInterface m_userContext, String m_strSoftwareComponent, String strKey) throws ConfigurationPropertiesException {
        String previousValue = null;
        try {
            PropertySetInterface aPropertySet = SASProfileUtil.getPropertySetForSoftwareComponent(m_userContext, m_strSoftwareComponent);
            List indivProperties = aPropertySet.getObjectProperties();
            for (int i = 0; i < indivProperties.size(); ++i) {
                PropertyInterface aProp = (PropertyInterface)indivProperties.get(i);
                if (!aProp.getName().equals(strKey)) continue;
                previousValue = aProp.getValue();
                indivProperties.remove(i);
                break;
            }
            aPropertySet.setSetProperties(indivProperties);
            aPropertySet.update();
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return previousValue;
    }

    public static boolean canReadData(MetadataInterface data) throws RemoteException {
        boolean isAuthorized = false;
        try {
            isAuthorized = data.getRepository() instanceof OMIRepositoryInterface ? data.isAuthorized(OMR_READMETADATA_STRING) : true;
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return isAuthorized;
    }

    public static boolean canWriteData(MetadataInterface data) throws RemoteException {
        boolean isAuthorized = false;
        try {
            isAuthorized = data.getRepository() instanceof OMIRepositoryInterface ? data.isAuthorized(OMR_WRITEMETADATA_STRING) : true;
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return isAuthorized;
    }

    public static boolean canDeleteData(MetadataInterface data) throws RemoteException {
        boolean isAuthorized = false;
        try {
            isAuthorized = data.getRepository() instanceof OMIRepositoryInterface ? data.isAuthorized(OMR_DELETE_STRING) : true;
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return isAuthorized;
    }
}

