/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.common.util.FullSearchFilter;
import com.sas.common.util.MethodTimer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.ConfigurationPropertiesInterface;
import com.sas.preferences.GlobalProperties;
import com.sas.preferences.GuiDefCategory;
import com.sas.preferences.OMRDefinedGUIInterface;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.SASProfileUtil;
import com.sas.preferences.SoftwareComponentProperties;
import com.sas.preferences.editors.EditorInstanceInterface;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRSoftwareComponent;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.PropertySetInterface;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;

public class SASProfile
extends Profile
implements SASProfileInterface {
    private static Map previouslySeenPrefValues = new HashMap();
    private String _logonTheme = null;
    private static final long serialVersionUID = 6136598186667989564L;
    private static List m_listCategories = null;
    private Map m_mapPropertyToProfileName = new HashMap();
    private List m_listNoGuiDefs = new ArrayList();
    private Map m_mapOfPropertyObjects = null;
    private Properties m_propertiesDefault = null;
    private String m_strSoftwareComponentName = null;
    private ConfigurationPropertiesInterface m_propertiesGlobal = null;
    private ConfigurationPropertiesInterface m_propertiesSoftwareComponent = null;
    private String _loggingContext = this.getClass().getName();
    private Locale m_localeClient = null;
    static boolean m_alreadyFlaggedMissingGlobalSW = false;
    private long refreshMS = 300000L;
    private long lastRetrieveTime = 0L;

    public static SASProfileInterface loadProfile(UserContextInterface userContext, String strSoftwareComponent, String strApplicationName) throws ConfigurationPropertiesException, RemoteException {
        if (strApplicationName != null) {
            // empty if block
        }
        SASProfileInterface myProfile = null;
        myProfile = SASProfileUtil.getProfile(userContext);
        myProfile.setSoftwareComponentName(strSoftwareComponent);
        return myProfile;
    }

    @Override
    public void setClientLocale(Locale aLocale) throws ConfigurationPropertiesException, RemoteException {
        String localeStr;
        String cachedKey;
        try {
            SASProfileInterface trueSASProfile = (SASProfileInterface)this.getRootProfile().getProfile("SAS");
            if (this == trueSASProfile) {
                this.m_localeClient = aLocale;
                this.setAttribute("Locale.DefaultLocale", aLocale.toString());
            } else {
                trueSASProfile.setClientLocale(aLocale);
            }
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        if (previouslySeenPrefValues.containsKey("Locale.DefaultLocale") && !(cachedKey = (String)previouslySeenPrefValues.get("Locale.DefaultLocale")).equals(localeStr = aLocale.toString())) {
            previouslySeenPrefValues.put("Locale.DefaultLocale", localeStr);
        }
    }

    public void printCategoriesKnownForWebApp() throws RemoteException, ConfigurationPropertiesException {
        this.printCategoriesKnownForWebApp(this.getCategories());
    }

    private void printCategoriesKnownForWebApp(List guiDefsAndCategories) throws RemoteException, ConfigurationPropertiesException {
        for (Object guiDefOrCategory : guiDefsAndCategories) {
            if (guiDefOrCategory instanceof GuiDefCategory) {
                GuiDefCategory guiDefCat = (GuiDefCategory)guiDefOrCategory;
                List subGuiDefsAndCategories = guiDefCat.getEditorsAndCategories();
                this.printCategoriesKnownForWebApp(subGuiDefsAndCategories);
                continue;
            }
            if (!(guiDefOrCategory instanceof OMRDefinedGUIInterface)) continue;
            OMRDefinedGUIInterface aDataMember = (OMRDefinedGUIInterface)guiDefOrCategory;
            System.out.println(aDataMember.toString());
        }
    }

    public SASProfile(String strApplicationName) throws RemoteException {
        super(strApplicationName);
    }

    @Override
    public synchronized void setDefaultProperties(Properties defaults) throws RemoteException {
        this.m_propertiesDefault = defaults == null ? new Properties() : defaults;
    }

    public void load(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        super.load(root, user, repos, pd);
        String infoMsg = RB.getStringResource("in_load_for_SASProfile.txt");
        LogManager.getLogger((Class)user.getClass()).debug(infoMsg, (Object)this._loggingContext);
        try {
            this.setSoftwareComponentNameAsUnspecified();
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private synchronized void checkRefresh() throws ConfigurationPropertiesException {
        try {
            if (this.getUserContext() != null) {
                long diff = System.currentTimeMillis() - this.lastRetrieveTime - this.refreshMS;
                if (this.lastRetrieveTime <= 0L || diff > 0L || this.m_propertiesGlobal == null || this.m_propertiesSoftwareComponent == null) {
                    HashMap propsFromOMR = SASProfileUtil.getPreferenceListFromOMR(this.getUserContext());
                    if (this.m_propertiesGlobal == null) {
                        this.m_propertiesGlobal = new GlobalProperties((Properties)propsFromOMR.get("SAS Application Infrastructure"));
                    }
                    if (this.m_propertiesSoftwareComponent == null) {
                        this.m_propertiesSoftwareComponent = new SoftwareComponentProperties(this.m_strSoftwareComponentName, propsFromOMR);
                    }
                    if (this.m_propertiesDefault == null) {
                        this.m_propertiesDefault = new Properties();
                    }
                    this.lastRetrieveTime = System.currentTimeMillis();
                }
            }
        }
        catch (RemoteException e) {
            try {
                LogManager.getLogger((Class)this.getUserContext().getClass()).error("Cannot bootstrap internal properties", (Object)this._loggingContext);
            }
            catch (RemoteException e2) {
                System.err.println("Cannot bootstrap internal properties");
            }
            throw new ConfigurationPropertiesException();
        }
    }

    @Override
    public String getAttributeLookThrough(String strKey) throws ConfigurationPropertiesException, RemoteException {
        return this.getAttributeLookThrough(strKey, false);
    }

    private String getAttributeLookThrough(String strKey, boolean bypassRefresh) throws ConfigurationPropertiesException, RemoteException {
        String retVal;
        if (!bypassRefresh) {
            this.checkRefresh();
        }
        if ((retVal = this.getAttributeValueAtPersonLevel(strKey)) == null) {
            if (previouslySeenPrefValues.containsKey(strKey)) {
                retVal = (String)previouslySeenPrefValues.get(strKey);
            } else {
                retVal = this.getAttributeValueAbovePersonLevel(strKey);
                if (retVal != null) {
                    previouslySeenPrefValues.put(strKey, retVal);
                }
            }
        }
        return retVal;
    }

    @Override
    public String getAttributeValueAtPersonLevel(String strKey) throws ConfigurationPropertiesException, RemoteException {
        String retVal = null;
        String profileName = this.getProfileNameForGuiDef(strKey);
        if (profileName != null && (profileName.trim().length() == 0 || profileName.trim().equalsIgnoreCase("global"))) {
            profileName = null;
        }
        SASProfile profileToAsk = this;
        if (this.m_propertiesGlobal == null && (this.m_propertiesDefault == null || this.m_propertiesDefault.size() == 0)) {
            this.setSoftwareComponentNameAsUnspecified();
        }
        try {
            if (profileName != null && this.getParentProfile() != null) {
                profileToAsk = this.getRootProfile();
            }
            retVal = profileToAsk.getAttribute(profileName, strKey);
        }
        catch (ServiceException e) {
            SASProfileUtil.createNecessaryProfile(profileToAsk, profileName);
        }
        return retVal;
    }

    private String getValueAtTrueSASProfile(String aKey) throws ConfigurationPropertiesException, RemoteException {
        String retVal = null;
        if (aKey.equals("Locale.DefaultLocale")) {
            try {
                SASProfileInterface trueSASProfile = (SASProfileInterface)this.getRootProfile().getProfile("SAS");
                if (this == trueSASProfile) {
                    if (this.m_localeClient != null) {
                        retVal = this.m_localeClient.toString();
                    }
                } else {
                    Locale internalLocale = ((SASProfile)trueSASProfile).getClientLocale();
                    if (internalLocale != null) {
                        retVal = internalLocale.toString();
                    }
                }
            }
            catch (ServiceException e) {
                throw new ConfigurationPropertiesException(e);
            }
        }
        return retVal;
    }

    @Override
    public String getAttributeValueAbovePersonLevel(String strKey) throws ConfigurationPropertiesException, RemoteException {
        this.checkRefresh();
        String retVal = null;
        if (this.m_propertiesDefault != null && this.m_propertiesDefault.size() > 0) {
            retVal = strKey.equals("Locale.DefaultLocale") ? this.getValueAtTrueSASProfile(strKey) : this.m_propertiesDefault.getProperty(strKey);
        } else {
            if (this.m_propertiesGlobal == null) {
                this.setSoftwareComponentNameAsUnspecified();
            }
            if (this.m_propertiesSoftwareComponent != null) {
                retVal = this.m_propertiesSoftwareComponent.getAttributeValue(strKey);
            }
            if (retVal == null) {
                if (strKey.equals("Locale.DefaultLocale")) {
                    retVal = this.getValueAtTrueSASProfile(strKey);
                }
                if (retVal == null && this.m_propertiesGlobal != null) {
                    retVal = this.m_propertiesGlobal.getAttributeValue(strKey);
                }
            }
        }
        return retVal;
    }

    @Override
    public ConfigurationPropertiesInterface getPropertiesAtScope(int nScope) throws RemoteException, ConfigurationPropertiesException {
        this.checkRefresh();
        switch (nScope) {
            case 0: {
                return this.m_propertiesGlobal;
            }
            case 1: {
                return this.m_propertiesSoftwareComponent;
            }
        }
        return null;
    }

    private String getThemesOverriddenForUser() {
        String retval;
        block5: {
            retval = null;
            try {
                Iterator itTop = this.getUser().getPropertySets().iterator();
                if (!itTop.hasNext()) break block5;
                PropertySetInterface globalPropSet = (PropertySetInterface)itTop.next();
                block2: for (PropertySetInterface sasPropSet : globalPropSet.getPropertySets()) {
                    if (!sasPropSet.getName().equals("Profile/SAS")) continue;
                    List setProps = sasPropSet.getSetProperties();
                    if (setProps != null) {
                        for (PropertyInterface aProp : setProps) {
                            if (!aProp.getName().equals("Default.Theme")) continue;
                            retval = aProp.getValue();
                            continue block2;
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    @Override
    public String getTheme() throws ConfigurationPropertiesException, RemoteException {
        String retval = null;
        if (this._logonTheme != null) {
            return this._logonTheme;
        }
        retval = this.getThemesOverriddenForUser();
        if (retval == null) {
            if (previouslySeenPrefValues.containsKey("Default.Theme")) {
                retval = (String)previouslySeenPrefValues.get("Default.Theme");
            } else {
                retval = this.getAttributeValueAbovePersonLevel("Default.Theme");
                if (retval != null) {
                    previouslySeenPrefValues.put("Default.Theme", retval);
                }
            }
        }
        this._logonTheme = retval;
        return retval;
    }

    @Override
    public Locale getLocale() throws ConfigurationPropertiesException, RemoteException {
        Locale retVal = Locale.getDefault();
        String strLocale = this.getAttributeLookThrough("Locale.DefaultLocale");
        if (strLocale != null) {
            int nDash = strLocale.indexOf("_");
            if (nDash > 0) {
                String strLang = strLocale.substring(0, nDash);
                String strCountry = strLocale.substring(nDash + 1);
                retVal = new Locale(strLang, strCountry);
            } else {
                retVal = new Locale(strLocale);
            }
        }
        return retVal;
    }

    @Override
    public String getSoftwareComponentName() {
        return this.m_strSoftwareComponentName;
    }

    @Override
    public void setSoftwareComponentName(String newSoftwareComponentName) throws ConfigurationPropertiesException, RemoteException {
        String infoMsg = MessageFormat.format(RB.getStringResource("set_software_component_name_as_follows.fmt.txt"), newSoftwareComponentName);
        LogManager.getLogger((Class)this.getUserContext().getClass()).debug(infoMsg, (Object)this._loggingContext);
        this.m_propertiesSoftwareComponent = null;
        this.m_strSoftwareComponentName = newSoftwareComponentName;
    }

    @Override
    public void setSoftwareComponentNameAsUnspecified() throws ConfigurationPropertiesException, RemoteException {
        String infoMsg = RB.getStringResource("set_software_component_name_as_unspecified.txt");
        if (this.getUserContext() != null && LogManager.getLogger((Class)this.getUserContext().getClass()) != null) {
            LogManager.getLogger((Class)this.getUserContext().getClass()).debug(infoMsg, (Object)this._loggingContext);
        }
        this.m_strSoftwareComponentName = null;
    }

    private static void clearCategories() throws RemoteException {
        m_listCategories = new ArrayList();
    }

    private String getProfileNameForGuiDef(String nameOfProperty) throws RemoteException {
        if (this.m_listNoGuiDefs.contains(nameOfProperty)) {
            return null;
        }
        if (this.m_mapPropertyToProfileName.containsKey(nameOfProperty)) {
            return (String)this.m_mapPropertyToProfileName.get(nameOfProperty);
        }
        String retVal = null;
        String methodName = "getProfileNameForGuiDef";
        String extraInfo = "[" + nameOfProperty + ":" + this.getUserName() + "]";
        MethodTimer aTimer = MethodTimer.startTimer(methodName, this.getUserContext(), extraInfo);
        StringBuffer sbuf = new StringBuffer().append("[@Name='ProfileName'][AssociatedObject/Prototype[@Name?' GUIDEF']]");
        String templateString = "<Property><AssociatedObject/></Property>";
        List propertyGroupList = FullSearchFilter.doSearchWithFullTemplate(this.getUserContext(), sbuf.toString(), templateString, "Property", true);
        boolean gotCheckForOMRUpdates = false;
        if (propertyGroupList.size() == 0) {
            this.m_listNoGuiDefs.add(nameOfProperty);
        } else {
            for (PropertyInterface aProperty : propertyGroupList) {
                try {
                    MetadataInterface assocObj = aProperty.getAssociatedObject();
                    String nameOfProp = assocObj.getName();
                    if (nameOfProp.endsWith(" GUIDEF")) {
                        nameOfProp = nameOfProp.substring(0, nameOfProp.indexOf(" GUIDEF"));
                    }
                    if (nameOfProp.equals("Default.CheckForOMRUpdates")) {
                        gotCheckForOMRUpdates = true;
                    }
                    String valOfProp = aProperty.getValue();
                    this.m_mapPropertyToProfileName.put(nameOfProp, valOfProp);
                }
                catch (ServiceException se) {
                    LogManager.getLogger((Class)this.getUserContext().getClass()).debug(se.getMessage(), (Object)this._loggingContext);
                }
            }
        }
        if (!gotCheckForOMRUpdates) {
            this.m_listNoGuiDefs.add("Default.CheckForOMRUpdates");
        }
        aTimer.stopTimer();
        return retVal;
    }

    @Override
    public String getCategoriesAsXML() throws RemoteException {
        StringBuffer sbuf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        try {
            sbuf.append("<Preferences>\n");
            for (GuiDefCategory topCat : this.getCategories()) {
                String handledCat = this.handleCategory(topCat);
                sbuf.append(handledCat + "\n");
            }
            sbuf.append("</Preferences>\n");
        }
        catch (ConfigurationPropertiesException cpe) {
            cpe.printStackTrace();
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        return sbuf.toString();
    }

    private String handleCategory(GuiDefCategory aCat) throws RemoteException {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("\t<Category name=\"" + aCat.getCategoryName() + "\">\n");
        for (Object obj : aCat.getEditorsAndCategories()) {
            if (obj instanceof EditorInstanceInterface) {
                EditorInstanceInterface editor = (EditorInstanceInterface)obj;
                sbuf.append("\t\t<editor key=\"" + editor.getPrefKey() + "\" label=\"" + editor.getDisplayPromptOutputString() + "\" userChoice=\"" + editor.getUserCurrentValue() + "\" >\n");
                for (String aVal : editor.getValidValues()) {
                    sbuf.append("\t\t\t<ValidValue name=\"" + aVal + "\" />\n");
                }
                sbuf.append("\t\t</editor>\n");
                continue;
            }
            if (!(obj instanceof GuiDefCategory)) continue;
            String innerVal = this.handleCategory((GuiDefCategory)obj);
            sbuf.append(innerVal + "\n");
        }
        sbuf.append("\t</Category>\n");
        return sbuf.toString();
    }

    @Override
    public synchronized List getCategories() throws ConfigurationPropertiesException, RemoteException {
        SASProfile.clearCategories();
        try {
            String warningMsg;
            RepositoryInterface foundationRepository = this.getUserContext().getPerson().getRepository();
            Filter myFilter = new Filter();
            myFilter.setType("SoftwareComponent");
            myFilter.setName("SAS Application Infrastructure");
            myFilter.setOMRFlags(0x200 | myFilter.getOMRFlags());
            List listToReturn = foundationRepository.search((FilterInterface)myFilter);
            if (listToReturn.size() > 1) {
                warningMsg = MessageFormat.format(RB.getStringResource("more_than_one_SWC.fmt.txt"), "SAS Application Infrastructure");
                LogManager.getLogger((Class)this.getUserContext().getClass()).warn(warningMsg, (Object)this._loggingContext);
            }
            if (listToReturn.size() < 1 && !m_alreadyFlaggedMissingGlobalSW) {
                warningMsg = MessageFormat.format(RB.getStringResource("no_SWC_looking_for.fmt.txt"), "SAS Application Infrastructure");
                LogManager.getLogger((Class)this.getUserContext().getClass()).warn(warningMsg, (Object)this._loggingContext);
                m_alreadyFlaggedMissingGlobalSW = true;
            }
            OMRSoftwareComponent swComponentToUse = null;
            if (listToReturn.size() >= 1) {
                swComponentToUse = (OMRSoftwareComponent)listToReturn.get(0);
                List aList = swComponentToUse.getSoftwareTrees();
                for (FolderInterface aTopMostTree : aList) {
                    if (!aTopMostTree.getName().equals("Preference Categories")) continue;
                    List itemList = aTopMostTree.getItems();
                    for (GroupInterface aMember : itemList) {
                        if (!aMember.getName().equalsIgnoreCase("OrderingGroup")) continue;
                        List memberList = aMember.getMembers();
                        for (FolderInterface aRealMember : memberList) {
                            GuiDefCategory newCategory = new GuiDefCategory(aRealMember, this);
                            m_listCategories.add(newCategory);
                        }
                    }
                }
            }
            Iterator itOtherGroups = SASProfileUtil.getAllSoftwareComponentsDefiningGUIDEF_entries(this.getUserContext(), swComponentToUse).iterator();
            while (itOtherGroups.hasNext()) {
                this.insertGroupIntoMainGroup(m_listCategories, (FolderInterface)itOtherGroups.next());
            }
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        return m_listCategories;
    }

    private void insertGroupIntoMainGroup(List alreadyAddedGUIDefCategories, FolderInterface newTree) throws RemoteException, ServiceException {
        for (Object obj : newTree.getItems()) {
            MetadataInterface aNewMemberWrapper = (MetadataInterface)obj;
            if (!(aNewMemberWrapper instanceof GroupInterface) || !aNewMemberWrapper.getName().equals("OrderingGroup")) continue;
            Iterator itNewMembers = ((GroupInterface)aNewMemberWrapper).getMembers().iterator();
            try {
                while (itNewMembers.hasNext()) {
                    Object obj2 = itNewMembers.next();
                    MetadataInterface aNewMember = (MetadataInterface)obj2;
                    if (!(aNewMember instanceof FolderInterface)) continue;
                    FolderInterface topLevelCategorySmart = (FolderInterface)aNewMember;
                    GuiDefCategory newCategory = new GuiDefCategory(topLevelCategorySmart, this);
                    boolean addedToExistingGroup = false;
                    for (int i = 0; i < alreadyAddedGUIDefCategories.size(); ++i) {
                        if (!(alreadyAddedGUIDefCategories.get(i) instanceof GuiDefCategory)) continue;
                        GuiDefCategory existingCat = (GuiDefCategory)alreadyAddedGUIDefCategories.get(i);
                        if (!topLevelCategorySmart.getName().equals(existingCat.getCategoryNameNotLocalized())) continue;
                        LogManager.getLogger((Class)this.getUserContext().getClass()).info("Need to add contents of group to existing group at the end", (Object)this._loggingContext);
                        this.merge(existingCat, newCategory);
                        addedToExistingGroup = true;
                        break;
                    }
                    if (addedToExistingGroup) continue;
                    m_listCategories.add(newCategory);
                    LogManager.getLogger((Class)this.getUserContext().getClass()).info(newCategory.toString(), (Object)this._loggingContext);
                }
            }
            catch (ConfigurationPropertiesException e) {
                LogManager.getLogger((Class)this.getUserContext().getClass()).warn(e.getMessage(), (Object)this._loggingContext);
            }
        }
    }

    private void merge(GuiDefCategory existingCategory, GuiDefCategory newlyCreatedCategory) throws RemoteException {
        List existingList = existingCategory.getEditorsAndCategories();
        List newList = newlyCreatedCategory.getEditorsAndCategories();
        int existingListSize = existingList.size();
        boolean needToAdd = true;
        for (int i = 0; i < newList.size(); ++i) {
            Object aNewItem = newList.get(i);
            for (int j = 0; j < existingListSize; ++j) {
                Object anOldItem = existingList.get(j);
                if (aNewItem instanceof GuiDefCategory && anOldItem instanceof GuiDefCategory) {
                    GuiDefCategory newCategory = (GuiDefCategory)aNewItem;
                    GuiDefCategory oldCategory = (GuiDefCategory)anOldItem;
                    LogManager.getLogger((Class)this.getUserContext().getClass()).info("Have two GuiDefCategory items", (Object)this._loggingContext);
                    if (!newCategory.getCategoryNameNotLocalized().equals(oldCategory.getCategoryNameNotLocalized())) continue;
                    this.merge(oldCategory, newCategory);
                    needToAdd = false;
                    continue;
                }
                if (!(aNewItem instanceof EditorInstanceInterface) || !(anOldItem instanceof EditorInstanceInterface)) continue;
                EditorInstanceInterface newEditor = (EditorInstanceInterface)aNewItem;
                EditorInstanceInterface oldEditor = (EditorInstanceInterface)anOldItem;
                LogManager.getLogger((Class)this.getUserContext().getClass()).info("Have custom editor item", (Object)this._loggingContext);
                if (!newEditor.getPrefKey().equals(oldEditor.getPrefKey())) continue;
                String warnMsg = MessageFormat.format(RB.getStringResource("duplicate_preference_in_omr_not_loaded.fmt.txt"), oldEditor.getPrefKey());
                LogManager.getLogger((Class)this.getUserContext().getClass()).warn(warnMsg, (Object)this._loggingContext);
                needToAdd = false;
                break;
            }
            if (needToAdd) {
                if (aNewItem instanceof GuiDefCategory) {
                    existingCategory.add((GuiDefCategory)aNewItem);
                } else if (aNewItem instanceof EditorInstanceInterface) {
                    existingCategory.add((EditorInstanceInterface)aNewItem);
                }
            }
            needToAdd = true;
        }
    }

    @Override
    public List getCategoryNamesTopLevel() throws ConfigurationPropertiesException, RemoteException {
        ArrayList<String> listNames = new ArrayList<String>();
        for (GuiDefCategory topLevelCategory : this.getCategories()) {
            listNames.add(topLevelCategory.getCategoryName());
        }
        return listNames;
    }

    @Override
    public void removeAttributeValue(String strKey) throws RemoteException, ServiceException {
        String profileName = this.getProfileNameForGuiDef(strKey);
        SASProfile profileToUse = this;
        if (profileName != null && this.getParentProfile() != null) {
            profileToUse = this.getRootProfile();
        }
        if (profileName != null && (profileName.trim().length() == 0 || profileName.trim().equalsIgnoreCase("global"))) {
            profileName = null;
        }
        profileToUse.setAttribute(profileName, strKey, null);
        profileToUse.persist(null, true);
    }

    @Override
    public void removeAttributeValueGlobal(String strKey) throws RemoteException {
        try {
            if (this.m_propertiesGlobal == null) {
                this.checkRefresh();
            }
            if (this.m_propertiesGlobal != null) {
                this.m_propertiesGlobal.removeAttributeValue(this.getUserContext(), strKey);
            }
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAttributeValueGlobal(String strKey, String newValue) throws RemoteException {
        try {
            if (this.m_propertiesGlobal == null) {
                this.checkRefresh();
            }
            if (this.m_propertiesGlobal != null) {
                if (newValue == null) {
                    this.m_propertiesGlobal.removeAttributeValue(this.getUserContext(), strKey);
                } else {
                    this.m_propertiesGlobal.setAttributeValue(this.getUserContext(), strKey, newValue);
                }
            }
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void setAttributeValueGlobal(String strKey, String strValue) throws RemoteException {
        try {
            if (this.m_propertiesGlobal == null) {
                this.checkRefresh();
            }
            if (this.m_propertiesGlobal != null) {
                if (strValue == null) {
                    this.m_propertiesGlobal.removeAttributeValue(this.getUserContext(), strKey);
                } else {
                    this.m_propertiesGlobal.setAttributeValue(this.getUserContext(), strKey, strValue);
                }
            }
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public String getAttributeValue(String strKey) throws RemoteException, ServiceException {
        String retVal = null;
        try {
            retVal = this.getAttributeLookThrough(strKey);
        }
        catch (ConfigurationPropertiesException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return retVal;
    }

    @Override
    public MetadataInterface getAttributeObject(String strKey) throws RemoteException {
        try {
            if (this.m_mapOfPropertyObjects == null) {
                this.m_mapOfPropertyObjects = new HashMap();
                List assocList = this.getListOfProperties();
                if (assocList != null) {
                    for (PropertyInterface aProp : assocList) {
                        MetadataInterface assocObj = aProp.getAssociatedObject();
                        if (assocObj == null) continue;
                        this.m_mapOfPropertyObjects.put(aProp.getName(), assocObj);
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return (MetadataInterface)this.m_mapOfPropertyObjects.get(strKey);
    }

    protected List getListOfProperties() throws RemoteException {
        PersonInterface thisPerson = this.getUser();
        List retVal = null;
        String searchString = "@Id='" + thisPerson.getReposId() + "'";
        String templateString = "   <Person><PropertySets /></Person><PropertySet><SetProperties /><PropertySets /></PropertySet><Property><AssociatedObject /></Property>";
        List myPersonObjectInList = FullSearchFilter.doSearchWithFullTemplate(this.getUserContext(), searchString, templateString, "Person", true);
        if (myPersonObjectInList.size() > 0) {
            retVal = this.getListOfProperties(myPersonObjectInList);
        }
        return retVal;
    }

    protected List getListOfProperties(List startingFromPerson) throws RemoteException {
        List retVal = null;
        try {
            PersonInterface aPerson;
            List propList;
            PropertySetInterface foundPropSet;
            String fullPath = this.getPathFromRoot();
            if (fullPath == null || fullPath.length() == 0) {
                fullPath = "global";
            }
            if ((foundPropSet = this.findPropertySet(fullPath, propList = (aPerson = (PersonInterface)startingFromPerson.get(0)).getPropertySets())) != null) {
                retVal = foundPropSet.getSetProperties();
            } else {
                PropertySetInterface globalPropSet = this.getPropertySetInFullPath("global", propList);
                if (globalPropSet != null && (foundPropSet = this.findPropertySet(fullPath, propList = globalPropSet.getPropertySets())) != null) {
                    retVal = foundPropSet.getSetProperties();
                }
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return retVal;
    }

    protected List getListOfProperties(PersonInterface aPerson) throws RemoteException {
        List retVal = null;
        try {
            List propList;
            PropertySetInterface foundPropSet;
            String fullPath = this.getPathFromRoot();
            if (fullPath == null || fullPath.length() == 0) {
                fullPath = "global";
            }
            if ((foundPropSet = this.findPropertySet(fullPath, propList = aPerson.getPropertySets())) != null) {
                retVal = foundPropSet.getSetProperties();
            } else {
                PropertySetInterface globalPropSet = this.getPropertySetInFullPath("global", propList);
                if (globalPropSet != null && (foundPropSet = this.findPropertySet(fullPath, propList = globalPropSet.getPropertySets())) != null) {
                    retVal = foundPropSet.getSetProperties();
                }
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return retVal;
    }

    private PropertySetInterface getPropertySetInFullPath(String role, List propertySetList) throws RemoteException, ServiceException {
        PropertySetInterface foundPropSet = null;
        String propertySetName = "Profile/" + role;
        Iterator it = propertySetList.iterator();
        while (it.hasNext()) {
            PropertySetInterface aPropSet = null;
            Object anObj = it.next();
            if (anObj instanceof PropertySetInterface) {
                aPropSet = (PropertySetInterface)anObj;
            }
            if (aPropSet == null || !aPropSet.getSetRole().equals(role) && !aPropSet.getSetRole().equals(propertySetName)) continue;
            foundPropSet = aPropSet;
            break;
        }
        return foundPropSet;
    }

    private PropertySetInterface findPropertySet(String fullPath, List startingPropertySetList) throws RemoteException, ServiceException {
        String token;
        PropertySetInterface foundPropSet = null;
        StringTokenizer tok = new StringTokenizer(fullPath, "/");
        foundPropSet = null;
        while (tok.hasMoreTokens() && (foundPropSet = this.getPropertySetInFullPath(token = tok.nextToken(), startingPropertySetList)) != null) {
            startingPropertySetList = foundPropSet.getPropertySets();
        }
        return foundPropSet;
    }

    @Override
    public void setAttributeObject(String strKey, MetadataInterface newObj) throws RemoteException {
        if (strKey == null) {
            System.out.println("Not setting - key is null");
            return;
        }
        if (newObj == null) {
            System.out.println("Not setting - newObj is null");
            return;
        }
        this.setAttributeValue(strKey, "Object_Value");
        List assocList = this.getListOfProperties();
        if (assocList != null) {
            for (Object aProp : assocList) {
                String propName;
                if (!(aProp instanceof PropertyInterface) || !(propName = ((PropertyInterface)aProp).getName()).equals(strKey)) continue;
                try {
                    Root thisGroup = (Root)newObj.getRepositoryEntity();
                    try {
                        AssociationList innerAssocList = thisGroup.getProperties();
                        innerAssocList.add(((PropertyInterface)aProp).getRepositoryEntity());
                        thisGroup.updateMetadataAll();
                    }
                    catch (MdException mde) {
                        mde.printStackTrace();
                    }
                    if (this.m_mapOfPropertyObjects != null) {
                        this.m_mapOfPropertyObjects.put(strKey, newObj);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RemoteException(e.getMessage(), e);
                }
            }
        } else {
            throw new RemoteException("The SetProperties association was not found - it should have been created on the earlier \"set\" or \"loadProfile\"");
        }
    }

    @Override
    public MetadataInterface removeAttributeObject(String strKey) throws RemoteException {
        try {
            this.removeAttributeValue(strKey);
            MetadataInterface retVal = null;
            if (this.m_mapOfPropertyObjects != null) {
                retVal = (MetadataInterface)this.m_mapOfPropertyObjects.remove(strKey);
            }
            return retVal;
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void setAttributeValue(String strKey, String strValue) throws RemoteException {
        String profileName = this.getProfileNameForGuiDef(strKey);
        SASProfile profileToUse = this;
        try {
            String existingVal;
            if (profileName != null && this.getParentProfile() != null) {
                profileToUse = this.getRootProfile();
            }
            if (profileName != null && (profileName.trim().length() == 0 || profileName.trim().equalsIgnoreCase("global"))) {
                profileName = null;
            }
            if ((existingVal = profileToUse.getAttribute(profileName, strKey)) != null) {
                profileToUse.setAttribute(profileName, strKey, strValue);
            } else {
                profileToUse.addAttribute(profileName, strKey, strValue);
            }
            profileToUse.persist(null, true);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void setRefreshCycle(long numMS) throws RemoteException {
        if (numMS > 0L && numMS < 10000L) {
            LogManager.getLogger((Class)this.getUserContext().getClass()).warn("Cannot set refresh cycle for less than every 10 seconds - was requested for [" + numMS + "]", (Object)this._loggingContext);
            numMS = 300000L;
        }
        this.refreshMS = numMS;
    }

    @Override
    public PersonInterface getUser() throws RemoteException {
        PersonInterface retVal = null;
        if (this.getUserContext() != null) {
            retVal = (PersonInterface)this.getUserContext().getPerson();
        }
        return retVal;
    }

    @Override
    public RepositoryInterface getRepository() throws RemoteException {
        RepositoryInterface retVal = null;
        if (this.getUserContext() != null) {
            PersonInterface aPerson = (PersonInterface)this.getUserContext().getPerson();
            retVal = aPerson.getRepository();
        }
        return retVal;
    }

    @Override
    public String getReposId() throws RemoteException {
        String retVal = null;
        if (this.getUserContext() != null) {
            PersonInterface aPerson = (PersonInterface)this.getUserContext().getPerson();
            retVal = aPerson.getReposId();
        }
        return retVal;
    }

    public String getUserName() throws RemoteException {
        PersonInterface aPerson = null;
        String retVal = null;
        if (this.getUserContext() != null) {
            aPerson = (PersonInterface)this.getUserContext().getPerson();
        }
        if (aPerson != null) {
            retVal = aPerson.getName();
        }
        return retVal;
    }

    public void destroy() throws RemoteException {
        super.destroy();
        SASProfile.clearCategories();
        this.m_propertiesGlobal = null;
        this.m_propertiesSoftwareComponent = null;
    }

    @Override
    public Locale getClientLocale() throws RemoteException {
        return this.m_localeClient;
    }
}

