/*
 * Decompiled with CFR 0.152.
 */
package com.sas.preferences;

import com.sas.preferences.ConfigurationPropertiesException;
import com.sas.preferences.GuiDefCategoryInterface;
import com.sas.preferences.SASProfileInterface;
import com.sas.preferences.editors.EditorInstanceInterface;
import com.sas.preferences.editors.GUICreatorFactory;
import com.sas.preferences.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.GroupInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PrototypeInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.logging.log4j.LogManager;

public class GuiDefCategory
implements GuiDefCategoryInterface {
    private String m_strCategoryName = null;
    private String _loggingContext = this.getClass().getName();
    private List m_listEditorsAndCategories = new ArrayList();
    private Map m_mapEditorInstances = new HashMap();
    private Locale m_profileLocale = null;
    private UserContextInterface m_userContext = null;
    static final long serialVersionUID = -2700460458645454841L;

    public GuiDefCategory(FolderInterface categoryGroupSmartObj, SASProfileInterface sasProfile) throws ConfigurationPropertiesException {
        try {
            if (sasProfile != null) {
                this.m_profileLocale = sasProfile.getLocale();
            }
            this.m_strCategoryName = categoryGroupSmartObj.getName();
            this.m_userContext = categoryGroupSmartObj.getRepository().getUserContext();
            for (MetadataInterface aMemberCheck : categoryGroupSmartObj.getItems()) {
                if (!(aMemberCheck instanceof GroupInterface) || !aMemberCheck.getName().equals("OrderingGroup")) continue;
                for (Object obj3 : ((GroupInterface)aMemberCheck).getMembers()) {
                    if (obj3 instanceof PrototypeInterface) {
                        PrototypeInterface aMember = (PrototypeInterface)obj3;
                        EditorInstanceInterface appropriateGUI = GUICreatorFactory.GetAppropriateGUI(aMember, this.m_userContext, sasProfile);
                        this.add(appropriateGUI);
                        continue;
                    }
                    if (!(obj3 instanceof FolderInterface)) continue;
                    GuiDefCategory newSubCategory = new GuiDefCategory((FolderInterface)obj3, sasProfile);
                    this.add(newSubCategory);
                }
            }
        }
        catch (ServiceException e) {
            throw new ConfigurationPropertiesException(e);
        }
        catch (RemoteException e) {
            throw new ConfigurationPropertiesException(e);
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("------------- START ---------- Category Name: " + this.m_strCategoryName + "\n");
        for (Object obj : this.getEditorsAndCategories()) {
            sbuf.append(obj.toString() + "\n");
        }
        sbuf.append("------------- END ---------- Category Name: " + this.m_strCategoryName + "\n");
        return sbuf.toString();
    }

    public void setCategoryName(String newCategoryName) {
        this.m_strCategoryName = newCategoryName;
    }

    public String getCategoryNameNotLocalized() {
        return this.m_strCategoryName;
    }

    public String getCategoryName() {
        String valToShow = null;
        if (this.m_profileLocale != null) {
            Locale profileLocale = this.m_profileLocale;
            try {
                valToShow = RB.getStringResource(this.m_strCategoryName, profileLocale);
            }
            catch (MissingResourceException e) {
                try {
                    valToShow = RB.getStringResource(this.m_strCategoryName + ".txt", profileLocale);
                }
                catch (MissingResourceException e2) {
                    String errorMsg = MessageFormat.format(RB.getStringResource("no_resources_for_translating_internal_value.fmt.txt"), this.m_strCategoryName);
                    System.err.println(errorMsg);
                }
            }
        }
        if (valToShow != null) {
            return valToShow;
        }
        String infoMsg = MessageFormat.format(RB.getStringResource("no_localization_for_group.fmt.txt"), this.m_strCategoryName);
        LogManager.getLogger((Class)this.m_userContext.getClass()).info(infoMsg, (Object)this._loggingContext);
        return this.m_strCategoryName;
    }

    @Override
    public List getEditorsAndCategories() {
        return this.m_listEditorsAndCategories;
    }

    public void add(EditorInstanceInterface guiDef) throws RemoteException {
        this.m_listEditorsAndCategories.add(guiDef);
        this.m_mapEditorInstances.put(guiDef.getPrefKey(), guiDef);
    }

    public void add(GuiDefCategory category) {
        this.m_listEditorsAndCategories.add(category);
    }
}

