/*
 * Decompiled with CFR 0.152.
 */
package com.sas.common.util;

import com.sas.common.util.res.RB;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class ThemesRegistryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _componentName;
    private String _communicationProtocol = "http";
    private String _hostName;
    private String _externalHostName;
    private String _service;
    private String _externalService;
    private String _subnetToUse;
    private int _port = -1;
    private int _externalPort = -1;

    public String getCommunicationProtocol() {
        return this._communicationProtocol;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getExternalHostName() {
        return this._externalHostName;
    }

    public int getPort() {
        return this._port;
    }

    public int getExternalPort() {
        return this._externalPort;
    }

    public String getService() {
        return this._service;
    }

    public String getExternalService() {
        return this._externalService;
    }

    public void setCommunicationProtocol(String string) {
        this._communicationProtocol = string;
    }

    public void setComponentName(String string) {
        this._componentName = string;
    }

    public void setHostName(String string) {
        this._hostName = string;
    }

    public void setExternalHostName(String string) {
        this._externalHostName = string;
    }

    public void setPort(int i) {
        this._port = i;
    }

    public void setExternalPort(int i) {
        this._externalPort = i;
    }

    public void setService(String string) {
        this._service = string;
    }

    public void setExternalService(String string) {
        this._externalService = string;
    }

    public String getHostIPAddress() {
        String ip = null;
        if (this.getHostName() != null && !"".equals(this.getHostName())) {
            try {
                InetAddress address = null;
                address = "LOCALHOST".equalsIgnoreCase(this.getHostName()) ? InetAddress.getLocalHost() : InetAddress.getByName(this.getHostName());
                ip = address.getHostAddress();
            }
            catch (UnknownHostException e) {
                System.out.println("Unknown host for " + this.getHostName());
            }
        }
        return ip;
    }

    public String getURI() {
        if (this._service == null || this._service.length() == 0) {
            return null;
        }
        return this.buildURI(this._communicationProtocol, this._hostName, this._port, this._service);
    }

    public String getExternalURI() {
        if (this._externalService == null || this._externalHostName == null || this._externalPort == -1) {
            return this.getURI();
        }
        return this.buildURI(this._communicationProtocol, this._externalHostName, this._externalPort, this._externalService);
    }

    public String getSubnetToUse() {
        return this._subnetToUse;
    }

    public void setSubnetToUse(String string) {
        this._subnetToUse = string;
    }

    private String buildURI(String protocol, String host, int port, String service) {
        StringBuffer uri = new StringBuffer();
        if (host != null && !"".equals(host)) {
            uri.append(protocol).append("://");
            uri.append(host);
            int newPort = -1;
            if (port < 1) {
                newPort = 80;
                System.err.println(RB.getStringResource("ThemesRegistryInfo.geturl.warn.txt"));
            } else {
                newPort = port;
            }
            uri.append(":").append(newPort);
        }
        if (!service.startsWith("/")) {
            uri.append("/");
        }
        uri.append(service);
        return uri.toString();
    }
}

