/*
 * Decompiled with CFR 0.152.
 */
package com.sas.common.util;

import com.sas.preferences.SASProfileInterface;
import com.sas.services.user.UserContextInterface;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.rmi.RemoteException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MethodTimer {
    private final String _loggingContext = this.getClass().getName();
    private long lStartTime = 0L;
    private long lStopTime = 0L;
    private String strMethodName = "";
    private String fullMsg = "";
    private UserContextInterface _uc = null;
    private Logger _logger = null;
    private static final String _defaultLoggingContext = MethodTimer.class.getName();

    public MethodTimer(String methodName) throws RemoteException {
        this(methodName, (UserContextInterface)null);
    }

    public MethodTimer(String methodName, HttpServletRequest request) throws RemoteException {
        Logger logger = this.initWithUCorRequest(methodName, null, request);
        this.setup(logger, this.fullMsg);
    }

    public MethodTimer(String methodName, HttpServletRequest request, UserContextInterface uc) throws RemoteException {
        Logger logger = this.initWithUCorRequest(methodName, uc, request);
        this.setup(logger, this.fullMsg);
    }

    public MethodTimer(String methodName, UserContextInterface userContext, String extraInfo) throws RemoteException {
        String msg = methodName;
        if (System.getProperty("timer.debug") != null) {
            msg = methodName + " [" + extraInfo + "]";
        }
        Logger logger = this.initWithUCorRequest(msg, userContext, null);
        this.setup(logger, this.fullMsg);
    }

    public MethodTimer(String methodName, UserContextInterface userContext) throws RemoteException {
        Logger logger = this.initWithUCorRequest(methodName, userContext, null);
        this.setup(logger, this.fullMsg);
    }

    private void setup(Logger logger, String methodName) {
        if (logger == null || logger != null && logger.isDebugEnabled()) {
            this.lStartTime = System.currentTimeMillis();
            this.strMethodName = methodName;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("START:\t\tMethod ").append(this.strMethodName);
            if (logger != null) {
                logger.debug(sbuf.toString(), (Object)this._loggingContext);
            } else {
                this.logToStdErr(sbuf.toString(), this._loggingContext);
            }
        }
    }

    private Logger getDefaultLogger() {
        if (this._logger == null) {
            this._logger = LogManager.getLogger((String)_defaultLoggingContext);
        }
        return this._logger;
    }

    private Logger initWithUCorRequest(String methodName, UserContextInterface userContext, HttpServletRequest request) throws RemoteException {
        Logger logger = this.getDefaultLogger();
        if (userContext != null) {
            this._uc = userContext;
        }
        if (request != null && userContext == null) {
            HttpSession session = null;
            if (request != null) {
                session = request.getSession(false);
                SASProfileInterface profile = null;
                if (session != null) {
                    profile = (SASProfileInterface)session.getAttribute("sasidpProfile_s");
                }
                if (profile != null) {
                    this._uc = profile.getUserContext();
                }
            }
        }
        if (this._uc != null) {
            logger = LogManager.getLogger((Class)this._uc.getClass());
        }
        this.fullMsg = methodName;
        String prop = System.getProperty("timer.debug");
        if (prop != null) {
            String uniqueId = "";
            String uri = "";
            String ucId = "";
            String ucName = "";
            if (request != null) {
                uniqueId = request.toString();
                if (uniqueId.indexOf("@") >= 0) {
                    uniqueId = uniqueId.substring(uniqueId.indexOf("@") + 1);
                }
                uri = request.getRequestURI();
            }
            if (userContext != null) {
                ucName = userContext.getName();
                ucId = userContext.getKey();
                if (ucId.lastIndexOf(":") >= 0) {
                    ucId = ucId.substring(ucId.lastIndexOf(":") + 1);
                }
            }
            this.fullMsg = methodName;
            if (uri != null && uri.trim().length() > 0) {
                this.fullMsg = this.fullMsg + "[" + uri + ", req_id:" + uniqueId + "]";
            }
            if (userContext != null) {
                this.fullMsg = this.fullMsg + "  [" + ucName + ", uc_id:" + ucId + "]";
            }
        }
        return logger;
    }

    public long stopTimer() throws RemoteException {
        long retVal = 0L;
        Logger logger = this.getDefaultLogger();
        if (this._uc != null) {
            logger = LogManager.getLogger((Class)this._uc.getClass());
        }
        if (logger == null || logger != null && logger.isDebugEnabled()) {
            this.lStopTime = System.currentTimeMillis();
            retVal = this.lStopTime - this.lStartTime;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("END  :\t").append(retVal).append("ms\tMethod ").append(this.strMethodName);
            if (logger != null) {
                logger.debug(sbuf.toString(), (Object)this._loggingContext);
            } else {
                this.logToStdErr(sbuf.toString(), this._loggingContext);
            }
        }
        return retVal;
    }

    public static MethodTimer startTimer(String methodName) throws RemoteException {
        return MethodTimer.startTimer(methodName, (UserContextInterface)null);
    }

    public static MethodTimer startTimer(String methodName, HttpServletRequest request) throws RemoteException {
        MethodTimer newInstance = new MethodTimer(methodName, request);
        return newInstance;
    }

    public static MethodTimer startTimer(String methodName, ServletRequest request) throws RemoteException {
        MethodTimer newInstance = null;
        newInstance = request instanceof HttpServletRequest ? new MethodTimer(methodName, (HttpServletRequest)request) : new MethodTimer(methodName, (HttpServletRequest)null);
        return newInstance;
    }

    public static MethodTimer startTimer(String methodName, ServletRequest request, UserContextInterface uc) throws RemoteException {
        MethodTimer newInstance = null;
        newInstance = request instanceof HttpServletRequest ? new MethodTimer(methodName, (HttpServletRequest)request, uc) : new MethodTimer(methodName, (HttpServletRequest)null);
        return newInstance;
    }

    public static MethodTimer startTimer(String methodName, UserContextInterface userContext) throws RemoteException {
        MethodTimer newInstance = new MethodTimer(methodName, userContext);
        return newInstance;
    }

    public static MethodTimer startTimer(String methodName, UserContextInterface userContext, String extraInfo) throws RemoteException {
        MethodTimer newInstance = new MethodTimer(methodName, userContext, extraInfo);
        return newInstance;
    }

    private void logToStdErr(String output, String context) {
        System.err.println(context + ": " + output);
    }
}

