/*
 * Decompiled with CFR 0.152.
 */
package com.sas.common.util;

import com.sas.common.util.FullSearchFilter;
import com.sas.common.util.ThemesRegistryInfo;
import com.sas.common.util.res.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.IdentityGroupInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.webapp.ServicesFacade;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public final class MetadataUtil {
    public static final String RB_KEY = "MetadataUtil.";
    private static String _loggingContext = MetadataUtil.class.getName();
    private static List PROTOCOL_LIST = new ArrayList();
    private static final String OMI_PROTOCOL = "omi";
    private static final String TCPIP_INTERNAL = "Internal Subnet";
    private static final String TCPIP_EXTERNAL = "External";
    public static final String OMR_PORTAL_ADMINS_NAME = "Portal Admins";
    public static final String PACKAGE_VIEWER_WEBAPP_VIEWER = "Package Viewer Component";
    public static final String INFO_MAP_WEBAPP_VIEWER = "Information Map Viewer Component";
    public static final String REPORT_WEBAPP_VIEWER = "Report Viewer Component";
    private static final String FOUNDATION_REPOSITORY_ONLY_GROUP_NAME = "FoundationOnly";
    private static final String FOUNDATION_REPOSITORY_ONLY_GROUP_DESC = "Foundation Repository";

    private MetadataUtil() {
    }

    public static final List find(UserContextInterface user, FilterInterface filter) throws RemoteException, ServiceException {
        InformationServiceInterface is = ServicesFacade.getInformationService();
        ArrayList<String> protocolList = new ArrayList<String>();
        protocolList.add(OMI_PROTOCOL);
        List items = is.searchProtocols(user, protocolList, filter);
        return items;
    }

    public static final List findLight(UserContextInterface user, FilterInterface filter) throws RemoteException, ServiceException {
        ArrayList retval = new ArrayList();
        List serverList = user.getServers();
        if (serverList != null) {
            for (com.sas.services.information.ServerInterface aServer : serverList) {
                List results = aServer.browseSearch(filter);
                retval.addAll(results);
            }
        }
        return retval;
    }

    public static List removeDups(List incoming) throws RemoteException {
        ArrayList<Object> newResults = new ArrayList<Object>();
        ArrayList<String> seenIds = new ArrayList<String>();
        for (Object obj : incoming) {
            if (obj instanceof MetadataInterface) {
                MetadataInterface meta = (MetadataInterface)obj;
                if (seenIds.contains(meta.getReposId())) continue;
                newResults.add(meta);
                seenIds.add(meta.getReposId());
                continue;
            }
            if (obj instanceof BrowseMetadataInterface) {
                String key = ((BrowseMetadataInterface)obj).getISEntityKey();
                if (seenIds.contains(key)) continue;
                newResults.add(obj);
                seenIds.add(key);
                continue;
            }
            newResults.add(obj);
        }
        return newResults;
    }

    public static List findThemeMetadata(UserContextInterface user) throws RemoteException, ServiceException {
        List retval = null;
        Filter filter = new Filter("Name", 0, "SAS Presentation Theme");
        filter.setType("DeployedComponent");
        filter.setOMRFlags(8704);
        retval = MetadataUtil.find(user, (FilterInterface)filter);
        if (retval == null || retval.size() == 0) {
            filter = new Filter("Name", 0, "SAS Presentation Theme 92");
            filter.setType("DeployedComponent");
            filter.setOMRFlags(8704);
            retval = MetadataUtil.find(user, (FilterInterface)filter);
        }
        return retval;
    }

    public static Map getThemesRegistry(List list) throws RemoteException {
        HashMap<String, ThemesRegistryInfo> map = new HashMap<String, ThemesRegistryInfo>();
        Iterator iter = list.iterator();
        RemoteException remoteEx = null;
        UserContextInterface userContext = null;
        ArrayList<SoftwareComponentInterface> externals = new ArrayList<SoftwareComponentInterface>();
        while (iter.hasNext()) {
            try {
                ServerInterface server = (ServerInterface)iter.next();
                userContext = server.getRepository().getUserContext();
                SoftwareComponentInterface sc = server.getDescriptiveComponent();
                if (sc == null) continue;
                if (sc.getName().endsWith(TCPIP_EXTERNAL)) {
                    externals.add(sc);
                    continue;
                }
                ThemesRegistryInfo info = new ThemesRegistryInfo();
                String name = sc.getName();
                info.setComponentName(name);
                for (Object obj : server.getSourceConnections()) {
                    if (!(obj instanceof TCPIPConnectionInterface)) continue;
                    TCPIPConnectionInterface tcpip = (TCPIPConnectionInterface)obj;
                    if (tcpip.getName().equals(TCPIP_INTERNAL)) {
                        String hostName = tcpip.getHost();
                        if (hostName == null || hostName.equals("0.0.0.0")) continue;
                        info.setSubnetToUse(hostName);
                        continue;
                    }
                    info.setCommunicationProtocol(tcpip.getCommunicationProtocol());
                    info.setPort(tcpip.getPort());
                    info.setService(tcpip.getService());
                    info.setHostName(tcpip.getHost());
                }
                map.put(name, info);
            }
            catch (NullPointerException n) {
                String msg = RB.getStringResource("MetadataUtil.getThemesRegistryNull.txt", Locale.getDefault());
                LogManager.getLogger((Class)userContext.getClass()).error(msg, (Object)_loggingContext);
                remoteEx = new RemoteException(msg);
            }
            catch (ServiceException m) {
                LogManager.getLogger((Class)userContext.getClass()).error(m.getMessage(), (Object)_loggingContext);
                remoteEx = new RemoteException(m.getMessage(), m);
            }
        }
        try {
            if (externals.size() > 0 && !map.isEmpty()) {
                for (SoftwareComponentInterface external : externals) {
                    MetadataUtil.processExternal(external, map);
                }
            }
        }
        catch (ServiceException e) {
            LogManager.getLogger((Class)userContext.getClass()).error(e.getMessage(), (Object)_loggingContext);
            remoteEx = new RemoteException(e.getMessage(), e);
        }
        if (remoteEx != null && map.isEmpty()) {
            throw remoteEx;
        }
        return map;
    }

    public static synchronized List getMetadataListByFilter(UserContextInterface userContext, Filter filter) throws RemoteException, ServiceException {
        List retval = null;
        InformationServiceInterface informationService = ServicesFacade.getInformationService();
        retval = informationService.searchProtocols(userContext, PROTOCOL_LIST, (FilterInterface)filter);
        return retval;
    }

    public static synchronized MetadataInterface getObjectByEntityKey(UserContextInterface userContext, String entityKey) throws RemoteException {
        MetadataInterface retval = null;
        MetadataInterface obj = null;
        try {
            InformationServiceInterface informationService = ServicesFacade.getInformationService();
            obj = informationService.fetchEntityByKey(userContext, entityKey);
        }
        catch (NullPointerException e2) {
            if (entityKey.indexOf("Content+dav://") >= 0) {
                LogManager.getLogger((Class)userContext.getClass()).error(RB.getStringResource("wai.dav.not.up.object.in.dav.txt", Locale.getDefault()), (Object)_loggingContext);
                return null;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (obj instanceof MetadataInterface) {
            retval = obj;
        }
        return retval;
    }

    private static void processExternal(SoftwareComponentInterface externalInfo, Map registries) throws ServiceException, RemoteException {
        int breakpos;
        List deployedComponents = externalInfo.getDeployedComponents();
        if (deployedComponents == null || deployedComponents.isEmpty()) {
            return;
        }
        String name = externalInfo.getName();
        String internalName = name.substring(0, breakpos = name.indexOf(TCPIP_EXTERNAL)).trim();
        ThemesRegistryInfo themeInfo = (ThemesRegistryInfo)registries.get(internalName);
        if (themeInfo != null) {
            for (ServerInterface deployedComponent : deployedComponents) {
                List connections = deployedComponent.getSourceConnections();
                if (connections == null || connections.isEmpty()) continue;
                Iterator inner = connections.iterator();
                if (!inner.hasNext()) break;
                TCPIPConnectionInterface tcpip = (TCPIPConnectionInterface)inner.next();
                themeInfo.setExternalHostName(tcpip.getHost());
                themeInfo.setExternalPort(tcpip.getPort());
                themeInfo.setExternalService(tcpip.getService());
                break;
            }
        }
    }

    public static boolean isPortalAdmin(UserContextInterface userContext, String adminUserId) throws ServiceException, RemoteException {
        PersonInterface person;
        List groups;
        if (userContext == null) {
            return false;
        }
        boolean retval = false;
        retval = MetadataUtil.isUnrestrictedUser(userContext, adminUserId);
        if (!retval && userContext != null && (groups = (person = (PersonInterface)userContext.getPerson()).getIdentityGroups()) != null) {
            IdentityGroupInterface group2 = null;
            for (IdentityGroupInterface group2 : groups) {
                if (!group2.getName().equalsIgnoreCase(OMR_PORTAL_ADMINS_NAME)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public static boolean isUnrestrictedUser(UserContextInterface userContext, String adminUserId) throws RemoteException {
        if (userContext == null) {
            return false;
        }
        boolean retval = false;
        String searchString = "@Name?'" + adminUserId + "'";
        List aList = FullSearchFilter.doSearch(userContext, searchString, "Login", true);
        if (aList.size() > 0) {
            retval = true;
        }
        return retval;
    }

    public static String findWebappURL(UserContextInterface user, String whichViewer, String serverName, int serverPort) throws RemoteException, ServiceException {
        StringBuffer retval = new StringBuffer();
        Filter filter = new Filter("Name", 0, whichViewer);
        filter.setType("DeployedComponent");
        filter.setOMRFlags(0x200 | filter.getOMRFlags());
        List list = MetadataUtil.find(user, (FilterInterface)filter);
        Iterator iter = list.iterator();
        String hostCommProtocol = "";
        int hostPort = 0;
        String hostURL = "";
        String hostMachine = null;
        UserContextInterface userContext = null;
        while (iter.hasNext()) {
            try {
                ServerInterface server = (ServerInterface)iter.next();
                userContext = server.getRepository().getUserContext();
                if (server.getName().equals(whichViewer)) {
                    for (TCPIPConnectionInterface tcpipConn : server.getSourceConnections()) {
                        hostCommProtocol = tcpipConn.getCommunicationProtocol();
                        hostPort = tcpipConn.getPort();
                        hostMachine = tcpipConn.getHost();
                        hostURL = tcpipConn.getService();
                        for (PropertyInterface aProp : tcpipConn.getObjectProperties()) {
                            hostURL = aProp.getValue();
                        }
                    }
                }
                if (hostMachine != null && hostMachine.trim().length() > 0 || serverName != null && serverName.trim().length() > 0) {
                    retval.append(hostCommProtocol);
                    retval.append("://");
                }
                if (hostMachine != null && hostMachine.trim().length() > 0) {
                    retval.append(hostMachine);
                } else {
                    retval.append(serverName);
                }
                if (hostPort > 0) {
                    retval.append(":").append(hostPort);
                } else if (serverPort > 0) {
                    retval.append(":").append(serverPort);
                }
                retval.append(hostURL);
            }
            catch (ServiceException m) {
                LogManager.getLogger((Class)userContext.getClass()).error(m.getMessage(), (Object)_loggingContext);
            }
        }
        return retval.toString();
    }

    public static RepositoryGroup getFoundationOnlyGroup(UserContextInterface userContext) throws RemoteException {
        RepositoryGroup reposGroup = null;
        try {
            InformationServiceInterface informationService = ServicesFacade.getInformationService();
            reposGroup = informationService.getRepositoryGroup(FOUNDATION_REPOSITORY_ONLY_GROUP_NAME);
            if (reposGroup == null) {
                List repositories = userContext.getRepositories();
                Iterator it = repositories.iterator();
                RepositoryInterface repository = null;
                boolean found = false;
                while (it.hasNext()) {
                    String reposType;
                    repository = (RepositoryInterface)it.next();
                    if (!(repository instanceof OMIRepositoryInterface) || !(reposType = ((OMIRepositoryInterface)repository).getRepositoryType()).equals("FOUNDATION")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    repository = userContext.getPerson().getRepository();
                }
                reposGroup = new RepositoryGroup(FOUNDATION_REPOSITORY_ONLY_GROUP_NAME);
                String reposName = repository.getISName();
                reposGroup.setDescription(FOUNDATION_REPOSITORY_ONLY_GROUP_DESC);
                reposGroup.addRepository(reposName);
                informationService.addRepositoryGroup(reposGroup);
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return reposGroup;
    }

    public static List searchFoundation(UserContextInterface user, Filter filter) throws RemoteException {
        List retVal = null;
        try {
            RepositoryGroup foundationOnly = MetadataUtil.getFoundationOnlyGroup(user);
            InformationServiceInterface informationService = Metadata.getInformationService();
            retVal = informationService.searchGroup(user, foundationOnly, (FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return retVal;
    }

    public static List search(UserContextInterface user, Filter filter) throws RemoteException {
        List retval = null;
        try {
            RepositoryGroup foundationOnly = MetadataUtil.getFoundationOnlyGroup(user);
            InformationServiceInterface informationService = Metadata.getInformationService();
            retval = informationService.searchGroup(user, foundationOnly, (FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        return retval;
    }

    static {
        PROTOCOL_LIST.add(OMI_PROTOCOL);
    }
}

