/*
 * Decompiled with CFR 0.152.
 */
package com.sas.common.util;

import com.sas.common.util.MetadataUtil;
import com.sas.common.util.MethodTimer;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class FullSearchFilter
extends Filter {
    private static final long serialVersionUID = -4432894298524011410L;
    private static ArrayList<String> OMI_SEARCH_PROTOCOLS = new ArrayList<String>(){
        {
            this.add("omi");
        }
    };
    private String _searchString = null;
    private String _type = null;

    public FullSearchFilter() {
    }

    public FullSearchFilter(String searchString, String type) {
        this.setSearchString(searchString);
        this.setType(type);
    }

    public FullSearchFilter(String searchString, String type, String templateString) {
        this.setSearchString(searchString);
        this.setType(type);
        this.setOMRTemplate(templateString);
    }

    public String getType() {
        return this._type;
    }

    public String getXMLSelectString() {
        return "<XMLSelect Search=\"" + this._searchString + "\" />\n";
    }

    public String getSearchString() {
        return this._searchString;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setSearchString(String searchString) {
        this._searchString = XMLUtil.normalize((String)searchString);
    }

    public static List doSearch(UserContextInterface user, String searchString, String type, boolean caseSensitive) throws RemoteException {
        String methodName = "FullSearchFilter.doSearch";
        String extraInfo = "[" + type + "]: " + searchString;
        MethodTimer aTimer = new MethodTimer(methodName, user, extraInfo);
        List retVal = null;
        try {
            String searchStringWithEnds = searchString;
            if (!searchStringWithEnds.startsWith("[")) {
                searchStringWithEnds = "[" + searchStringWithEnds + "]";
            }
            FullSearchFilter filter = new FullSearchFilter(type + searchStringWithEnds, type);
            if (caseSensitive) {
                int existingFlags = filter.getOMRFlags();
                filter.setOMRFlags(existingFlags += 8704);
            }
            retVal = MetadataUtil.find(user, (FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            aTimer.stopTimer();
        }
        return retVal;
    }

    public static List doSearch(UserContextInterface user, String searchString, String type, boolean caseSensitive, boolean paramFrom913) throws RemoteException {
        return FullSearchFilter.doSearch(user, searchString, type, caseSensitive);
    }

    public static List doSearchWithTemplate(RepositoryInterface repository, String searchString, String templateString, String type, String returnType, boolean caseSensitive) throws RemoteException {
        String fullTemplateString = "<Templates>\t\t<" + type + " Id=''>" + templateString + "</" + type + ">   <" + returnType + " Id='' Name='' /> </Templates>";
        String methodName = "FullSearchFilter.doSearchWithTemplate";
        String extraInfo = "[" + type + "]: " + searchString + "," + fullTemplateString;
        MethodTimer aTimer = new MethodTimer(methodName, repository.getUserContext(), extraInfo);
        List retVal = null;
        try {
            String searchStringWithEnds = searchString;
            if (!searchStringWithEnds.startsWith("[")) {
                searchStringWithEnds = "[" + searchStringWithEnds + "]";
            }
            int numOpenBrace = 0;
            int numCloseBrace = 0;
            for (int i = 0; i < searchStringWithEnds.length(); ++i) {
                char thisChar = searchStringWithEnds.charAt(i);
                if (thisChar == '[') {
                    ++numOpenBrace;
                }
                if (thisChar != ']') continue;
                ++numCloseBrace;
            }
            if (numOpenBrace != numCloseBrace) {
                System.out.println("\n\n\nRequested to search with an XML String with imbalanced braces!!!! \n\n\n");
            }
            FullSearchFilter filter = new FullSearchFilter(type + searchStringWithEnds, type, fullTemplateString);
            if (caseSensitive) {
                int existingFlags = filter.getOMRFlags();
                filter.setOMRFlags(existingFlags += 8704);
            }
            retVal = MetadataUtil.find(repository.getUserContext(), (FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            aTimer.stopTimer();
        }
        return retVal;
    }

    public static List doSearchWithFullTemplate(UserContextInterface user, String searchString, String templateString, String type, boolean caseSensitive) throws RemoteException {
        return FullSearchFilter.doSearchWithFullTemplate(user, searchString, templateString, type, caseSensitive, false);
    }

    public static List doSearchWithFullTemplate(UserContextInterface user, String searchString, String templateString, String type, boolean caseSensitive, boolean returnBrowseMetadataObjects) throws RemoteException {
        String fullTemplateString = "<Templates>" + templateString + "</Templates>";
        String methodName = "FullSearchFilter.doSearchWithFullTemplate";
        String extraInfo = "[" + type + "]: " + searchString + "," + fullTemplateString;
        MethodTimer aTimer = new MethodTimer(methodName, user, extraInfo);
        List retVal = null;
        try {
            String searchStringWithEnds = searchString;
            if (!searchStringWithEnds.startsWith("[")) {
                searchStringWithEnds = "[" + searchStringWithEnds + "]";
            }
            FullSearchFilter filter = new FullSearchFilter(type + searchStringWithEnds, type, fullTemplateString);
            if (caseSensitive) {
                int existingFlags = filter.getOMRFlags();
                filter.setOMRFlags(existingFlags += 8704);
            }
            retVal = returnBrowseMetadataObjects ? MetadataUtil.findLight(user, (FilterInterface)filter) : MetadataUtil.find(user, (FilterInterface)filter);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            aTimer.stopTimer();
        }
        return retVal;
    }

    public static List doSearchWithTemplate(UserContextInterface userContext, String searchString, String templateString, String type, String returnType, RepositoryGroup reposGroup, boolean caseSensitive) throws RemoteException {
        String fullTemplateString = "<Templates>\t\t<" + type + " Id=''>" + templateString + "</" + type + ">   <" + returnType + " Id='' Name='' /> </Templates>";
        String methodName = "FullSearchFilter.doSearchWithTemplate";
        String extraInfo = "[" + type + "]: " + searchString + "," + fullTemplateString;
        MethodTimer aTimer = new MethodTimer(methodName, userContext, extraInfo);
        ArrayList searchResultList = new ArrayList();
        try {
            String searchStringWithEnds = searchString;
            if (!searchStringWithEnds.startsWith("[")) {
                searchStringWithEnds = "[" + searchStringWithEnds + "]";
            }
            FullSearchFilter filter = new FullSearchFilter(type + searchStringWithEnds, type, fullTemplateString);
            if (caseSensitive) {
                int existingFlags = filter.getOMRFlags();
                filter.setOMRFlags(existingFlags += 8704);
            }
            InformationServiceInterface infoService = Metadata.getInformationService();
            if (reposGroup != null) {
                Filter[] filtersOMR = new Filter[]{filter};
                searchResultList.addAll(infoService.searchGroupWithFilterArray(userContext, reposGroup, (FilterInterface[])filtersOMR));
            } else {
                searchResultList.addAll(infoService.searchProtocols(userContext, OMI_SEARCH_PROTOCOLS, (FilterInterface)filter));
            }
        }
        catch (InitializationException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        finally {
            aTimer.stopTimer();
        }
        return searchResultList;
    }
}

