/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.util;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;

public class MessageResources {
    private Locale locale;
    private ApplicationContext ctx = ContextLoader.getCurrentWebApplicationContext();

    public static MessageResources getMessageResources(HttpServletRequest request) {
        MessageResources res = new MessageResources();
        res.setLocale(request.getLocale());
        return res;
    }

    public static MessageResources getMessageResources(Locale locale) {
        MessageResources res = new MessageResources();
        res.setLocale(locale);
        return res;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        String reqLocaleString = locale.toString();
        this.locale = reqLocaleString.equalsIgnoreCase("zh_HANS_CN") ? new Locale("zh", "CN") : (reqLocaleString.equalsIgnoreCase("zh_HANT_TW") ? new Locale("zh", "TW") : (reqLocaleString.equalsIgnoreCase("zh_HANT_HK") ? new Locale("zh", "HK") : (reqLocaleString.equalsIgnoreCase("zh_HANS") ? new Locale("zh", "CN") : (reqLocaleString.equalsIgnoreCase("zh_HANT") ? new Locale("zh", "TW") : locale))));
    }

    public String getMessage(String code) {
        try {
            return this.ctx.getMessage(code, null, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, String defaultMessage) {
        try {
            return this.ctx.getMessage(code, null, defaultMessage, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, Locale inlocale) {
        try {
            return this.ctx.getMessage(code, null, inlocale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, Object[] args) {
        try {
            return this.ctx.getMessage(code, args, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, Object arg0) {
        try {
            return this.ctx.getMessage(code, new Object[]{arg0}, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, Object arg0, Object arg1) {
        try {
            return this.ctx.getMessage(code, new Object[]{arg0, arg1}, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMessage(String code, Object arg0, Object arg1, Object arg2) {
        try {
            return this.ctx.getMessage(code, new Object[]{arg0, arg1, arg2}, this.locale);
        }
        catch (Exception e) {
            return null;
        }
    }
}

