/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.util;

import com.sas.framework.webapp.util.ActionMessage;
import com.sas.framework.webapp.util.MessageResources;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyContent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class ActionMessages
implements Serializable {
    private static final long serialVersionUID = 5832418544347260177L;
    private static final Comparator ACTION_ITEM_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ActionMessageItem)o1).getOrder() - ((ActionMessageItem)o2).getOrder();
        }
    };
    public static final String GLOBAL_MESSAGE = "org.apache.struts.action.GLOBAL_MESSAGE";
    public static final String ERROR_KEY = "org.apache.struts.action.ERROR";
    public static final String MESSAGE_KEY = "org.apache.struts.action.ACTION_MESSAGE";
    public static final String EXCEPTION_KEY = "org.apache.struts.action.EXCEPTION";
    public static final String MESSAGES_KEY = "org.apache.struts.action.MESSAGE";
    public static final String Globals_TRANSACTION_TOKEN_KEY = "org.apache.struts.action.TOKEN";
    public static final String Constants_TOKEN_KEY = "org.apache.struts.taglib.html.TOKEN";
    public static final String Constants_BEAN_KEY = "org.apache.struts.taglib.html.BEAN";
    private static final Map scopes = new HashMap();
    protected boolean accessed = false;
    protected HashMap messages = new HashMap();
    protected int iCount = 0;

    public ActionMessages() {
    }

    public ActionMessages(ActionMessages messages) {
        this.add(messages);
    }

    public void add(String property, ActionMessage message) {
        ArrayList<ActionMessage> list;
        ActionMessageItem item = (ActionMessageItem)this.messages.get(property);
        if (item == null) {
            list = new ArrayList<ActionMessage>();
            item = new ActionMessageItem(list, this.iCount++, property);
            this.messages.put(property, item);
        } else {
            list = item.getList();
        }
        list.add(message);
    }

    public void add(ActionMessages actionMessages) {
        if (actionMessages == null) {
            return;
        }
        Iterator props = actionMessages.properties();
        while (props.hasNext()) {
            String property = (String)props.next();
            Iterator msgs = actionMessages.get(property);
            while (msgs.hasNext()) {
                ActionMessage msg = (ActionMessage)msgs.next();
                this.add(property, msg);
            }
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Iterator get() {
        this.accessed = true;
        if (this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList results = new ArrayList();
        ArrayList actionItems = new ArrayList();
        Iterator<Object> i = this.messages.values().iterator();
        while (i.hasNext()) {
            actionItems.add(i.next());
        }
        Collections.sort(actionItems, ACTION_ITEM_COMPARATOR);
        for (ActionMessageItem ami : actionItems) {
            Iterator msgsIter = ami.getList().iterator();
            while (msgsIter.hasNext()) {
                results.add(msgsIter.next());
            }
        }
        return results.iterator();
    }

    public Iterator get(String property) {
        this.accessed = true;
        ActionMessageItem item = (ActionMessageItem)this.messages.get(property);
        if (item == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return item.getList().iterator();
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public Iterator properties() {
        if (this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<String> results = new ArrayList<String>();
        ArrayList actionItems = new ArrayList();
        Iterator<Object> i = this.messages.values().iterator();
        while (i.hasNext()) {
            actionItems.add(i.next());
        }
        Collections.sort(actionItems, ACTION_ITEM_COMPARATOR);
        for (ActionMessageItem ami : actionItems) {
            results.add(ami.getProperty());
        }
        return results.iterator();
    }

    public int size() {
        int total = 0;
        for (ActionMessageItem ami : this.messages.values()) {
            total += ami.getList().size();
        }
        return total;
    }

    public int size(String property) {
        ActionMessageItem item = (ActionMessageItem)this.messages.get(property);
        return item == null ? 0 : item.getList().size();
    }

    public String toString() {
        return this.messages.toString();
    }

    public static ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        ActionMessages am;
        block8: {
            am = new ActionMessages();
            Object value = pageContext.findAttribute(paramName);
            if (value != null) {
                try {
                    if (value instanceof String) {
                        am.add(GLOBAL_MESSAGE, new ActionMessage((String)value));
                        break block8;
                    }
                    if (value instanceof String[]) {
                        String[] keys = (String[])value;
                        for (int i = 0; i < keys.length; ++i) {
                            am.add(GLOBAL_MESSAGE, new ActionMessage(keys[i]));
                        }
                        break block8;
                    }
                    if (value instanceof ActionMessages) {
                        am = (ActionMessages)value;
                        break block8;
                    }
                    throw new JspException("actionMessages.errors" + value.getClass().getName());
                }
                catch (JspException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return am;
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute(EXCEPTION_KEY, (Object)exception, 2);
    }

    public static String message(PageContext pageContext, String bundle, String key, Object[] args) throws JspException {
        Locale userLocale = pageContext.getRequest().getLocale();
        MessageResources res = MessageResources.getMessageResources(userLocale);
        String message = null;
        message = args == null ? res.getMessage(key) : res.getMessage(key, args);
        return message;
    }

    public static String message(PageContext pageContext, String bundle, String key) throws JspException {
        return ActionMessages.message(pageContext, bundle, key, null);
    }

    public static void write(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        }
        catch (IOException e) {
            ActionMessages.saveException(pageContext, e);
            throw new JspException("write.io" + e.toString());
        }
    }

    public static void writePrevious(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        if (writer instanceof BodyContent) {
            writer = ((BodyContent)writer).getEnclosingWriter();
        }
        try {
            writer.print(text);
        }
        catch (IOException e) {
            ActionMessages.saveException(pageContext, e);
            throw new JspException("write.io" + e.toString());
        }
    }

    public static Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)ActionMessages.lookup(pageContext, name, property, scope);
            }
        }
        catch (JspException e) {
            ActionMessages.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = ActionMessages.lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                ActionMessages.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String[]) {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                } else {
                    String[] newValues = new String[]{mapValue.toString(), paramString};
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute(Globals_TRANSACTION_TOKEN_KEY);
            }
            if (token != null) {
                results.put(Constants_TOKEN_KEY, token);
            }
        }
        return results;
    }

    public static int getScope(String scopeName) throws JspException {
        Integer scope = (Integer)scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException("lookup.scope " + scope);
        }
        return scope;
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = null;
        if (scope == null) {
            bean = pageContext.findAttribute(name);
        }
        try {
            bean = pageContext.getAttribute(name, ActionMessages.getScope(scope));
        }
        catch (JspException e) {
            ActionMessages.saveException(pageContext, e);
            throw e;
        }
        if (bean == null) {
            e = null;
            e = scope == null ? new JspException("lookup.bean.any " + name) : new JspException("lookup.bean " + name + " " + scope);
            ActionMessages.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            ActionMessages.saveException(pageContext, e);
            throw new JspException("lookup.access " + property + " " + name);
        }
        catch (IllegalArgumentException e) {
            ActionMessages.saveException(pageContext, e);
            throw new JspException("lookup.argument " + property + " " + name);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            ActionMessages.saveException(pageContext, t);
            throw new JspException("lookup.target" + property + " " + name);
        }
        catch (NoSuchMethodException e) {
            Object obj;
            ActionMessages.saveException(pageContext, e);
            String beanName = name;
            if (Constants_BEAN_KEY.equals(name) && (obj = pageContext.findAttribute(Constants_BEAN_KEY)) != null) {
                beanName = obj.getClass().getName();
            }
            throw new JspException("lookup.method " + property + " " + beanName);
        }
    }

    static {
        scopes.put("page", new Integer(1));
        scopes.put("request", new Integer(2));
        scopes.put("session", new Integer(3));
        scopes.put("application", new Integer(4));
    }

    protected class ActionMessageItem
    implements Serializable {
        protected List list = null;
        protected int iOrder = 0;
        protected String property = null;

        public ActionMessageItem(List list, int iOrder, String property) {
            this.list = list;
            this.iOrder = iOrder;
            this.property = property;
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }

        public int getOrder() {
            return this.iOrder;
        }

        public void setOrder(int iOrder) {
            this.iOrder = iOrder;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String toString() {
            return this.list.toString();
        }
    }
}

