/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.AbstractEnum;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.MediaType;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ClientHelper;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class ThemeStylesTag
extends UIBodyTagSupport {
    private static final String COMMA_DELIMITER = ",";
    private static final String SAS_STYLE = "SAS Style";
    private static final long serialVersionUID = 1L;
    private String media = "SCREEN";
    private String stylesheets = null;

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String m) {
        this.media = m;
    }

    public String getStyleSheets() {
        return this.stylesheets;
    }

    public void setStyleSheets(String s) {
        this.stylesheets = s;
    }

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Theme theme = null;
        try {
            theme = this.getTheme();
        }
        catch (ThemeException te) {
            throw new JspException("ThemeStylesTag: " + te.getMessage());
        }
        Iterator iter = this.getStyles(theme, request);
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append("<link rel=\"stylesheet\"");
            sb.append(" href=\"");
            String css = (String)iter.next();
            if (!css.substring(0, 4).equalsIgnoreCase("http")) {
                sb.append(FrameworkHelper.getBaseUrl(request));
            }
            sb.append(css);
            sb.append("\" type=\"text/css\" media=\"");
            sb.append(this.getMedia());
            sb.append("\" />\n");
        }
        try {
            writer.print(sb.toString());
        }
        catch (IOException e) {
            throw new JspException("ThemeStylesTag: " + e.getMessage());
        }
        return 0;
    }

    private Iterator getStyles(Theme theme, HttpServletRequest request) {
        String styles = null;
        if (null != this.getStyleSheets()) {
            styles = this.getStyleSheets();
        } else {
            styles = FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.ThemeStyles");
            if (null == styles) {
                styles = SAS_STYLE;
            } else if (!styles.contains(SAS_STYLE)) {
                if (!styles.endsWith(COMMA_DELIMITER)) {
                    styles = styles + COMMA_DELIMITER;
                }
                styles = styles + SAS_STYLE;
            }
        }
        String med = this.getMedia();
        MediaType type = (MediaType)AbstractEnum.getInstance((String)med, (AbstractEnum[])MediaType.OPTIONS);
        BrowserType browser = ClientHelper.getBrowserType(request);
        Collection c = theme.getStyleSheetsForNamedStyles(type, browser.getKey(), styles);
        return c.iterator();
    }
}

