/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.webapp.taglib.BaseTextSupport;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;

public class TextTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE = "resource";
    private String key = null;
    private String source = "resource";

    public String getKey() {
        return this.key;
    }

    public void setKey(String k) {
        this.key = k.trim();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String src) {
        if ("request".equalsIgnoreCase(src)) {
            this.source = src;
        }
    }

    public String getTextHTML() {
        String text = "";
        if ("request".equalsIgnoreCase(this.getSource())) {
            text = (String)this.pageContext.getAttribute(this.getKey(), 2);
        } else {
            String thisKey = this.getKey();
            if (!thisKey.endsWith(".txt")) {
                thisKey = thisKey + ".txt";
            }
            text = this.getTextFromResource(thisKey);
        }
        StringBuilder html = new StringBuilder();
        if (text != null && !text.equals("")) {
            if (null != this.getStyleClass() && !this.getStyleClass().equals("")) {
                html.append("<span class='").append(this.getStyleClass()).append("'>").append(text).append("</span>");
            } else {
                html.append(text);
            }
        }
        return html.toString();
    }

    public int doStartTag() throws JspException {
        if (null == this.getKey()) {
            return 0;
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(this.getTextHTML());
        }
        catch (IOException e) {
            throw new JspException("TextTag. " + e.getMessage());
        }
        return 0;
    }
}

