/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SortIconTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(SortIconTag.class);
    private String column;
    private String key;

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int doStartTag() throws JspException {
        String sort = (String)this.pageContext.findAttribute(this.getKey());
        if (null == sort) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        try {
            Locale locale = this.getUserLocale();
            if (sort.startsWith(this.getColumn())) {
                buf.append("<img border=\"0\" src=\"");
                String imageName = "sort_";
                imageName = sort.endsWith("descending") ? imageName + "descending" : imageName + "ascending";
                Theme theme = this.getTheme();
                String image = ThemeHelper.getImagePath(theme, imageName);
                String imageText = RB.getString("SortIconTag." + imageName + ".txt", locale);
                buf.append(image).append("\" alt=\"").append(imageText).append("\" title=\"").append(imageText).append("\" align=\"absmiddle\" />");
            }
            JspWriter out = this.pageContext.getOut();
            out.println((Object)buf);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            throw new JspException((Throwable)e);
        }
        catch (ThemeException e) {
            LOGGER.error((Object)e);
            throw new JspException((Throwable)e);
        }
        return 0;
    }
}

