/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class RequestParametersTag
extends UIBodyTagSupport {
    private static final long serialVersionUID = 1L;
    List invalidParameterList = new ArrayList();

    public void setInvalidParameters(String invalidParameters) {
        String[] values = invalidParameters.split(",");
        for (int i = 0; i < values.length; ++i) {
            if (this.invalidParameterList.contains(values[i])) continue;
            this.invalidParameterList.add(values[i]);
        }
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        JspWriter out = this.pageContext.getOut();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String next = (String)enumeration.nextElement();
            if (!this.isParameterValid(next)) continue;
            next = StringEscapeUtils.escapeHtml4((String)next);
            String[] values = request.getParameterValues(next);
            for (int i = 0; i < values.length; ++i) {
                try {
                    String value = StringEscapeUtils.escapeHtml4((String)values[i]);
                    out.println("<input type=\"hidden\" name=\"" + next + "\" value=\"" + value + "\" />");
                    continue;
                }
                catch (IOException e) {
                    throw new JspException("RequestParametersTag", (Throwable)e);
                }
            }
        }
        return 6;
    }

    protected boolean isParameterValid(String parameter) {
        return !"_ia".equals(parameter) && !this.invalidParameterList.contains(parameter);
    }
}

