/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.taglib.BaseTag;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropagateMultiCheckboxTag
extends BaseTag {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PropagateMultiCheckboxTag.class);
    protected String multiCheckboxId = "";

    public void setMultiCheckboxId(String id) {
        this.multiCheckboxId = id;
    }

    public String getMultiCheckboxId() {
        String retId = null;
        retId = null == this.multiCheckboxId ? "sas.multiCheckbox" : this.multiCheckboxId;
        return retId;
    }

    public String getHTML() {
        StringBuilder html = new StringBuilder();
        ServletRequest request = this.getPageContext().getRequest();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = StringEscapeUtils.escapeHtml4((String)((String)enumeration.nextElement()));
            if (!name.startsWith(this.getMultiCheckboxId())) continue;
            String value = StringEscapeUtils.escapeHtml4((String)request.getParameter(name));
            html.append("<input type=hidden name='").append(name).append("' ");
            html.append("value='").append(value);
            html.append("' id='").append(this.getMultiCheckboxId()).append("'/>");
        }
        return html.toString();
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(this.getHTML());
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getMessage(), (Throwable)ioe);
            throw new JspException();
        }
        return 0;
    }
}

