/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.taglib.BaseTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopupMenuTriggerTag
extends BaseTag {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(PopupMenuTriggerTag.class);
    public static final String LEFT_ALIGNED = "left";
    public static final String RIGHT_ALIGNED = "right";
    public static final String FOR_PORTLETS = "portlet";
    protected String menuId = null;
    protected String relativeComponentId = null;
    protected boolean onClick = true;
    protected String menuGroup;
    protected String otherGroup;
    protected String alignment;

    public void setOnClick(boolean onClick) {
        this.onClick = onClick;
    }

    public boolean getOnClick() {
        return this.onClick;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public void setComponentId(String componentId) {
        this.relativeComponentId = componentId;
    }

    public String getComponentId() {
        return this.relativeComponentId;
    }

    protected String getPopupMenuCommand() {
        StringBuilder command = new StringBuilder();
        command.append("javascript:").append(this.getJavascriptMethodName()).append("('").append(this.getMenuId()).append("', '").append(this.getComponentId()).append("'").append(");");
        return command.toString();
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            StringBuilder htmlString = new StringBuilder();
            if (this.onClick) {
                htmlString.append("onClick=\"").append(this.getPopupMenuCommand()).append("\"");
            } else {
                htmlString.append(this.getPopupMenuCommand());
            }
            out.println(htmlString.toString());
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.getMessage(), (Throwable)ioe);
            throw new JspException();
        }
        return 0;
    }

    private String getJavascriptMethodName() {
        String method = "showPopupMenu";
        String align = this.getAlignment();
        if (LEFT_ALIGNED.equals(align)) {
            method = "showPopupMenuLeftAligned";
        } else if (RIGHT_ALIGNED.equals(align)) {
            method = "showPopupMenuRightAligned";
        } else if (FOR_PORTLETS.equals(align)) {
            method = "showPopupMenuForPortlet";
        }
        return method;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public void setMenuGroup(String menuGroup) {
        this.menuGroup = menuGroup;
    }

    public String getOtherGroup() {
        return this.otherGroup;
    }

    public void setOtherGroup(String otherGroup) {
        this.otherGroup = otherGroup;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }
}

