/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseMessageTag;
import com.sas.framework.webapp.util.ActionErrors;
import com.sas.framework.webapp.util.ActionMessage;
import com.sas.framework.webapp.util.Messages;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.Iterator;

public class MessageTag
extends BaseMessageTag {
    private static final long serialVersionUID = 1L;
    public static final String ERROR = "ERROR";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    protected static final String ERROR_TEMPLATE = "error_message";
    protected static final String WARNING_TEMPLATE = "warning_message";
    protected static final String INFO_TEMPLATE = "info_message";
    protected static final String PORTLET_ERROR_TEMPLATE = "error_message_for_portlet";
    protected static final String PORTLET_WARNING_TEMPLATE = "warning_message_for_portlet";
    protected static final String PORTLET_INFO_TEMPLATE = "info_message_for_portlet";

    public int doStartTag() throws JspException {
        JspWriter writer = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        boolean isPortlet = FrameworkHelper.isPortlet(request);
        this.writeErrorMessages(writer, isPortlet);
        this.writeWarningMessages(writer, isPortlet);
        this.writeInfoMessages(writer, isPortlet);
        return 0;
    }

    protected void writeErrorMessages(JspWriter writer, boolean isPortlet) throws JspException {
        String divId = "errorMessage";
        String errorMessage = this.formatErrorMessages();
        if (errorMessage.length() > 1) {
            try {
                String label = this.getLabel();
                if (null == label) {
                    Messages messages = (Messages)this.pageContext.getAttribute("com.sas.framework.webapp.util.MESSAGES", 2);
                    if (null != messages) {
                        label = messages.getErrorTitle();
                    }
                    if (null == label) {
                        label = RB.getString("Error.txt", this.getUserLocale());
                    }
                }
                Dictionary dictionary = new Dictionary();
                dictionary.set((Object)ERROR, (Object)label);
                dictionary.set((Object)"ICON", (Object)(this.getImagesPath(true) + this.getIcon()));
                dictionary.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(false));
                dictionary.set((Object)"TITLE_STYLE", (Object)this.getTitleStyleClass());
                dictionary.set((Object)"TEXT_STYLE", (Object)this.getStyleClass());
                dictionary.set((Object)"BG_STYLE", (Object)this.getBgStyleClass());
                dictionary.set((Object)"MESSAGE", (Object)errorMessage);
                dictionary.set((Object)"DIV_ID", (Object)"errorMessage");
                dictionary.set((Object)"CLEAR_MESSAGE", (Object)("<a href=\"javascript:toggleDiv('errorMessage', true);\">" + RB.getString("Message.clear.txt", this.getUserLocale()) + "</a>"));
                writer.println(this.applyTemplate(dictionary, isPortlet ? PORTLET_ERROR_TEMPLATE : ERROR_TEMPLATE));
            }
            catch (ThemeException te) {
                throw new JspException(MessageTag.getMessageTagError(te.getMessage()), (Throwable)te);
            }
            catch (IOException e) {
                throw new JspException(MessageTag.getMessageTagError(e.getMessage()));
            }
        }
    }

    protected void writeWarningMessages(JspWriter writer, boolean isPortlet) throws JspException {
        String divId = "warningMessage";
        Messages messages = (Messages)this.pageContext.getAttribute("com.sas.framework.webapp.util.MESSAGES", 2);
        String warningMessage = this.createWarningMessage(messages);
        if (warningMessage.length() > 1) {
            try {
                String label = this.getLabel();
                if (null == label && null == (label = messages.getWarningTitle())) {
                    label = RB.getString("Warning.txt", this.getUserLocale());
                }
                Dictionary dictionary = new Dictionary();
                dictionary.set((Object)WARNING, (Object)label);
                dictionary.set((Object)"ICON", (Object)(this.getImagesPath(true) + this.getIcon()));
                dictionary.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(false));
                dictionary.set((Object)"TITLE_STYLE", (Object)this.getTitleStyleClass());
                dictionary.set((Object)"TEXT_STYLE", (Object)this.getStyleClass());
                dictionary.set((Object)"BG_STYLE", (Object)this.getBgStyleClass());
                dictionary.set((Object)"MESSAGE", (Object)warningMessage);
                dictionary.set((Object)"DIV_ID", (Object)"warningMessage");
                dictionary.set((Object)"CLEAR_MESSAGE", (Object)("<a href=\"javascript:toggleDiv('warningMessage', true);\">" + RB.getString("Message.clear.txt", this.getUserLocale()) + "</a>"));
                writer.println(this.applyTemplate(dictionary, isPortlet ? PORTLET_WARNING_TEMPLATE : WARNING_TEMPLATE));
            }
            catch (ThemeException te) {
                throw new JspException(MessageTag.getMessageTagError(te.getMessage()), (Throwable)te);
            }
            catch (IOException e) {
                throw new JspException(MessageTag.getMessageTagError(e.getMessage()));
            }
        }
    }

    protected void writeInfoMessages(JspWriter writer, boolean isPortlet) throws JspException {
        String divId = "infoMessage";
        Messages messages = (Messages)this.pageContext.getAttribute("com.sas.framework.webapp.util.MESSAGES", 2);
        String infoMessage = this.createInfoMessage(messages);
        if (infoMessage.length() > 1) {
            try {
                String label = this.getLabel();
                if (null == label && null == (label = messages.getInfoTitle())) {
                    label = RB.getString("Info.txt", this.getUserLocale());
                }
                Dictionary dictionary = new Dictionary();
                dictionary.set((Object)INFO, (Object)label);
                dictionary.set((Object)"ICON", (Object)(this.getImagesPath(true) + this.getIcon()));
                dictionary.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(false));
                dictionary.set((Object)"TITLE_STYLE", (Object)this.getTitleStyleClass());
                dictionary.set((Object)"TEXT_STYLE", (Object)this.getStyleClass());
                dictionary.set((Object)"BG_STYLE", (Object)this.getBgStyleClass());
                dictionary.set((Object)"MESSAGE", (Object)infoMessage);
                dictionary.set((Object)"DIV_ID", (Object)"infoMessage");
                dictionary.set((Object)"CLEAR_MESSAGE", (Object)("<a href=\"javascript:toggleDiv('infoMessage', true);\">" + RB.getString("Message.clear.txt", this.getUserLocale()) + "</a>"));
                writer.println(this.applyTemplate(dictionary, isPortlet ? PORTLET_INFO_TEMPLATE : INFO_TEMPLATE));
            }
            catch (ThemeException te) {
                throw new JspException(MessageTag.getMessageTagError(te.getMessage()), (Throwable)te);
            }
            catch (IOException e) {
                throw new JspException(MessageTag.getMessageTagError(e.getMessage()));
            }
        }
    }

    private Messages mergeErrorMessages() {
        ActionErrors strutsErrors;
        Messages messages = (Messages)this.pageContext.getAttribute("com.sas.framework.webapp.util.MESSAGES", 2);
        if (null == messages) {
            messages = new Messages();
        }
        if (null != (strutsErrors = (ActionErrors)this.pageContext.getAttribute("org.apache.struts.action.ERROR", 2)) && !strutsErrors.isEmpty()) {
            Iterator errorIterator = strutsErrors.get();
            while (errorIterator.hasNext()) {
                ActionMessage error = (ActionMessage)errorIterator.next();
                String msg = null;
                Object[] values = error.getValues();
                msg = null == values || values.length < 1 ? this.getTextFromResource(error.getKey()) : this.getFormattedTextFromResource(error.getKey(), values);
                messages.addError(msg);
            }
        }
        return messages;
    }

    protected String formatErrorMessages() {
        Messages messages = this.mergeErrorMessages();
        String errorMessage = "";
        if (null != messages) {
            int size = messages.getErrorCount();
            StringBuilder sb = new StringBuilder();
            if (size > 1) {
                sb.append(RB.getString("message.error.list.txt", this.getUserLocale()));
                sb.append("\n");
                sb.append("<ul>\n");
            }
            for (int i = 0; i < size; ++i) {
                if (size > 1) {
                    sb.append("   <li>");
                }
                sb.append(messages.getError(i));
                if (size <= 1) continue;
                sb.append("</li>\n");
            }
            if (size > 1) {
                sb.append("</ul>\n");
            }
            errorMessage = sb.toString();
        }
        return errorMessage;
    }

    protected String createWarningMessage(Messages messages) {
        String warningMessage = "";
        if (null != messages) {
            int size = messages.getWarningCount();
            StringBuilder sb = new StringBuilder();
            if (size > 1) {
                sb.append("<ul>\n");
            }
            for (int i = 0; i < size; ++i) {
                if (size > 1) {
                    sb.append("   <li>");
                }
                sb.append(messages.getWarning(i));
                if (size <= 1) continue;
                sb.append("</li>\n");
            }
            if (size > 1) {
                sb.append("</ul>\n");
            }
            warningMessage = sb.toString();
        }
        return warningMessage;
    }

    protected String createInfoMessage(Messages messages) {
        String infoMessage = "";
        if (null != messages) {
            int size = messages.getInfoCount();
            StringBuilder sb = new StringBuilder();
            if (size > 1) {
                sb.append("<ul>\n");
            }
            for (int i = 0; i < size; ++i) {
                if (size > 1) {
                    sb.append("   <li>");
                }
                sb.append(messages.getInfo(i));
                if (size <= 1) continue;
                sb.append("</li>\n");
            }
            if (size > 1) {
                sb.append("</ul>\n");
            }
            infoMessage = sb.toString();
        }
        return infoMessage;
    }

    private static String getMessageTagError(String errorMessage) {
        return "MessageTag. " + errorMessage;
    }
}

