/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.PreferenceHelper;
import com.sas.framework.webapp.taglib.BaseTextElement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;

public class InlineHelpTag
extends BaseTextElement {
    private static final long serialVersionUID = 1L;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        boolean toggle = false;
        toggle = PreferenceHelper.isQuickHelpOn(request);
        JspWriter writer = this.pageContext.getOut();
        String message = this.getTextFromResource(this.getResourceKeyName());
        try {
            writer.print("<div id=\"" + FrameworkHelper.getHelpId(request) + "\" style=\"display:" + (toggle ? "block" : "none") + "\" class=\"" + this.getStyleClass() + "\">");
            writer.print(message);
            writer.print("</div>");
        }
        catch (IOException e) {
            throw new JspException("InlineHelpTag: " + e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    @Override
    protected String getResourceKeyName() {
        String property = this.getProperty();
        if (property.endsWith(".txt")) {
            return property;
        }
        StringBuilder key = new StringBuilder();
        String pageKey = this.getPageKey();
        if (null != pageKey) {
            key.append(pageKey).append('.');
        }
        key.append(property).append(".help.txt");
        return key.toString();
    }
}

