/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.config.UrlGeneratorInterface;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.PreferenceHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseMessageTag;
import com.sas.framework.webapp.util.CachedQuickHelpTopic;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelpTag
extends BaseMessageTag {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(HelpTag.class);
    public static final String SASDOC_SOFTWARE_COMPONENT = "SASDoc";
    public static final String HELP = "HELP";
    public static final String HELPID = "HELPID";
    public static final String MORE_HELP = "MORE_HELP_LABEL";
    public static final String CLEAR = "CLEAR_HELP_LABEL";
    public static final String TOPIC = "HELP_TOPIC";
    public static final String TOGGLE = "DISPLAY_TOGGLE";
    static final String RES = "res";
    static final String SASDOC = "SASdoc";
    static final String QHELP = "qhelp_";
    static final String SASDOC_TOPIC_EXT = ".htm";
    static final String SASDOC_COMMANDS = "_bodyOnly=true";
    public static final String CACHE = "sas_solutions_help_cache";
    public static final int CACHE_SIZE = 50;
    protected static final String DEFAULT_TEMPLATE = "quick_help";
    private String helpsrc = "SASdoc";
    private String pageKey = null;
    private String _topic = null;
    private String docset = null;
    private boolean quickHelp = true;
    private boolean cached = true;

    public HelpTag() {
        this.setTemplate(DEFAULT_TEMPLATE);
    }

    public void setHelpsrc(String src) {
        this.helpsrc = src.equalsIgnoreCase(RES) || src.equalsIgnoreCase(SASDOC) ? src : RES;
    }

    public String getHelpsrc() {
        return this.helpsrc;
    }

    public String getPageKey() {
        String defined = this.getDefinedTopic();
        if (null != defined) {
            return defined;
        }
        if (null != this.pageKey) {
            return this.pageKey;
        }
        return (String)this.pageContext.getAttribute("sas.framework.PageKey", 2);
    }

    public void setPageKey(String pk) {
        this.pageKey = pk;
    }

    public String getTopic() {
        if (null != this._topic) {
            return this._topic;
        }
        return this.getPageKey();
    }

    public void setDocset(String ds) {
        this.docset = ds;
    }

    public String getDocset() {
        return this.docset;
    }

    public void setTopic(String top) {
        this._topic = top;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean flag) {
        this.cached = flag;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (FrameworkHelper.isIncluded(request)) {
            return 0;
        }
        String readMore = this.getTopic();
        if (null != readMore) {
            this.pageContext.setAttribute("sas.framework.taglib.HelpScriptTag.page", (Object)readMore, 2);
        } else {
            this.pageContext.setAttribute("sas.framework.taglib.HelpScriptTag.page", (Object)"NONE", 2);
        }
        boolean helpToggle = false;
        helpToggle = PreferenceHelper.isQuickHelpOn(request);
        if (!helpToggle || !this.isQuickHelp()) {
            request.setAttribute("sas.framework.webapp.quick.help.off", (Object)Boolean.TRUE);
            Properties settings = FrameworkHelper.getApplicationSettings(request);
            String doc = this.getDefinedDocSet(settings);
            this.pageContext.setAttribute("sas.framework.topic.docset", (Object)doc, 2);
            return 0;
        }
        String helpid = FrameworkHelper.getHelpId(request);
        String helpText = this.getQuickHelpTopic();
        JspWriter writer = this.pageContext.getOut();
        if (helpText.length() > 1) {
            try {
                Dictionary dictionary = new Dictionary();
                dictionary.set((Object)HELPID, (Object)helpid);
                Locale userLocale = this.getUserLocale();
                dictionary.set((Object)HELP, (Object)(null == this.getLabel() ? RB.getString("QuickHelp.txt", userLocale) : this.getLabel()));
                dictionary.set((Object)TOGGLE, (Object)(helpToggle ? "block" : "none"));
                dictionary.set((Object)"ICON", (Object)(this.getImagesPath(false) + this.getIcon()));
                dictionary.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(true));
                dictionary.set((Object)"TITLE_STYLE", (Object)this.getTitleStyleClass());
                dictionary.set((Object)"TEXT_STYLE", (Object)this.getStyleClass());
                dictionary.set((Object)"BG_STYLE", (Object)this.getBgStyleClass());
                dictionary.set((Object)"MESSAGE", (Object)helpText);
                dictionary.set((Object)TOPIC, (Object)readMore);
                dictionary.set((Object)MORE_HELP, (Object)RB.getString("MoreHelp.txt", userLocale));
                dictionary.set((Object)CLEAR, (Object)RB.getString("ClearHelp.txt", userLocale));
                writer.println(this.applyTemplate(dictionary, this.getTemplate()));
            }
            catch (ThemeException te) {
                throw new JspException("HelpTag. " + te.getMessage(), (Throwable)te);
            }
            catch (IOException e) {
                throw new JspException("HelpTag. " + e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    protected String getQuickHelpTopic() {
        if (this.getHelpsrc().equalsIgnoreCase(RES)) {
            return this.getTextFromResource(this.getResourceKeyName());
        }
        if (this.isCached()) {
            return this.getCachedHelpText();
        }
        return this.getHelpTextFromSASDoc();
    }

    protected String getCachedHelpText() {
        ServletContext sc = this.pageContext.getServletContext();
        LRUMap cachedTopics = (LRUMap)sc.getAttribute(CACHE);
        if (null == cachedTopics) {
            cachedTopics = new LRUMap(this.getCacheSize());
            sc.setAttribute(CACHE, (Object)cachedTopics);
        }
        String lang = this.getDocLanguage(this.getUserLocale());
        String pagekey = this.getTopic();
        String docs = this.getDefinedDocSet(FrameworkHelper.getApplicationSettings((HttpServletRequest)this.pageContext.getRequest()));
        String key = CachedQuickHelpTopic.createKey(lang, docs, pagekey);
        CachedQuickHelpTopic topic = (CachedQuickHelpTopic)cachedTopics.get((Object)key);
        if (null == topic) {
            String text = this.getHelpTextFromSASDoc();
            topic = new CachedQuickHelpTopic(lang, docs, pagekey, text);
            cachedTopics.put((Object)key, (Object)topic);
        }
        return topic.getHelpText();
    }

    protected String getHelpTextFromSASDoc() {
        String transcodedText = null;
        String encoding = null;
        StringBuilder topic = new StringBuilder();
        try {
            BufferedReader in;
            String sasDocURL = this.getSASDocURL();
            if (sasDocURL.contains("null.hlp")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Quickhelp is not available for this page: " + this.getTopic());
                }
                Locale userLocale = this.getUserLocale();
                return RB.getString("HelpTag.no.quick.help.txt", userLocale);
            }
            URL url = new URL(sasDocURL);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            int statusCode = uc.getResponseCode();
            if (statusCode < 400) {
                String str;
                InputStreamReader isr;
                String contentType = uc.getContentType();
                int charsetIndex = -1;
                if (null != contentType) {
                    charsetIndex = contentType.indexOf("charset=");
                }
                if (charsetIndex >= 0) {
                    encoding = contentType.substring(charsetIndex + "charset=".length());
                    int semiIndex = encoding.indexOf(59);
                    if (semiIndex > 0) {
                        encoding = encoding.substring(0, semiIndex);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Character encoding: " + encoding);
                    }
                    isr = new InputStreamReader(uc.getInputStream(), encoding);
                } else {
                    isr = new InputStreamReader(uc.getInputStream(), "UTF-8");
                }
                in = new BufferedReader(isr);
                while (null != (str = in.readLine())) {
                    topic.append(str);
                    topic.append(" ");
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Received error status code from HTTP request" + statusCode);
                }
                return "Help topic not available. Check your SASDoc configuration.";
            }
            in.close();
            transcodedText = topic.toString();
        }
        catch (MalformedURLException mue) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error reading URL for SASDoc SoftwareComponent:" + mue.getMessage());
            }
            return "Help topic not available. Check your SASDoc configuration.";
        }
        catch (UnsupportedEncodingException uee) {
            transcodedText = topic.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to transcode text to UTF-8; using source encoding ('" + encoding + "').");
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error reading URL for SASDoc topic:" + ioe.getMessage());
            }
            return "Help topic not available. Check your SASDoc configuration.";
        }
        return this.getTopicBody(transcodedText);
    }

    protected String getResourceKeyName() {
        StringBuilder key = new StringBuilder();
        String pageKey = this.getPageKey();
        if (null != pageKey) {
            key.append(pageKey);
            key.append(".help.txt");
        }
        return key.toString();
    }

    private String getDefinedTopic() {
        return (String)this.pageContext.getAttribute("sas.framework.helpTopic", 2);
    }

    private String encode(String value) {
        if (null == value) {
            return value;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private String getSASDocURL() {
        StringBuilder url = new StringBuilder();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        String product = this.getDefinedDocSet(settings);
        String systemnav = this.getSystemDocSet(settings);
        String softwareVersion = FrameworkHelper.getApplicationConfiguration(request).getSoftwareVersion();
        String topic = this.getTopic();
        UrlGeneratorInterface ugi = FrameworkHelper.getUrlGenerator(request);
        String docUrl = ugi.generateUrl("Help Viewer for Midtier App", "", "");
        if (!docUrl.endsWith("/")) {
            docUrl = docUrl + "/";
        }
        url.append(docUrl);
        url.append("help/quickhelp/");
        url.append(this.encode(systemnav)).append("/");
        url.append(this.encode(softwareVersion)).append("/");
        url.append(this.encode(this.getDocLanguage(this.getUserLocale()))).append("/");
        url.append(this.encode(product)).append(".hlp/");
        url.append(QHELP).append(this.encode(topic)).append(SASDOC_TOPIC_EXT).append("?bodyOnly=true");
        this.pageContext.setAttribute("sas.framework.topic.docset", (Object)product, 2);
        return url.toString();
    }

    private String getDefinedDocSet(Properties settings) {
        HttpServletRequest request;
        String applicationKey;
        String doc = settings.getProperty("WebApp.DocSet");
        if (null == doc && !"Logon Manager 9.4".equals(applicationKey = FrameworkHelper.getApplicationKey(request = (HttpServletRequest)this.pageContext.getRequest()))) {
            LOGGER.error("ERROR: There is no docset defined for the " + applicationKey + " application. Check the Application Configuration metadata.");
        }
        return doc;
    }

    private String getTopicDocSet() {
        String doc = (String)this.pageContext.getAttribute("sas.framework.topic.docset", 2);
        return doc;
    }

    private String getSystemDocSet(Properties settings) {
        HttpServletRequest request;
        String applicationKey;
        String doc = settings.getProperty("WebApp.SystemDocSet");
        if (null == doc && !"Logon Manager 9.4".equals(applicationKey = FrameworkHelper.getApplicationKey(request = (HttpServletRequest)this.pageContext.getRequest()))) {
            LOGGER.error("ERROR: There is no system docset defined for the " + applicationKey + " application. Check the Application Configuration metadata.");
        }
        return doc;
    }

    private String getTopicBody(String theTopic) {
        int endpos;
        String topic = theTopic;
        int pos = topic.indexOf("<BODY");
        if (pos < 0) {
            pos = topic.indexOf("<body");
        }
        if (pos > 0) {
            topic = topic.substring(pos);
            topic = topic.substring(topic.indexOf(62) + 1);
        }
        if ((endpos = topic.indexOf("</BODY")) < 0) {
            endpos = topic.indexOf("</body");
        }
        if (endpos > 0) {
            topic = topic.substring(0, endpos);
        }
        if ((pos = topic.indexOf("<P>")) < 0) {
            pos = topic.indexOf("<p>");
        }
        if (pos > 0) {
            topic = topic.substring(pos);
        }
        return topic;
    }

    protected String getDocLanguage(Locale locale) {
        String language = locale.getLanguage();
        if (language == null) {
            return "en";
        }
        String country = locale.getCountry();
        if (country == null || country.trim().length() == 0) {
            return language;
        }
        return language + "_" + country;
    }

    public boolean isQuickHelp() {
        return this.quickHelp;
    }

    public void setQuickHelp(boolean quickHelp) {
        this.quickHelp = quickHelp;
    }

    protected int getCacheSize() {
        return 50;
    }
}

