/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.taglib.BaseTextElement;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;

public class HeadingTag
extends BaseTextElement {
    private static final long serialVersionUID = 1L;
    protected String DEFAULT_TEMPLATE = "heading";
    private String key;
    private String text;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key.trim();
    }

    public int doStartTag() throws JspException {
        if (null == this.getKey() && null == this.getText()) {
            throw new JspException("You must specify either key or text.");
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            Dictionary dict = this.getTemplateDictionary();
            String value = this.applyTemplate(dict, this.DEFAULT_TEMPLATE);
            writer.println(value);
        }
        catch (ThemeException te) {
            throw new JspException("HeadingTag. " + te.getMessage(), (Throwable)te);
        }
        catch (IOException e) {
            throw new JspException("HeadingTag. " + e.getMessage());
        }
        return 0;
    }

    protected Dictionary getTemplateDictionary() throws ThemeException {
        Dictionary dict = new Dictionary();
        dict.set((Object)"STYLE", (Object)this.getStyleClass());
        dict.set((Object)"IMAGE_PATH", (Object)this.getImagesPath(false));
        dict.set((Object)"HEADING", (Object)(null == this.getText() ? this.getTextFromResource(this.getResourceKeyName()) : this.getText()));
        return dict;
    }

    @Override
    protected String getResourceKeyName() {
        String thisKey = this.getKey();
        if (thisKey.endsWith(".txt")) {
            return thisKey;
        }
        StringBuilder strKey = new StringBuilder();
        String pageKey = this.getPageKey();
        if (null != pageKey) {
            strKey.append(pageKey);
            strKey.append('.');
        }
        strKey.append(thisKey);
        strKey.append(".heading.txt");
        return strKey.toString();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

