/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.personalization.PreferredFormat;
import com.sas.framework.personalization.TimeDateFormat;
import com.sas.framework.webapp.taglib.BaseTextSupport;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;

public class DateDisplayTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    String model;
    boolean useCurrent;

    public int doStartTag() throws JspException {
        Date date = this.getDate();
        if (null == date && !this.getUseCurrent()) {
            throw new JspException("No date found");
        }
        if (null == date) {
            date = new Date();
        }
        String value = this.convertDate(date);
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(value);
        }
        catch (IOException ioe) {
            throw new JspException("Unable to print date", (Throwable)ioe);
        }
        return 0;
    }

    private String convertDate(Date date) {
        String formattedDate;
        try {
            Locale locale = this.getUserLocale();
            TimeDateFormat timedate = this.getPreferenceResolver().getTimeDateFormat();
            formattedDate = PreferredFormat.getTimeDate((TimeDateFormat)timedate, (Date)date, (Locale)locale);
        }
        catch (Exception e) {
            formattedDate = "";
        }
        formattedDate = "".equals(formattedDate) ? "&nbsp;" : formattedDate;
        return formattedDate;
    }

    private Date getDate() {
        return (Date)this.pageContext.findAttribute(this.getModel());
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public boolean getUseCurrent() {
        return this.useCurrent;
    }

    public void setUseCurrent(boolean useCurrent) {
        this.useCurrent = useCurrent;
    }
}

