/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.themes.client.Image;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import com.sas.servlet.tbeans.html.ColorPicker;
import com.sas.servlet.tbeans.models.Item;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;

public class ColorPickerTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_TEMPLATE = "color_picker";
    private static final String DEFAULT_COLOR = "white";
    private String name;
    private static final String COLOR_IMAGE = "color_image";
    private String defaultColor;

    public ColorPickerTag() {
        this.setTemplate(DEFAULT_TEMPLATE);
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        String colorlist = RB.getString("ColorPickerTag.colorlist.notrans");
        String[] colors = colorlist.split(",");
        Locale locale = this.getUserLocale();
        ArrayList<Item> colorList = new ArrayList<Item>();
        for (int i = 0; i < colors.length; ++i) {
            String colorName = RB.getString("ColorPickerTag." + colors[i] + ".txt", locale);
            Item next = new Item(colorName, "#" + colors[i]);
            colorList.add(next);
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ColorPicker picker = new ColorPicker();
        picker.setRequest(request);
        picker.setId(this.getName());
        picker.setAutomaticVisible(false);
        picker.setModel(colorList);
        picker.setDefaultColor(this.getDefaultColor());
        picker.setLocale(this.getUserLocale());
        Image img = ThemeHelper.getImageFile(this.getTheme(), COLOR_IMAGE);
        String image = img.getFile();
        picker.setLaunchImage(image.substring(image.lastIndexOf("/") + 1));
        try {
            picker.write((Writer)out);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDefaultColor() {
        return null != this.defaultColor && !"".equals(this.defaultColor.trim()) ? this.defaultColor : DEFAULT_COLOR;
    }

    public void setDefaultColor(String d) {
        this.defaultColor = d;
    }
}

