/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.resolvers.PreferenceResolverInterface;
import com.sas.framework.personalization.ShortDateFormat;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Calendar;
import com.sas.servlet.tbeans.html.DatePicker;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CalendarPickerTag
extends UIBodyTagSupport {
    private static final Logger LOGGER = LogManager.getLogger(CalendarPickerTag.class);
    private static final long serialVersionUID = 1L;
    public static final String START_DAY = "sas.CalendarPicker.StartDay";
    public static final String SHOW_WEEKS = "sas.CalendarPicker.ShowWeeks";
    private boolean showToday;
    private String property;

    public boolean isShowToday() {
        return this.showToday;
    }

    public void setShowToday(boolean flag) {
        this.showToday = flag;
    }

    protected boolean isCalendarWeekNumberDisplayed(HttpServletRequest request) {
        Boolean showWeeks = (Boolean)request.getAttribute(SHOW_WEEKS);
        if (null != showWeeks) {
            return showWeeks;
        }
        PreferenceResolverInterface pri = FrameworkHelper.getPreferenceResolver(request);
        showWeeks = pri.getBooleanPreference("Calendar.ShowWeekNumber");
        request.setAttribute(SHOW_WEEKS, (Object)showWeeks);
        return showWeeks;
    }

    protected int getWeekStartDay(HttpServletRequest request) {
        try {
            PreferenceResolverInterface pri = FrameworkHelper.getPreferenceResolver(request);
            int day = pri.getIntPreference("Calendar.StartDay");
            return day;
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String getDateFormat() {
        ShortDateFormat sdf = this.getPreferenceResolver().getShortDateFormat();
        String format = sdf.getPattern(this.getUserLocale());
        return format;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String prop) {
        this.property = prop;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        DatePicker picker = new DatePicker();
        picker.setRequest(request);
        picker.setLocale(this.getUserLocale());
        picker.setId(this.getProperty());
        TextEntry textEntry = (TextEntry)picker.getComponent("TEXT_ENTRY_COMPONENT");
        textEntry.setSize(11);
        Calendar cal = (Calendar)picker.getComponent("CALENDAR_COMPONENT");
        cal.setDisplayToday(this.isShowToday());
        cal.setDisplayWeekNumbers(this.isCalendarWeekNumberDisplayed(request));
        cal.setWeekStartingDay(this.getWeekStartDay(request));
        JspWriter out = this.pageContext.getOut();
        try {
            String dateFormat = this.getDateFormat();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            picker.setFormat(sdf);
            String value = request.getParameter(this.getProperty());
            if (null == value || "".equals(value.trim())) {
                value = (String)this.pageContext.findAttribute(this.getProperty());
            }
            if (null != value && !"".equals(value.trim())) {
                try {
                    picker.setDate(sdf.parse(value));
                }
                catch (ParseException e) {
                    LOGGER.error("Unable to parse provided date value, '" + value + "' with format, '" + dateFormat + "'.");
                }
            }
            picker.write((Writer)out);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }
}

