/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.BaseTextSupport;
import com.sas.swing.util.Action;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

public class ButtonTag
extends BaseTextSupport {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FIELD_NAME = "command";
    private String actionKey;
    private int formNumber = 0;
    private boolean useHidden = true;
    private String function = null;
    private boolean submitForm = true;
    private String type = "button";
    private String styleClassHover = "buttonhover";
    private String hiddenFieldName = "command";

    public String getStyleClassHover() {
        return this.styleClassHover;
    }

    public void setStyleClassHover(String styleHover) {
        this.styleClassHover = styleHover;
    }

    public void setFormNumber(int number) {
        this.formNumber = number;
    }

    public int getFormNumber() {
        return this.formNumber;
    }

    public void setActionKey(String key) {
        this.actionKey = key;
    }

    public String getActionKey() {
        return this.actionKey;
    }

    public void setUseHidden(boolean hidden) {
        this.useHidden = hidden;
    }

    public boolean getUseHidden() {
        return this.useHidden;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            Properties settings = FrameworkHelper.getApplicationSettings(request);
            String actionBundle = settings.getProperty("WebApp.Actions");
            ResourceBundle rb = ResourceBundle.getBundle(actionBundle, this.getUserLocale());
            ActionResourceLoader map = new ActionResourceLoader(rb, (Object)this);
            Action action = map.getAction(this.getActionKey());
            String actionName = (String)action.getValue("Name");
            String actKey = (String)action.getValue("ActionCommandKey");
            this.addToButtonList(actKey);
            StringBuffer onClick = new StringBuffer();
            if (null != this.getFunction()) {
                onClick.append(this.getFunction());
                onClick.append(";");
            }
            if (this.getSubmitForm()) {
                onClick.append("doAction(");
                onClick.append(String.valueOf(this.getFormNumber()));
                onClick.append(", '");
                Object actionCommand = action.getValue("command.notrans");
                onClick.append(actionCommand);
                onClick.append("','").append(this.getFieldName());
                onClick.append("');");
            }
            String name = actionName.length() <= 3 ? "&nbsp;" + actionName + "&nbsp;" : actionName;
            StringBuffer retVal = new StringBuffer(150);
            retVal.append("<input id=\"" + actKey + "\" type=\"" + this.getType() + "\" class=\"" + this.getStyleClass() + "\" value=\"");
            retVal.append(name);
            retVal.append("\" onClick=\"");
            retVal.append(onClick.toString());
            retVal.append("\" onmouseover=\"this.className='" + this.getStyleClass() + " " + this.getStyleClassHover() + "'\" onmouseout=\"this.className='" + this.getStyleClass() + "'\"/>");
            out.println(retVal.toString());
            if (this.getUseHidden()) {
                out.println("<input type=\"hidden\" name=\"" + this.getFieldName() + "\" value=\"\" />");
            }
        }
        catch (IOException ioe) {
            throw new JspException("ButtonTag: " + ioe.getMessage());
        }
        return 0;
    }

    public String getFieldName() {
        return this.hiddenFieldName;
    }

    public void setFieldName(String f) {
        this.hiddenFieldName = f;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String fctn) {
        this.function = fctn;
    }

    public boolean getSubmitForm() {
        return this.submitForm;
    }

    public void setSubmitForm(boolean submit) {
        this.submitForm = submit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    private void addToButtonList(String key) {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ArrayList<String> list = (ArrayList<String>)request.getAttribute("sas.framework.webapp.buttons.list");
        if (null == list) {
            list = new ArrayList<String>();
            request.setAttribute("sas.framework.webapp.buttons.list", list);
        }
        list.add(key);
    }

    @Override
    public String getStyleClass() {
        String clazz = super.getStyleClass();
        return null != clazz ? clazz : "button";
    }
}

