/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

public class ButtonBarTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_FIELD_NAME = "command";
    private static final String NBSP = "&nbsp;";
    private String actionKey = "";
    private String formNumber = "0";
    private String stylePrefix = "";
    private boolean useHidden = true;
    private String function;
    private String hiddenFieldName = "command";
    protected static final String DEFAULT_TEMPLATE = "buttonbar";

    public ButtonBarTag() {
        this.setTemplate(DEFAULT_TEMPLATE);
    }

    public void setStylePrefix(String prefix) {
        this.stylePrefix = prefix;
    }

    public String getStylePrefix() {
        return this.stylePrefix;
    }

    public void setFormNumber(String number) {
        this.formNumber = number;
    }

    public String getFormNumber() {
        return this.formNumber;
    }

    public void setActionKey(String key) {
        this.actionKey = key;
    }

    public String getActionKey() {
        return this.actionKey;
    }

    public void setUseHidden(boolean hidden) {
        this.useHidden = hidden;
    }

    public boolean getUseHidden() {
        return this.useHidden;
    }

    public String getFieldName() {
        return this.hiddenFieldName;
    }

    public void setFieldName(String f) {
        this.hiddenFieldName = f;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            Dictionary dict = this.getTemplateDictionary();
            String value = this.applyTemplate(dict, this.getTemplate());
            out.println(value);
            if (this.getUseHidden()) {
                out.println("<input type=\"hidden\" name=\"" + this.getFieldName() + "\" value=\"\">");
            }
        }
        catch (ThemeException te) {
            throw new JspException("ButtonBarTag: " + te.getMessage(), (Throwable)te);
        }
        catch (IOException ioe) {
            throw new JspException("ButtonBarTag: " + ioe.getMessage(), (Throwable)ioe);
        }
        return 0;
    }

    protected Dictionary getTemplateDictionary() throws ThemeException {
        Dictionary dict = new Dictionary();
        dict.set((Object)"STYLE_CLASS", (Object)(this.getStylePrefix() + "buttonBar"));
        dict.set((Object)"BUTTONS", (Object)this.getButtonHTML());
        return dict;
    }

    protected String getButtonHTML() {
        StringBuilder b = new StringBuilder();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Properties settings = FrameworkHelper.getApplicationSettings(request);
        String actionBundle = settings.getProperty("WebApp.Actions");
        ResourceBundle rb = ResourceBundle.getBundle(actionBundle, this.getUserLocale());
        ActionResourceLoader map = new ActionResourceLoader(rb, (Object)this);
        ActionList actionList = map.getActionList(this.getActionKey());
        int count = 0;
        for (Action currentAction : actionList.getActions()) {
            String actKey = (String)currentAction.getValue("ActionCommandKey");
            String actionName = (String)currentAction.getValue("Name");
            String name = actionName.length() <= 3 ? NBSP + actionName + NBSP : actionName;
            this.addToButtonList(actKey);
            StringBuilder onClick = new StringBuilder();
            if (null != this.getFunction()) {
                onClick.append(this.getFunction()).append(';');
            }
            onClick.append("doAction(").append(String.valueOf(this.getFormNumber())).append(", '");
            Object actionCommand = currentAction.getValue("command.notrans");
            onClick.append(actionCommand).append("','").append(this.getFieldName()).append("');");
            StringBuilder retVal = new StringBuilder(150);
            retVal.append("<input id=\"").append(actKey).append("\" type=\"button\" class=\"button\" value=\"").append(name).append("\" onClick=\"").append(onClick.toString()).append("\" onmouseover=\"this.className='button buttonhover'\" onmouseout=\"this.className='button'\"/>");
            b.append(NBSP);
            if (0 == count) {
                b.append(NBSP);
            }
            b.append("     ").append(retVal.toString()).append(NBSP);
            ++count;
        }
        return b.toString();
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String fnct) {
        this.function = fnct;
    }

    private void addToButtonList(String key) {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ArrayList<String> list = (ArrayList<String>)request.getAttribute("sas.framework.webapp.buttons.list");
        if (null == list) {
            list = new ArrayList<String>();
            request.setAttribute("sas.framework.webapp.buttons.list", list);
        }
        list.add(key);
    }
}

