/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.framework.config.ApplicationConfiguration;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.taglib.UIBodyTagSupport;
import com.sas.util.Strings;
import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseTextSupport
extends UIBodyTagSupport {
    private static final long serialVersionUID = -8467368227909894069L;
    protected static final String MISSING_RESOURCE = "! MISSING-RESOURCE !";
    protected static final String APPLICATION_NAME_KEY = "application.name.txt";
    protected static final String DEFAULT_RESOURCE = "com.sas.framework.webapp.i18n.AppResources";
    private String res = null;
    private boolean encodeText = true;

    public String getRes() {
        return this.res;
    }

    public void setRes(String r) {
        this.res = r;
    }

    protected String getTextFromResource(String thisKey) {
        ResourceBundle rb = this.getResourceFromContext();
        String text = "";
        try {
            text = rb.getString(thisKey);
        }
        catch (MissingResourceException mre) {
            text = MISSING_RESOURCE;
        }
        if (this.isEncodeText()) {
            text = Strings.quoteForXML((String)text);
        }
        return text;
    }

    protected String getFormattedTextFromResource(String key, Object[] args) {
        ResourceBundle rb = this.getResourceFromContext();
        String text = "";
        try {
            String format = rb.getString(key);
            text = MessageFormat.format(format, args);
        }
        catch (MissingResourceException mre) {
            text = MISSING_RESOURCE;
        }
        if (this.isEncodeText()) {
            text = Strings.quoteForXML((String)text);
        }
        return text;
    }

    private ResourceBundle getResourceFromContext() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String resToUse = this.getRes();
        if (null == resToUse) {
            resToUse = FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Resources");
        } else if (resToUse.equalsIgnoreCase("default") || null == resToUse) {
            resToUse = DEFAULT_RESOURCE;
        }
        ResourceBundle rb = ResourceBundle.getBundle(resToUse, this.getUserLocale());
        return rb;
    }

    public boolean isEncodeText() {
        return this.encodeText;
    }

    public void setEncodeText(boolean encode) {
        this.encodeText = encode;
    }

    protected String getApplicationDisplayName() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String appname = this.getTextFromApplicationSettings(APPLICATION_NAME_KEY);
        if (appname.equals(MISSING_RESOURCE)) {
            ApplicationConfiguration config = FrameworkHelper.getApplicationConfiguration(request);
            appname = config.getDescription();
        }
        return appname;
    }

    private String getTextFromApplicationSettings(String thisKey) {
        ResourceBundle rb = this.getResourceFromApplicationSettings();
        String text = "";
        try {
            text = rb.getString(thisKey);
        }
        catch (MissingResourceException mre) {
            text = MISSING_RESOURCE;
        }
        if (this.isEncodeText()) {
            text = Strings.quoteForXML((String)text);
        }
        return text;
    }

    private ResourceBundle getResourceFromApplicationSettings() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String resToUse = FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Resources");
        if (null == resToUse) {
            resToUse = DEFAULT_RESOURCE;
        }
        ResourceBundle rb = ResourceBundle.getBundle(resToUse, this.getUserLocale());
        return rb;
    }
}

