/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.taglib;

import com.sas.collection.Dictionary;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.commons.util.BackToLink;
import com.sas.framework.commons.util.Breadcrumbs;
import com.sas.framework.personalization.HelpSetting;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.helpers.UserHelper;
import com.sas.framework.webapp.i18n.RB;
import com.sas.framework.webapp.taglib.BaseTemplateSupport;
import com.sas.servlet.tbeans.html.Banner;
import com.sas.swing.util.Action;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BannerTag
extends BaseTemplateSupport {
    private static final long serialVersionUID = 1L;
    private final Banner banner = new Banner(true);
    public static final String HELP_MENU_ID = "sasHELP_MENU_ID";
    protected static final String DEFAULT_TEMPLATE = "genericBanner";
    protected static final String DEFAULT_ACTIONS = "com.sas.framework.webapp.i18n.Actions";
    protected static final String BANNER_TITLE = "BANNER_TITLE";
    protected static final String BANNER_TITLE2 = "BANNER_TITLE2";
    protected static final String BANNER_BACKGROUND = "BANNER_BACKGROUND";
    protected static final String IMAGE_PATH = "IMAGE_PATH";
    protected static final String LOGO = "LOGO";
    protected static final String GLOBAL_MENU = "GLOBAL_MENU";
    protected static final String WELCOME_TEXT = "WELCOME_TEXT";
    protected static final String BREADCRUMB1 = "BREADCRUMB1";
    protected static final String BREADCRUMB2 = "BREADCRUMB2";
    protected static final String BREADCRUMB3 = "BREADCRUMB3";
    protected static final String BULLET = "BULLET";
    protected static final String BANNER_BACKGROUND_IMAGE = "banner_background";
    protected static final String BANNER_DOWN_ARROW_IMAGE = "Banner_downArrow";
    private String returnToAction = "ReturnToPortal";
    private String returnToAppAction = "ReturnToApp";
    private String preferencesAction = "Preferences";
    private String logoffAction = "Logoff";
    private String image = "logo";
    private String separator = "util_menu_separator";
    private static final Logger LOGGER = LogManager.getLogger(BannerTag.class);
    private String actionResource;

    public String getPreferencesAction() {
        return this.preferencesAction;
    }

    public void setPreferencesAction(String pa) {
        this.preferencesAction = pa;
    }

    public String getLogoffAction() {
        return this.logoffAction;
    }

    public void setLogoffAction(String loa) {
        this.logoffAction = loa;
    }

    public String getHelpAction() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if ("DISABLED".equals(request.getAttribute("sas_solutions_help_menu"))) {
            return "";
        }
        HelpSetting help = this.getPreferenceResolver().getHelpSetting();
        if (null == help || help.getKey().equals(HelpSetting.OFF.getKey())) {
            request.setAttribute("sas.framework.help.popup.menu", (Object)"HelpMenu");
            return "Help";
        }
        if (help.getKey().equals(HelpSetting.ON.getKey())) {
            request.setAttribute("sas.framework.help.popup.menu", (Object)"HelpMenuQuickHelp");
            return "HelpUIOn";
        }
        request.setAttribute("sas.framework.help.popup.menu", (Object)"HelpMenuQuickHelpAlwaysOn");
        return "HelpUIAlways";
    }

    public String getReturnToAction() {
        return this.returnToAction;
    }

    public void setReturnToAction(String rta) {
        this.returnToAction = rta;
    }

    public String getReturnToAppAction() {
        return this.returnToAppAction;
    }

    public void setReturnToAppAction(String rtapp) {
        this.returnToAppAction = rtapp;
    }

    public String getActionResource() {
        return this.actionResource;
    }

    public void setActionResource(String ar) {
        this.actionResource = ar;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String img) {
        this.image = img;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public int doStartTag() throws JspException {
        Breadcrumbs crumbs;
        Stack backStack;
        JspWriter writer = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.banner.setRequest(request);
        this.banner.setResponse((HttpServletResponse)this.pageContext.getResponse());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting up Framework BannerTag for: " + this.getBannerTitle());
        }
        this.banner.setTitle(this.getBannerTitle());
        this.banner.setSecondaryTitle(this.getBannerAddOn(request));
        this.banner.setBreadCrumb1("");
        this.banner.setBreadCrumb2("");
        this.banner.setPreferencesURL(null);
        this.banner.setLogOffURL(null);
        String returnTo = (String)request.getAttribute("sas_solutions_return_to_menu");
        String returnToApp = (String)request.getAttribute("sas_solutions_return_to_app_menu");
        if (!"DISABLED".equals(returnTo) && !"DISABLED".equals(returnToApp) && null != (backStack = (Stack)this.pageContext.findAttribute("sas.framework.BackURLStack")) && !backStack.isEmpty() && null != (crumbs = (Breadcrumbs)backStack.peek()) && crumbs.hasBreadcrumbs()) {
            List links = crumbs.getLinks();
            int i = 0;
            for (BackToLink link : links) {
                String menu = this.getMenuItem(link.getLabel(), link.getLabel(), "Return?link=" + i, "BannerBackArrowYellow.gif", false, "breadcrumb" + i);
                if (i == 0) {
                    this.banner.setBreadCrumb1(menu);
                } else {
                    this.banner.setBreadCrumb2(menu);
                }
                ++i;
            }
        }
        if (null != this.getLogoffAction()) {
            String logoffURL = this.getURL("sas_solutions_logoff_menu", this.getLogoffAction());
            if (!"".equals(logoffURL.trim())) {
                if (!logoffURL.contains("_locale")) {
                    logoffURL = !logoffURL.contains("?") ? logoffURL + "?" : logoffURL + "&";
                    try {
                        logoffURL = logoffURL + "_locale=" + URLEncoder.encode(request.getLocale().toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.warn("Received UnsupportedEncodingException for 'UTF-8'. Locale parameter will not be added.");
                        logoffURL = logoffURL.substring(0, logoffURL.length() - 1);
                    }
                }
                this.banner.setLogOffURL(logoffURL);
            }
            String userid = UserHelper.getUserName(request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Userid for logoff is: " + userid);
            }
            this.banner.setUserName(userid);
        }
        String prefsURL = this.getURL("sas_solutions_preferences_menu", this.getPreferencesAction());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Prefs URL is: " + prefsURL);
        }
        if (!"".equals(prefsURL.trim())) {
            this.banner.setPreferencesURL(prefsURL);
        }
        String helpURL = this.getURL("sas_solutions_help_menu", this.getHelpAction());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Help URL is: " + helpURL);
        }
        if (!"".equals(helpURL)) {
            this.banner.setHelpMenuItemId(HELP_MENU_ID);
            this.banner.setHelpDocURL(helpURL);
        }
        try {
            this.banner.write((Writer)writer);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("</div>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        if (null != this.bodyContent && null != this.bodyContent.getString() && this.bodyContent.getString().length() == 0) {
            this.banner.writeContentDivider(new PrintWriter((Writer)out));
        }
        return 6;
    }

    protected String getBannerTitle() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String banner = (String)request.getAttribute("com.sas.web.title");
        if (null == banner) {
            banner = this.getApplicationDisplayName();
        }
        return banner;
    }

    protected String getBullet(HttpServletRequest request) {
        if (!"".equals(this.getBannerAddOn(request))) {
            return "&bull;";
        }
        return "";
    }

    protected String getBannerAddOn(HttpServletRequest request) {
        String addon = (String)request.getAttribute("sas.framework.AppTitle");
        if (null == addon) {
            addon = "";
        }
        return addon;
    }

    protected String getUtilityMenuItem(String menuType, String theActionKey, boolean hasSeparator) throws ThemeException {
        String actionKey = theActionKey;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String returnTo = (String)request.getAttribute(menuType);
        if (null != returnTo) {
            if (returnTo.equalsIgnoreCase("DISABLED")) {
                return "";
            }
            actionKey = returnTo;
        }
        Action action = this.getActionFromResource(actionKey);
        String label = (String)action.getValue("Name");
        String desc = (String)action.getValue("ShortDescription");
        Object actionCommand = action.getValue("command.notrans");
        String url = String.valueOf(actionCommand);
        String img = (String)action.getValue("SmallIconName");
        if ("sas_solutions_return_to_app_menu".equals(menuType)) {
            label = MessageFormat.format(label, this.getLabelArgs());
            desc = MessageFormat.format(desc, this.getLabelArgs());
        }
        if ("sas_solutions_logoff_menu".equals(menuType)) {
            String userid = UserHelper.getUserName(request);
            label = MessageFormat.format(label, userid);
        }
        return this.getMenuItem(label, desc, url, img, hasSeparator, actionKey);
    }

    protected String getMenuItem(String label, String desc, String theURL, String img, boolean hasSeparator, String actionKey) throws ThemeException {
        String escapedLabel = StringEscapeUtils.escapeHtml4((String)label);
        String url = theURL;
        StringBuilder menu = new StringBuilder();
        if (null != img && !"".equals(img)) {
            menu.append("<img src=\"").append(this.getImagesPath(true)).append(img);
            menu.append("\" alt=\"").append(escapedLabel).append("\" />");
        }
        if (null != url && !"".equals(url)) {
            if (!url.startsWith("javascript")) {
                String tmp = url;
                url = this.getContextPath(true) + tmp;
            }
            menu.append("<a id=\"").append(actionKey).append("\" target=\"_top\" href=\"");
            menu.append(url).append("\"");
            if (null != desc) {
                menu.append(" onmouseover=\"window.status='");
                menu.append(StringEscapeUtils.escapeHtml4((String)StringEscapeUtils.escapeEcmaScript((String)desc))).append("';return true\"");
            }
            if (null != this.getStyleClass()) {
                menu.append(" class=\"").append(this.getStyleClass()).append("\"");
            }
            menu.append(">").append(escapedLabel);
            if (actionKey.equals("Help")) {
                menu.append(this.getHelpMenuImage());
            }
            menu.append("</a>");
        } else {
            menu.append("<span class=\"").append(this.getStyleClass()).append("\">");
            menu.append(escapedLabel).append("</span>");
        }
        if (hasSeparator) {
            Dictionary d = new Dictionary();
            d.set((Object)IMAGE_PATH, (Object)this.getImagesPath(true));
            menu.append(this.applyTemplate(d, this.getSeparator()));
        }
        return menu.toString();
    }

    protected boolean hasReturnToApp() {
        Stack back = (Stack)this.pageContext.getSession().getAttribute("sas.framework.BackURLStack");
        return null != back && !back.isEmpty();
    }

    protected String[] getLabelArgs() {
        Stack backStack = (Stack)this.pageContext.getSession().getAttribute("sas.framework.BackURLStack");
        BackToLink link = (BackToLink)backStack.peek();
        String[] args = new String[]{link.getLabel()};
        return args;
    }

    protected Action getActionFromResource(String thisKey) {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String actionBundle = this.getActionResource();
        if (null == actionBundle) {
            actionBundle = FrameworkHelper.getApplicationSettings(request).getProperty("WebApp.Actions");
        } else if (actionBundle.equalsIgnoreCase("default")) {
            actionBundle = DEFAULT_ACTIONS;
        }
        ResourceBundle rb = ResourceBundle.getBundle(actionBundle, FrameworkHelper.getUserLocale(request));
        if (null == rb) {
            return null;
        }
        ActionResourceLoader map = new ActionResourceLoader(rb, (Object)this);
        return map.getAction(thisKey);
    }

    protected String getHelpMenuImage() throws ThemeException {
        StringBuilder img = new StringBuilder();
        Theme theme = this.getTheme();
        Image helpImage = theme.getImage(BANNER_DOWN_ARROW_IMAGE);
        img.append("&nbsp;<img src=\"");
        img.append(helpImage.getFile());
        img.append("\" alt=\"");
        img.append(RB.getString("BannerTag.down.arrow.txt", this.getUserLocale()));
        img.append("\" border=\"0\" />");
        return img.toString();
    }

    protected HelpSetting getHelpSetting() {
        HelpSetting helpSetting = null;
        helpSetting = this.getPreferenceResolver().getHelpSetting();
        return helpSetting;
    }

    protected String checkAltKey(Image img) {
        String alt;
        String key = img.getAltTextKey();
        if (key != null) {
            alt = this.getTextFromResource(key);
            if ("! MISSING-RESOURCE !".equals(alt)) {
                ResourceBundle rb = ResourceBundle.getBundle("com.sas.framework.webapp.i18n.AppResources", this.getUserLocale());
                try {
                    alt = rb.getString(key);
                }
                catch (MissingResourceException mre) {
                    alt = img.getDescription();
                }
            }
        } else {
            alt = img.getDescription();
        }
        if ("! MISSING-RESOURCE !".equals(alt) || alt == null) {
            alt = "";
        }
        return alt;
    }

    private String getURL(String menuType, String theActionKey) {
        Action action;
        Object actionCommand;
        String url;
        String actionKey = theActionKey;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String returnTo = (String)request.getAttribute(menuType);
        if (null != returnTo) {
            if (returnTo.equalsIgnoreCase("DISABLED")) {
                return "";
            }
            actionKey = returnTo;
        }
        if (null != (url = String.valueOf(actionCommand = (action = this.getActionFromResource(actionKey)).getValue("command.notrans"))) && !"".equals(url) && !url.startsWith("javascript")) {
            String tmp = url;
            url = this.getContextPath(false) + tmp;
        }
        return url;
    }
}

