/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.webapp.util.WebKey;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionListener
implements HttpSessionListener {
    private Logger logger;
    private static final String PATTERN = "ddMMMyyyy:HH:mm:ssz\t";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("ddMMMyyyy:HH:mm:ssz\t");

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        Date now = new Date();
        String msg = " created session " + id + " at " + FORMAT.format(now);
        this.log(event, msg);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        String id = session.getId();
        long created = session.getCreationTime();
        Date now = new Date();
        Date then = new Date();
        then.setTime(created);
        String msg = " destroying session " + id + " at " + FORMAT.format(now) + " that was created at " + FORMAT.format(then);
        this.log(event, msg);
    }

    private void log(HttpSessionEvent event, String value) {
        if (null == this.logger) {
            this.logger = LogManager.getLogger((String)(this.getClass().getName() + "." + this.getWebappContext(event)));
        }
        this.logger.info(value);
    }

    private String getWebappContext(HttpSessionEvent event) {
        ServletContext context = event.getSession().getServletContext();
        String contextName = null;
        if (null != context) {
            contextName = context.getServletContextName();
        }
        if (null == contextName) {
            contextName = "UNKNOWN";
        }
        return WebKey.deblank(contextName);
    }
}

