/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.webapp.helpers.FrameworkHelper;
import com.sas.framework.webapp.servlet.OncePerRequestFilter;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.validation.client.SystemValidationServiceInterface;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SecurityFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger(SecurityFilter.class);
    private UrlGeneratorInterface urlGenerator;
    private SystemValidationServiceInterface systemValidation;

    @Autowired
    public void setUrlGenerator(UrlGeneratorInterface u) {
        this.urlGenerator = u;
    }

    @Autowired(required=false)
    public void setSystemValidation(SystemValidationServiceInterface s) {
        this.systemValidation = s;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean appValidated;
        HttpServletRequest theRequest = (HttpServletRequest)request;
        HttpServletResponse theResponse = (HttpServletResponse)response;
        String appName = FrameworkHelper.getApplicationKey(theRequest);
        if (null != this.systemValidation && null != appName && (appName = appName.trim()).length() > 0 && !(appValidated = this.systemValidation.check(appName))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempt to access unlicensed application: " + appName);
            }
            String url = this.urlGenerator.generateExternalUrl("Logon Manager 9.4", "unlicensed", "");
            theResponse.sendRedirect(theResponse.encodeRedirectURL(url));
            return;
        }
        chain.doFilter(request, response);
    }
}

