/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.commons.util.Sanitizer;
import com.sas.framework.webapp.servlet.OncePerRequestFilter;
import com.sas.framework.webapp.servlet.sanitizers.DefaultCrossSiteScriptingSanitizer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SanitizingRequestFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger(SanitizingRequestFilter.class);
    private final List<String> _allowedPostNames = new ArrayList<String>();
    private Sanitizer _sanitizer = new DefaultCrossSiteScriptingSanitizer();

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        String allowedPostNames = config.getInitParameter("allowedPostNames");
        if (allowedPostNames != null) {
            if (allowedPostNames.contains(",")) {
                StringTokenizer st = new StringTokenizer(allowedPostNames, ",");
                while (st.hasMoreTokens()) {
                    this._allowedPostNames.add(st.nextToken());
                }
            } else {
                this._allowedPostNames.add(allowedPostNames);
            }
        }
    }

    public void setRequestSanitizer(Sanitizer validator) {
        this._sanitizer = validator;
    }

    @Override
    protected void onDoFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        ValidatingRequestWrapper requestWrapper = new ValidatingRequestWrapper(request);
        requestWrapper.setRequestSanitizer(this._sanitizer);
        String queryString = null;
        try {
            queryString = requestWrapper.decode(request.getQueryString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this._sanitizer.matches(queryString)) {
            chain.doFilter((ServletRequest)requestWrapper, resp);
        } else {
            LOGGER.error("Requested rejected due to input sanitization requirements: '" + queryString + "'.");
            HttpServletResponse response = (HttpServletResponse)resp;
            response.sendError(403);
        }
    }

    class ValidatingRequestWrapper
    extends HttpServletRequestWrapper {
        private Sanitizer wrapperSanitizer;

        public ValidatingRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public void setRequestSanitizer(Sanitizer validator) {
            this.wrapperSanitizer = validator;
        }

        public void setAttribute(String name, Object object) {
            Object obj = object;
            if (obj instanceof String && this.getMethod().equalsIgnoreCase("POST")) {
                obj = this.doSanitize(name, (String)obj);
            }
            super.setAttribute(name, obj);
        }

        public String getQueryString() {
            String retval = null;
            retval = this.doSanitize("QueryString", super.getQueryString());
            return retval;
        }

        public String getParameter(String name) {
            String retval = super.getParameter(name);
            if (!"logoutRequest".equals(name)) {
                retval = this.doSanitize(name, retval);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Sanitization is disabled for parameter '" + name + "'");
            }
            return retval;
        }

        public String[] getParameterValues(String name) {
            String[] retval = super.getParameterValues(name);
            if (retval != null) {
                for (int i = 0; i < retval.length; ++i) {
                    retval[i] = this.doSanitize(name, retval[i]);
                }
            }
            return retval;
        }

        private String doSanitize(String name, String value) {
            String retval = value;
            if (!SanitizingRequestFilter.this._allowedPostNames.contains(name)) {
                String decodedValue;
                block5: {
                    decodedValue = null;
                    try {
                        decodedValue = this.decode(value);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isInfoEnabled()) break block5;
                        LOGGER.info("Could not decode the value for POST name: [" + name + "].  Consider adding " + name + " to web.xml allowedPostNames init-param for the SanitizingRequestFilter");
                    }
                }
                if (SanitizingRequestFilter.this._sanitizer.matches(decodedValue)) {
                    retval = this.wrapperSanitizer.sanitize(name, decodedValue);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(value + " was sanitized to " + retval + " based on the configured regular expression");
                    }
                }
            }
            return retval;
        }

        private String decode(String value) throws Exception {
            String retval = value;
            if (value != null) {
                retval = URLDecoder.decode(value, "UTF-8");
                retval = StringEscapeUtils.unescapeHtml4((String)retval);
            }
            return retval;
        }
    }
}

