/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.webapp.servlet.OncePerRequestFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResponseHeaderFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger(ResponseHeaderFilter.class);
    private Properties addHeaders = new Properties();
    private Properties setHeaders = new Properties();
    private final Properties initParameters = new Properties();
    private boolean ieCompabilityMode = true;
    private boolean useInitParamsAsHeaders = true;

    public void setHeadersToAdd(Properties h) {
        this.addHeaders = h;
    }

    public void setHeadersToSet(Properties h) {
        this.setHeaders = h;
    }

    public void setIeCompatibilityMode(boolean m) {
        this.ieCompabilityMode = m;
    }

    public void setUseInitParametersAsHeaders(boolean i) {
        this.useInitParamsAsHeaders = i;
    }

    @Override
    public void onDoFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String value;
        String name;
        HttpServletResponse response = (HttpServletResponse)res;
        Enumeration<?> e = this.initParameters.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.initParameters.getProperty(name);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Adding header on response; name=" + name + ", value=" + value);
            }
            response.addHeader(name, value);
        }
        e = this.addHeaders.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.addHeaders.getProperty(name);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Adding header on response; name=" + name + ", value=" + value);
            }
            response.addHeader(name, value);
        }
        e = this.setHeaders.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.setHeaders.getProperty(name);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Setting header on response; name=" + name + ", value=" + value);
            }
            response.setHeader(name, value);
        }
        chain.doFilter(request, (ServletResponse)response);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying...");
        }
    }

    @Override
    public void init(FilterConfig c) throws ServletException {
        super.init(c);
        LOGGER.info("Initializing...");
        if (this.useInitParamsAsHeaders) {
            Enumeration e = c.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = c.getInitParameter(name);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Saving header; name=" + name + ", value=" + value);
                }
                this.initParameters.setProperty(name, value);
            }
        }
        if (this.ieCompabilityMode) {
            this.addHeaders.setProperty("X-UA-Compatible", "IE=EmulateIE7");
        }
    }
}

