/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JspFilter
implements Filter {
    private static final String DELIMITER = ";";
    private static final String TRUSTED_URL = "trusted.url";
    private static final String DEFAULT_ACTION = "default.action";
    private static final Logger LOGGER = LogManager.getLogger(JspFilter.class);
    String defaultAction;
    static TreeSet trustedURLs = new TreeSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.defaultAction = filterConfig.getInitParameter(DEFAULT_ACTION);
        String urlString = filterConfig.getInitParameter(TRUSTED_URL);
        String[] urls = urlString.split(DELIMITER);
        for (int i = 0; i < urls.length; ++i) {
            if (trustedURLs.contains(urls[i])) continue;
            trustedURLs.add(urls[i]);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest theRequest = (HttpServletRequest)request;
        HttpServletResponse theResponse = (HttpServletResponse)response;
        String uri = theRequest.getRequestURI();
        String action = uri.substring(uri.lastIndexOf("/") + 1);
        if (!trustedURLs.contains(action) && uri.indexOf("/tiles/") < 0) {
            LOGGER.info("JSPFilter caught: " + action);
            if (!(this.defaultAction.startsWith("http:") || this.defaultAction.startsWith("https:") || this.defaultAction.startsWith("/"))) {
                this.defaultAction = theRequest.getContextPath() + "/" + this.defaultAction;
            }
            theResponse.sendRedirect(this.defaultAction);
            return;
        }
        chain.doFilter(request, response);
    }

    static {
        trustedURLs.add("index.jsp");
        trustedURLs.add("welcome.jsp");
        trustedURLs.add("about.jsp");
        trustedURLs.add("pageError.jsp");
        trustedURLs.add("pageNotFound.jsp");
        trustedURLs.add("content.jsp");
        trustedURLs.add("frames.jsp");
    }
}

