/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.webapp.servlet;

import com.sas.framework.themes.client.Theme;
import com.sas.framework.themes.client.ThemeException;
import com.sas.framework.webapp.helpers.ThemeHelper;
import com.sas.framework.webapp.servlet.OncePerRequestFilter;
import com.sas.servlet.util.ComponentPropertyManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger(ComponentFilter.class);

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing... ");
        }
    }

    @Override
    public void onDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            ComponentPropertyManager mgr = ComponentPropertyManager.getInstance((HttpServletRequest)req);
            try {
                Theme theme = ThemeHelper.getTheme(req);
                if (null != theme) {
                    mgr.setImageLocation(theme.getFullPath("IMAGE"));
                    mgr.setStyleLocation(theme.getFullPath("STYLE"));
                    mgr.setTemplateURLLocation(theme.getFullPath("TEMPLATE"));
                }
            }
            catch (ThemeException te) {
                LOGGER.warn("Unable to retrieve the theme. This is likely because noone is logged in.");
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Destroying... ");
        }
    }
}

